/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestInterpretedLexing
extends BaseTest {
    public void testSimpleAltCharTest() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a' | 'b' | 'c';");
        int Atype = g.getTokenType("A");
        Interpreter engine = new Interpreter(g, new ANTLRStringStream("a"));
        engine = new Interpreter(g, new ANTLRStringStream("b"));
        CommonToken result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
        engine = new Interpreter(g, new ANTLRStringStream("c"));
        result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
    }

    public void testSingleRuleRef() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a' B 'c' ;\nB : 'b' ;\n");
        int Atype = g.getTokenType("A");
        Interpreter engine = new Interpreter(g, new ANTLRStringStream("abc"));
        CommonToken result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
    }

    public void testSimpleLoop() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nINT : (DIGIT)+ ;\nfragment DIGIT : '0'..'9';\n");
        int INTtype = g.getTokenType("INT");
        Interpreter engine = new Interpreter(g, new ANTLRStringStream("12x"));
        CommonToken result = engine.scan("INT");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)INTtype);
        engine = new Interpreter(g, new ANTLRStringStream("1234"));
        result = engine.scan("INT");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)INTtype);
    }

    public void testMultAltLoop() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : ('0'..'9'|'a'|'b')+ ;\n");
        int Atype = g.getTokenType("A");
        Interpreter engine = new Interpreter(g, new ANTLRStringStream("a"));
        CommonToken result = engine.scan("A");
        engine = new Interpreter(g, new ANTLRStringStream("a"));
        result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
        engine = new Interpreter(g, new ANTLRStringStream("1234"));
        result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
        engine = new Interpreter(g, new ANTLRStringStream("aaa"));
        result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
        engine = new Interpreter(g, new ANTLRStringStream("aaaa9"));
        result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
        engine = new Interpreter(g, new ANTLRStringStream("b"));
        result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
        engine = new Interpreter(g, new ANTLRStringStream("baa"));
        result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
    }

    public void testSimpleLoops() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : ('0'..'9')+ '.' ('0'..'9')* | ('0'..'9')+ ;\n");
        int Atype = g.getTokenType("A");
        ANTLRStringStream input = new ANTLRStringStream("1234.5");
        Interpreter engine = new Interpreter(g, input);
        CommonToken result = engine.scan("A");
        TestInterpretedLexing.assertEquals((int)result.getType(), (int)Atype);
    }

    public void testTokensRules() throws Exception {
        Grammar pg = new Grammar("grammar p;\na : (INT|FLOAT|WS)+;\n");
        Grammar g = new Grammar();
        g.importTokenVocabulary(pg);
        g.setFileName("<string>");
        g.setGrammarContent("lexer grammar t;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ {channel=99;};\n");
        ANTLRStringStream input = new ANTLRStringStream("123 139.52");
        Interpreter lexEngine = new Interpreter(g, input);
        CommonTokenStream tokens = new CommonTokenStream(lexEngine);
        String result = tokens.toString();
        String expecting = "123 139.52";
        TestInterpretedLexing.assertEquals((String)result, (String)expecting);
    }
}

