#include <stdio.h>
#include <stdlib.h>
#include <gif_lib.h>

struct gif_state {
    FILE         *infile;
    GifFileType  *gif;
};

static void*
gif_init(FILE *fp, char *filename)
{
    struct gif_state *h;
    GifRecordType RecordType;
    GifByteType *Extension;
    int ExtCode, rc;
    
    h = malloc(sizeof(*h));
    memset(h,0,sizeof(*h));

    h->infile = fp;
#if 1
    h->gif = DGifOpenFileHandle(fileno(fp));
#else
    fclose(fp);
    h->gif = DGifOpenFileName(filename);
    if (NULL == h->gif) {
	PrintGifError();
	return NULL;
    }
#endif

    for (;;) {
	if (GIF_ERROR == DGifGetRecordType(h->gif,&RecordType)) {
	    fprintf(stderr,"gif: DGifGetRecordType failed\n");
	    PrintGifError();
	    goto oops;
	}
	switch (RecordType) {
	case EXTENSION_RECORD_TYPE:
	    fprintf(stderr,"gif: EXTENSION_RECORD_TYPE found\n");
	    for (rc = DGifGetExtension(h->gif,&ExtCode,&Extension);
		 NULL != Extension;
		 rc = DGifGetExtensionNext(h->gif,&Extension)) {
		if (rc == GIF_ERROR) {
		    fprintf(stderr,"gif: DGifGetExtension failed\n");
		    PrintGifError();
		    goto oops;
		}
		fprintf(stderr,"gif:   extcode=0x%x\n",ExtCode);
	    }
	    break;
	case IMAGE_DESC_RECORD_TYPE:
	    fprintf(stderr,"gif: IMAGE_DESC_RECORD_TYPE found\n");
	    if (GIF_ERROR == DGifGetImageDesc(h->gif)) {
		fprintf(stderr,"gif: DGifGetImageDesc failed\n");
		PrintGifError();
		goto oops;
	    }

	    /* test case: from this point up I can't call
	       DGifCloseFile() without getting a segfault */
	    fprintf(stderr,"gif: test: closing file now ...\n");
	    DGifCloseFile(h->gif);
	    fclose(h->infile);
	    free(h);
	    return NULL;
	    
	case TERMINATE_RECORD_TYPE:
	    fprintf(stderr,"gif: TERMINATE_RECORD_TYPE found\n");
	    goto oops;
	default:
	    fprintf(stderr,"gif: UNKNOWN record type found\n");
	    goto oops;
	}
    }

 oops:
    fprintf(stderr,"gif: fatal error, aborting\n");
    DGifCloseFile(h->gif);
    fclose(h->infile);
    free(h);
    return NULL;
}

static void
gif_done(void *data)
{
    struct gif_state *h = data;

    fprintf(stderr,"gif: done, cleanup\n");
    DGifCloseFile(h->gif);
    fclose(h->infile);
    free(h);
}

/* ---------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
    FILE *fp;
    void *h;
    
    if (argc < 2) {
	fprintf(stderr,"missing arg\n");
	exit(1);
    }

    fp = fopen(argv[1],"r");
    if (NULL == fp) {
	perror("fopen");
	exit(1);
    }
    h = gif_init(fp,argv[1]);
    if (NULL == h) {
	fprintf(stderr,"gif_open error\n");
	exit(1);
    }
    /* would read (first) image here */
    gif_done(h);
    return 0;
}
