/*  GtkTiEmu - a TI emulator
 *  skn_loader.c: loader of Rusty's skin
 *  Copyright (C) 2000, Thomas Corvazier, Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <jpeglib.h>
#include <unistd.h>
#include "str.h"

#include "tilibs.h"
#include "skn_loader.h"
#include "struct.h"

/* JPEG loader */

unsigned char skinColormap[3][MAX_COLORS];
int skinNumberOfColors;

unsigned char *loadJpg(FILE *fp, int *x, int *y)
{
  struct jpeg_decompress_struct cinfo;
  struct jpeg_error_mgr jerr;
  unsigned char *img, *c;
  int xx, yy;
  int j;

  cinfo.err = jpeg_std_error(&jerr);
  jpeg_create_decompress(&cinfo);
  jpeg_stdio_src(&cinfo, fp);
  jpeg_read_header(&cinfo, TRUE);
  
  //fprintf(stdout, "image_width: %i\n", cinfo.image_width);
  //fprintf(stdout, "image_height: %i\n", cinfo.image_height);
  
  if( (cinfo.image_width > 600) 
      || (cinfo.image_height > 600) ) // rescale image to half if necessary
    {
      cinfo.scale_num = 1;
      cinfo.scale_denom = 2;
    }
  cinfo.quantize_colors = TRUE; // colormapped output wanted
  cinfo.desired_number_of_colors = MAX_COLORS; // decrease color depth
  
  jpeg_start_decompress(&cinfo);
  
  //fprintf(stdout, "output_width: %i\n", cinfo.output_width);
  //fprintf(stdout, "output_height: %i\n", cinfo.output_height);
  //fprintf(stdout, "output_components: %i\n", cinfo.output_components);
  //fprintf(stdout, "out_color_components: %i\n", cinfo.out_color_components);
  
  skinNumberOfColors = cinfo.actual_number_of_colors;
  //fprintf(stdout, "actual_number_of_colors: %i\n", cinfo.actual_number_of_colors);

  for(j=0; j<cinfo.actual_number_of_colors; j++) // copy the colormap
    {
      skinColormap[0][j] = cinfo.colormap[0][j];
      skinColormap[1][j] = cinfo.colormap[1][j];
      skinColormap[2][j] = cinfo.colormap[2][j];
    }
   
  if (cinfo.output_components != 1) // 1: palettized 
    return NULL;

  *x = cinfo.output_width + (cinfo.output_width & 3);
  *y = cinfo.output_height + (cinfo.output_height & 3);
  xx = *x;
  yy = *y;

  img = c = (unsigned char*) malloc(xx * yy); // allocate image
  if(c == NULL) 
    return NULL;

  //c += xx*yy;
  //fprintf(stdout, "output_scanline: %i\n", cinfo.output_scanline);
  while(cinfo.output_scanline < cinfo.output_height) // load jpeg image
    {
      c += xx;
      jpeg_read_scanlines(&cinfo, &c, 1);
    }

  jpeg_finish_decompress(&cinfo);
  jpeg_destroy_decompress(&cinfo);

  return img;
}

/* Skin loader */

RECT_ rcLcd;          // screen coordinates in the skin file
RECT_ rcRectKeys[80]; // coordinates of the TI keys
unsigned char *pSkin = 0;
int xSkin;
int ySkin;
char *sknKey = sknKey89;

int loadSkin(char *fn)
{
  FILE *fp;
  int i;
  char str[9];
  char filename[2*MAXCHARS];
  char *skin_fn = SKINFILE_92;

	strcpy(filename, inst_paths.skin_dir);

  if (ti68k_getCalcType() & TI92) 
    {
      skin_fn = SKINFILE_92;
      sknKey = sknKey92;
    }
  else if (ti68k_getCalcType() & TI89) 
    {
      skin_fn = SKINFILE_89;
      sknKey = sknKey89;
    }
  /* Open the skin file */
  strcat(filename, skin_fn);
  fprintf(stdout, "Loading skin: %s\n", filename);

  if(access(filename, F_OK) != 0)
    {
      fprintf(stdout, "Unable to load the requested skin: it does not exist.\n");
      exit(-1);
    }

  fp = fopen(filename,"rb");
  if(fp == NULL) 
    return 0;

  /* Check the skin version */
  fread(str,8,1,fp);
  str[8]=0;
  fprintf(stdout, "Skin version: %s\n", str);
  if (!strcmp(str,"VTIv2.1 "))
    fseek(fp, 80, SEEK_SET);
  else
    fseek(fp, 144, SEEK_SET); 

  /* Read the skin */
  fseek(fp, 4+4, SEEK_CUR);                 // skip B&W pixel values
  fread(&rcLcd, sizeof(RECT_), 1, fp);      // read the LCD size
  fread(rcRectKeys, sizeof(RECT_), 80, fp); // get skin keys
  pSkin = loadJpg(fp, &xSkin, &ySkin);      // load the image itself
  if(pSkin == NULL) 
    return 0;
  fclose(fp);
  
  for (i=0;i<80;i++)
    {
      rcRectKeys[i].top>>=1;
      rcRectKeys[i].bottom>>=1;
      rcRectKeys[i].left>>=1;
      rcRectKeys[i].right>>=1;
    }
  rcLcd.top>>=1;
  rcLcd.bottom>>=1;
  rcLcd.left>>=1;
  rcLcd.right>>=1;
  
  return 1;
}

char sknKey92[] = 
{
  TIKEY_HAND,
  TIKEY_F1,TIKEY_F2,TIKEY_F3,TIKEY_F4,TIKEY_F5,TIKEY_F6,TIKEY_F7,TIKEY_F8,
  TIKEY_Q,TIKEY_W,TIKEY_E,TIKEY_R,TIKEY_T,TIKEY_Y,TIKEY_U,TIKEY_I,TIKEY_O,
  TIKEY_P,
  TIKEY_A,TIKEY_S,TIKEY_D,TIKEY_F,TIKEY_G,TIKEY_H,TIKEY_J,TIKEY_K,TIKEY_L,
  TIKEY_Z,TIKEY_X,TIKEY_C,TIKEY_V,TIKEY_B,TIKEY_N,TIKEY_M,TIKEY_THETA,
  TIKEY_SHIFT,TIKEY_ON,TIKEY_DIAMOND,TIKEY_2ND,TIKEY_STORE,TIKEY_SPACE,
  TIKEY_EQUALS,
  TIKEY_BACKSPACE,TIKEY_ENTER1,TIKEY_2ND,TIKEY_ESCAPE,TIKEY_MODE,TIKEY_CLEAR,
  TIKEY_LN,
  TIKEY_APPS,TIKEY_ENTER2,TIKEY_LEFT,TIKEY_RIGHT,TIKEY_UP,TIKEY_DOWN,
  TIKEY_SIN,TIKEY_COS,TIKEY_TAN,TIKEY_POWER,TIKEY_PALEFT,TIKEY_PARIGHT,
  TIKEY_COMMA,
  TIKEY_DIVIDE,TIKEY_7,TIKEY_8,TIKEY_9,TIKEY_MULTIPLY,TIKEY_4,TIKEY_5,TIKEY_6,
  TIKEY_MINUS,
  TIKEY_1,TIKEY_2,TIKEY_3,TIKEY_PLUS,TIKEY_0,TIKEY_NEGATE,TIKEY_ENTER1
};

char sknKey89[] =
{
	TIKEY_F1, TIKEY_F2, TIKEY_F3, TIKEY_F4, TIKEY_F5,
	TIKEY_2ND, TIKEY_SHIFT, TIKEY_ESCAPE, TIKEY_LEFT, TIKEY_RIGHT,
	TIKEY_UP, TIKEY_DOWN, TIKEY_DIAMOND, TIKEY_ALPHA, TIKEY_APPS,
	TIKEY_COS, TIKEY_MODE, TIKEY_F6, TIKEY_BACKSPACE, TIKEY_CLEAR,
	TIKEY_X, TIKEY_Y, TIKEY_Z, TIKEY_T, TIKEY_POWER,
	TIKEY_EQUALS, TIKEY_PALEFT, TIKEY_PARIGHT, TIKEY_COMMA, TIKEY_DIVIDE,
	TIKEY_LN, TIKEY_7, TIKEY_8, TIKEY_9, TIKEY_MULTIPLY,
	TIKEY_SIN, TIKEY_4, TIKEY_5, TIKEY_6, TIKEY_MINUS,
	TIKEY_STORE, TIKEY_1, TIKEY_2, TIKEY_3, TIKEY_PLUS,
	TIKEY_ON, TIKEY_0, TIKEY_PERIOD, TIKEY_NEGATE, TIKEY_ENTER1
};
