#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "gtk_colors_cb.h"
#include "gtk_colors_dbox.h"
#include "support.h"

#include "platform.h"
#include "struct.h"
#include "specific.h"

/***************************/
/* 'Number of colors' dbox */
/***************************/

gint tmp_gray_scales;

gint display_ncolors_dbox()
{
  GtkWidget *dbox;
  gpointer user_data;

  dbox = create_ncolors_dbox();
  tmp_gray_scales = *(options.gray_planes);
  
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "radiobutton24");
  if(tmp_gray_scales == 0)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (user_data), TRUE);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "radiobutton25");
  if(tmp_gray_scales == 2)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (user_data), TRUE);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "radiobutton26");
  if(tmp_gray_scales == 5)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (user_data), TRUE);

  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "radiobutton27");
  if(tmp_gray_scales == 11)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (user_data), TRUE);

  gtk_widget_show_all(dbox);
  return 0;
}

void
on_radiobutton24_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tmp_gray_scales = 0;
}


void
on_radiobutton25_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tmp_gray_scales = 2;
}


void
on_radiobutton26_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tmp_gray_scales = 5;
}


void
on_radiobutton27_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  tmp_gray_scales = 11;
}


void
on_button29_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  *(options.gray_planes) = tmp_gray_scales;
  gtk_widget_destroy(user_data);
}


void
on_button30_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(user_data);
}


void
on_ncolors_dbox_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  unsuspend();
}


/***********************/
/* 'D & L colors' dbox */
/***********************/

gulong tmp_darkcol, tmp_lightcol;

int display_dlcolors_dbox()
{
  GtkWidget *dbox;
  gpointer user_data;
  gchar buffer[MAXCHARS];

  dbox = create_dlcolors_dbox();
  
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "entry5");
  tmp_darkcol = *(options.dark_color);
  g_snprintf(buffer, MAXCHARS, "0x%06x", 
	     (unsigned int) *(options.dark_color));
  gtk_entry_set_text((GtkEntry *)user_data, buffer);
  
  user_data = gtk_object_get_data(GTK_OBJECT(dbox), "entry6");
  tmp_lightcol = *(options.light_color);
  g_snprintf(buffer, MAXCHARS, "0x%06x", 
	     (unsigned int) *(options.light_color));
  gtk_entry_set_text((GtkEntry *)user_data, buffer);

  gtk_widget_show_all(dbox);
  return 0;
}


void
on_entry5_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *s;

  s = gtk_editable_get_chars((GtkEditable *)(user_data), 0, -1);
  if(sscanf(s, "0x%6x", (unsigned int *) &tmp_darkcol) < 1)
    tmp_darkcol =  0x000034;

  g_free(s);
}


void
on_entry6_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *s;

  s = gtk_editable_get_chars((GtkEditable *)(user_data), 0, -1);
  if(sscanf(s, "0x%6x", (unsigned int *) &tmp_lightcol) < 1)
    tmp_lightcol =  0x989898;

  g_free(s);
}


void
on_button31_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  *(options.dark_color) = tmp_darkcol;
  *(options.light_color) = tmp_lightcol;

  gtk_widget_destroy(user_data);
}


void
on_button32_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(user_data);
}


void
on_dlcolors_dbox_destroy               (GtkObject       *object,
                                        gpointer         user_data)
{
  unsuspend();
}

/* */
