#ifndef DMO_H
#define DMO_H

/*
 *
 * Definition of important DMO interfaces.
 * Created using freely-available DirectX 8.1 SDK
 * ( http://msdn.microsoft.com )
 *
 */

#include "dshow/iunk.h"
#include "dshow/guids.h"

typedef AM_MEDIA_TYPE DMO_MEDIA_TYPE;

enum _DMO_INPUT_DATA_BUFFER_FLAGS
{
    DMO_INPUT_DATA_BUFFERF_SYNCPOINT	= 0x1,
    DMO_INPUT_DATA_BUFFERF_TIME		= 0x2,
    DMO_INPUT_DATA_BUFFERF_TIMELENGTH	= 0x4
};

enum _DMO_OUTPUT_DATA_BUFFER_FLAGS
{ 
    DMO_OUTPUT_DATA_BUFFERF_SYNCPOINT       = 0x00000001,
    DMO_OUTPUT_DATA_BUFFERF_TIME            = 0x00000002,
    DMO_OUTPUT_DATA_BUFFERF_TIMELENGTH      = 0x00000004,
    DMO_OUTPUT_DATA_BUFFERF_INCOMPLETE      = 0x01000000
};

enum _DMO_INPUT_STATUS_FLAGS
{
    DMO_INPUT_STATUSF_ACCEPT_DATA	= 0x1
};

enum _DMO_INPUT_STREAM_INFO_FLAGS
{
    DMO_INPUT_STREAMF_WHOLE_SAMPLES	= 0x1,
    DMO_INPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER	= 0x2,
    DMO_INPUT_STREAMF_FIXED_SAMPLE_SIZE	= 0x4,
    DMO_INPUT_STREAMF_HOLDS_BUFFERS	= 0x8
};

enum _DMO_OUTPUT_STREAM_INFO_FLAGS
{
    DMO_OUTPUT_STREAMF_WHOLE_SAMPLES	= 0x1,
    DMO_OUTPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER	= 0x2,
    DMO_OUTPUT_STREAMF_FIXED_SAMPLE_SIZE	= 0x4,
    DMO_OUTPUT_STREAMF_DISCARDABLE	= 0x8,
    DMO_OUTPUT_STREAMF_OPTIONAL		= 0x10
};

enum _DMO_SET_TYPE_FLAGS
{
    DMO_SET_TYPEF_TEST_ONLY		= 0x1,
    DMO_SET_TYPEF_CLEAR			= 0x2
};

enum _DMO_PROCESS_OUTPUT_FLAGS
{
    DMO_PROCESS_OUTPUT_DISCARD_WHEN_NO_BUFFER	= 0x1
};

enum _DMO_VIDEO_OUTPUT_STREAM_FLAGS
{
    DMO_VOSF_NEEDS_PREVIOUS_SAMPLE	= 0x1
};

/* MediaErr.h */
#define DMO_E_INVALIDSTREAMINDEX 0x80040201
#define DMO_E_INVALIDTYPE        0x80040202
#define DMO_E_TYPE_NOT_SET       0x80040203
#define DMO_E_NOTACCEPTING       0x80040204
#define DMO_E_TYPE_NOT_ACCEPTED  0x80040205
#define DMO_E_NO_MORE_ITEMS      0x80040206

#endif /* DMO_H */
