/*
 *	Emulation for the NEC PD4990A.
 *
 *	The PD4990A is a serial I/O Calendar & Clock IC used in the
 *      NEO GEO and probably a couple of other machines.
 */

//#include "driver.h"
#include "SDL.h"
#include <time.h>
#include "pd4990a.h"
#include "state.h"


/* Set the data in the chip to Monday 09/09/73 00:00:00     */
/* If you ever read this Leejanne, you know what I mean :-) */
static int seconds = 0x00;		/* BCD */
static int minutes = 0x00;		/* BCD */
static int hours = 0x00;		/* BCD */
static int days = 0x09;		/* BCD */
static int month = 9;			/* Hexadecimal form */
static int year = 0x73;		/* BCD */
static int weekday = 1;		/* BCD */

static int retraces = 0;		/* Assumes 60 retraces a second */
static int coinflip = 0;		/* Pulses a bit in order to simulate */
					/* test output */
static int outputbit = 0;
static int bitno = 0;


void pd4990a_init_save_state(void) {
    create_state_register(ST_PD4990A,"seconds",1,&seconds,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"minutes",1,&minutes,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"hours",1,&hours,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"days",1,&days,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"month",1,&month,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"year",1,&year,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"weekday",1,&weekday,sizeof(Sint32),REG_INT32);

    create_state_register(ST_PD4990A,"retraces",1,&retraces,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"coinflip",1,&coinflip,sizeof(Sint32),REG_INT32);

    create_state_register(ST_PD4990A,"outputbit",1,&outputbit,sizeof(Sint32),REG_INT32);
    create_state_register(ST_PD4990A,"bitno",1,&bitno,sizeof(Sint32),REG_INT32);

}

void pd4990a_init(void) {
    time_t ltime;
    struct tm *today;

//    printf("pd4990a_init\n");

    seconds = 0x00;		/* BCD */
    minutes = 0x00;		/* BCD */
    hours = 0x00;		/* BCD */
    days = 0x09;		/* BCD */
    month = 9;			/* Hexadecimal form */
    year = 0x73;		/* BCD */
    weekday = 1;		/* BCD */

    retraces = 0;		/* Assumes 60 retraces a second */
    coinflip = 0;		/* Pulses a bit in order to simulate */
					/* test output */
    outputbit = 0;
    bitno = 0;

    time(&ltime);
    today = localtime(&ltime);

    seconds = ((today->tm_sec / 10) << 4) + (today->tm_sec % 10);
    minutes = ((today->tm_min / 10) << 4) + (today->tm_min % 10);
    hours = ((today->tm_hour / 10) << 4) + (today->tm_hour % 10);
    days = ((today->tm_mday / 10) << 4) + (today->tm_mday % 10);
    month = (today->tm_mon + 1);
    year = ((today->tm_year / 10) << 4) + (today->tm_year % 10);
    weekday = today->tm_wday;
    //printf("%d %d %d %d %d %d %d\n",seconds,minutes,hours,days,month,year,weekday);
    pd4990a_init_save_state();
}


void addretrace(void)
{
    coinflip ^= 1;
    retraces++;
    if (retraces == 60) {
	retraces = 0;
	seconds++;
	if ((seconds & 0x0f) == 10) {
	    seconds &= 0xf0;
	    seconds += 0x10;
	    if (seconds == 0x60) {
		seconds = 0;
		minutes++;
		if ((minutes & 0x0f) == 10) {
		    minutes &= 0xf0;
		    minutes += 0x10;
		    if (minutes == 0x60) {
			minutes = 0;
			hours++;
			if ((hours & 0x0f) == 10) {
			    hours &= 0xf0;
			    hours += 0x10;
			}
			if (hours == 0x24) {
			    hours = 0;
			    increment_day();
			}
		    }
		}
	    }
	}
    }
}

void increment_day(void)
{
    int real_year;

    days++;
    if ((days & 0x0f) == 10) {
	days &= 0xf0;
	days += 0x10;
    }

    weekday++;
    if (weekday == 7)
	weekday = 0;

    switch (month) {
    case 1:
    case 3:
    case 5:
    case 7:
    case 8:
    case 10:
    case 12:
	if (days == 0x32) {
	    days = 1;
	    increment_month();
	}
	break;
    case 2:
	real_year = (year >> 4) * 10 + (year & 0xf);
	if (real_year % 4) {	/* There are some rare exceptions, but I don't care ... */
	    if (days == 0x29) {
		days = 1;
		increment_month();
	    }
	} else {
	    if (days == 0x30) {
		days = 1;
		increment_month();
	    }
	}
	break;
    case 4:
    case 6:
    case 9:
    case 11:
	if (days == 0x31) {
	    days = 1;
	    increment_month();
	}
	break;
    }
}

void increment_month(void)
{
    month++;
    if (month == 13) {
	month = 1;
	year++;
	if ((year & 0x0f) == 10) {
	    year &= 0xf0;
	    year += 0x10;
	}
	if (year == 0xA0)	/* Happy new year 2000 !!! */
	    year = 0;
    }
}

int read_4990_testbit(void)
{
    return (coinflip);
}

int read_4990_databit(void)
{
    return (outputbit);
}

void write_4990_control_w(unsigned address, unsigned data)
{

    data &= 0xff;

    switch (data) {
    case 0x00:			/* Load Register */
	switch (bitno) {
	case 0x00:
	case 0x01:
	case 0x02:
	case 0x03:
	case 0x04:
	case 0x05:
	case 0x06:
	case 0x07:
	    outputbit = (seconds >> bitno) & 0x01;
	    break;
	case 0x08:
	case 0x09:
	case 0x0a:
	case 0x0b:
	case 0x0c:
	case 0x0d:
	case 0x0e:
	case 0x0f:
	    outputbit = (minutes >> (bitno - 8)) & 0x01;
	    break;
	case 0x10:
	case 0x11:
	case 0x12:
	case 0x13:
	case 0x14:
	case 0x15:
	case 0x16:
	case 0x17:
	    outputbit = (hours >> (bitno - 16)) & 0x01;
	    break;
	case 0x18:
	case 0x19:
	case 0x1a:
	case 0x1b:
	case 0x1c:
	case 0x1d:
	case 0x1e:
	case 0x1f:
	    outputbit = (days >> (bitno - 24)) & 0x01;
	    break;
	case 0x20:
	case 0x21:
	case 0x22:
	case 0x23:
	    outputbit = (weekday >> (bitno - 32)) & 0x01;
	    break;
	case 0x24:
	case 0x25:
	case 0x26:
	case 0x27:
	    outputbit = (month >> (bitno - 36)) & 0x01;
	    break;
	case 0x28:
	case 0x29:
	case 0x2a:
	case 0x2b:
	case 0x2c:
	case 0x2d:
	case 0x2e:
	case 0x2f:
	    outputbit = (year >> (bitno - 40)) & 0x01;
	    break;

	}
	break;

    case 0x04:			/* Start afresh with shifting */
	bitno = 0;
	break;

    case 0x02:			/* shift one position */
	bitno++;

    default:			/* Unhandled value */
	break;
    }
}
