/*  gngeo a neogeo emulator
 *  Copyright (C) 2001 Peponas Mathieu
 * 
 *  This program is free software; you can redistribute it and/or modify  
 *  it under the terms of the GNU General Public License as published by   
 *  the Free Software Foundation; either version 2 of the License, or    
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#ifndef _EMU_H_
#define _EMU_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include "SDL.h"

#ifndef UINT8
#define UINT8     unsigned char
#endif
#ifndef UINT16
#define UINT16    unsigned short
#endif
#ifndef UINT32
#define UINT32    unsigned long
#endif
#ifndef INT8
#define INT8      signed char
#endif
#ifndef INT16
#define INT16     signed short
#endif
#ifndef INT32
#define INT32     signed long
#endif

#ifndef uint8
#define uint8     UINT8
#endif
#ifndef uint16
#define uint16    UINT16
#endif
#ifndef uint32
#define uint32    UINT32
#endif
#ifndef sint8
#define sint8     INT8
#endif
#ifndef sint16
#define sint16    INT16
#endif
#ifndef sint32
#define sint32    INT32
#endif

struct {
    char *game;
    
    UINT16 x_start;
    UINT16 y_start;
    UINT16 res_x;
    UINT16 res_y;
    UINT16 sample_rate;
    UINT16 test_switch;

    UINT8 sound;
    UINT8 snd_st_reg_create;
    UINT8 do_message;
    UINT8 nb_joy;
    UINT8 raster;
    UINT8 debug;
    UINT8 rom_type;
    UINT8 extra_xor;
    Uint8 pal;

    char message[128];
    char fps[4];

    int *p1_key;
    int *p2_key;

    SDL_Joystick *joy[2];
    int *p1_joy;
    int *p2_joy;

    int *p1_hotkey0, *p1_hotkey1, *p1_hotkey2, *p1_hotkey3;
    int *p2_hotkey0, *p2_hotkey1, *p2_hotkey2, *p2_hotkey3;

    int p1_hotkey[4];
    int p2_hotkey[4];
} conf;

enum {
    HOTKEY_MASK_A = 0x1,
    HOTKEY_MASK_B = 0x2,
    HOTKEY_MASK_C = 0x4,
    HOTKEY_MASK_D = 0x8,
};

enum {
    BUT_A = 0,
    BUT_B,
    BUT_C,
    BUT_D,
    BUT_START,
    BUT_COIN,
    KB_UP,
    KB_DOWN,
    KB_LEFT,
    KB_RIGHT,
    BUT_HOTKEY0,
    BUT_HOTKEY1,
    BUT_HOTKEY2,
    BUT_HOTKEY3
};
enum {
    AXE_X = 6,
    AXE_Y,
    AXE_X_DIR,
    AXE_Y_DIR
};

//config conf;

UINT8 key[SDLK_LAST];
UINT8 *joy_button[2];
INT32 *joy_axe[2];

void debug_loop(void);
void main_loop(void);
void init_neo(char *rom_name);
void cpu_68k_dpg_step(void);

#ifdef ENABLE_PROFILER
#define PROFILER_START profiler_start
#define PROFILER_STOP profiler_stop

#else
#define PROFILER_START(a)
#define PROFILER_STOP(a)
#endif

/* LOG generation */
#define GNGEO_LOG(...)
//#define GNGEO_LOG printf

#endif
