/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */


package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.persistence.AVKPersistenceUnitInfoImpl;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;

import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;

import com.sun.enterprise.loader.InstrumentableClassLoader;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import java.util.logging.Level;
import java.util.Properties;

import oracle.toplink.essentials.exceptions.IntegrityException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;
import oracle.toplink.essentials.config.TopLinkProperties;

/**
 * This test uses TopLink Essential to do the validation.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class DefaultProviderVerification extends VerifierTest
        implements VerifierCheck {
    public Result check(Descriptor descriptor) {
        PersistenceUnitDescriptor pu =
                PersistenceUnitDescriptor.class.cast(descriptor);
        Result result = getInitializedResult();
        result.setStatus(Result.PASSED);
        PersistenceProvider provider;
        final String appLocation =
                getVerifierContext().getAbstractArchive().getArchiveUri();
        final InstrumentableClassLoader cl =
                InstrumentableClassLoader.class.cast(pu.getClassLoader());
        PersistenceUnitInfo pi = new AVKPersistenceUnitInfoImpl(pu, appLocation, cl);
        logger.fine("PersistenceInfo for PU is :\n" + pi);
        Properties props = new Properties();
        // This property is set to indicate that TopLink should only
        // validate the descriptors etc. and not try to login to database.
        props.put(EntityManagerFactoryProvider.TOPLINK_VALIDATION_ONLY_PROPERTY, 
                "TRUE"); // NOI18N
        // This property is used so that TopLink throws validation exceptions
        // as opposed to printing CONFIG level messages to console.
        // e.g. if mapping file does not exist, we will get an exception.
        props.put(EntityManagerFactoryProvider.TOPLINK_ORM_THROW_EXCEPTIONS, 
                "TRUE"); // NOI18N

        // the following property is needed as it initializes the logger in TL
        props.put(TopLinkProperties.TARGET_SERVER,
                      "oracle.toplink.essentials.platform.server.sunas.SunAS9ServerPlatform"); // NOI18N

        // Turn off enhancement during verification. For details,
        // refer to http://glassfish.dev.java.net/issues/show_bug.cgi?id=3295
        props.put(TopLinkProperties.WEAVING, "FALSE");

        provider = new EntityManagerFactoryProvider();
        EntityManagerFactory emf = null;
        try {
            emf = provider.createContainerEntityManagerFactory(pi, props);
            logger.logp(Level.FINE, "DefaultProviderVerification", "check",
                    "emf = {0}", emf);
        } catch(IntegrityException ie){
            result.setStatus(Result.FAILED);
            addErrorDetails(result, getVerifierContext().getComponentNameConstructor());
            for(Object o: ie.getIntegrityChecker().getCaughtExceptions()){
                Exception e = Exception.class.cast(o);
                result.addErrorDetails(e.getMessage());
            }
        } catch (ValidationException ve) {
            addErrorDetails(result, getVerifierContext().getComponentNameConstructor());
            result.failed(ve.getMessage());
        } catch(DatabaseException de) {
            addErrorDetails(result, getVerifierContext().getComponentNameConstructor());
            result.failed(de.getMessage());
        } catch(PersistenceException pe) {
            addErrorDetails(result, getVerifierContext().getComponentNameConstructor());
            result.failed(pe.getMessage());
        } finally {
            if(emf != null) {
                emf.close();
            }
        }
        return result;
    }

}
