/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PEV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgPushEnvVar(struct Cfg_Getopt *optstru)

 *	Push the ontents of an environemnt variable, if it exists

ob(ject): cfgPushEnvVar
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Push the value of an environment variable
he(ader files): 
lo(ng description): Push the value of an anvironment variable onto
	the input stack. The value is duplicated into the heap.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pev.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "environ.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PEV.C 1.4 1999/12/13 02:22:02 ska Exp ska $";
#endif

void cfgPushEnvVar(struct Cfg_Getopt * const optstru, const char * const var)
{	DBG_ENTER("cfgPushEnvVar", Suppl_cmdline)
	cfgPushDynString(optstru, dupvar(var));
	DBG_EXIT
}
