/*
    LIB - a librarian for compatible OBJ/LIB files
    Copyright (C) 1995,1996  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: MKTMP.C $
   $Locker: ska $	$Name: v3_2 $	$State: Rel $

	char *mktmp(char *ext);

	Create a file with extension in a temporary directory.
	The file is created with no special attribute & opened in
	compatibly mode.

	Bug:
		The function uses a DOS-API function. That function does not
		allow an user-defined extension. Therefore the returned file
		name is renamed to have the specified extension. If the renaming
		fails, the returned file name cannot be deleted, because this
		could cause that the same name is returned again and, thus, the
		loop would hang, not forever, but at least a recognizeble amount
		of time.
		As a result some files with zero length can remain in the
		temporary directory.

	Return:	NULL: if the temp file couldn't be created, e.g. problems
				with the file system.
			otherwise: the malloc()'ed file name (fully-qualified)

*/

#ifndef _MICROC_
#include <io.h>
#include <string.h>
#include <dos.h>
#endif
#include <portable.h>
#include <fmemory.h>
#include <environ.h>
#include "types.h"
#include "yerror.h"

char *mktmp(char *ext)
{	char fnam[256], *p, *q, *pp;
	int e;
#ifndef _MICROC_
#ifndef __TURBOC__
#ifdef DSequalSS
	union REGS regs;
#else
	struct REGPACK regs;
#endif
#endif
#endif

	if((cpyenv("TEMP", fnam, sizeof(fnam)) != 0
	 && cpyenv("TMP", fnam, sizeof(fnam)) != 0)
	 || *fnam == '\0')
	 	*fnam = '.', p = fnam + 1;
	else p = strchr(fnam, '\0');

	if((e = p[-1]) != '\\' && e != '/')
		*p = '\\', *++p = '\0';

retry:
#ifdef _MICROC_
	fnam;		/* lea ax, fnam */
	asm {
		mov dx, ax
		mov ah, 5ah		; /* DOS API create temporary file */
		mov cx, 0		; /* no special attributes */
		int 21h
		jnc opened
		sbb ax, ax
opened:
	}
	if((e = nargs()) < 0)
#else
#ifdef __TURBOC__
#ifndef DSequalSS
	asm {
		push ds
		mov ax, ss		; /* assume DS != SS */
		mov ds, ax
	}
#endif
	asm {
		lea dx, ss:fnam
		mov ah, 5ah		; /* DOS API create temporary file */
		mov cx, 0		; /* no special attributes */
		int 21h
		jnc opened
		sbb ax, ax
	}
opened:
#ifndef DSequalSS
	asm pop ds ;
#endif
	if((e = _AX) < 0)
#else
#ifdef DSequalSS
	regs.h.ah = 0x5a;	/* DOS API "Create Temporary File" */
	regs.x.cx = 0;		/* no special attributes */
	regs.x.dx = &fnam;	/* file name template */
	e = intdos(&regs, &regs);
	if(regs.x.cflag)
#else
	regs.r_ax = 0x5a00;
	regs.r_cx = 0;
	regs.r_dx = FP_OFF(&fnam);
	regs.r_ds = FP_SEG(&fnam);
	intr(&regs);
	e = regs.r_ax;
	if(regs.r_flags & 1)
#endif
#endif
#endif
		return NULL;			/* open failed */
	close(e);
	if(ext && *ext) {
		q = dupstr(fnam);
		if((pp = strchr(p, '.')) == NULL)	/* The API function is allowed to append */
			pp = strchr(p, NUL);	/* an extension, even it doesn't do it */
		if(*ext != '.') *pp++ = '.';
		strcpy(pp, ext);
		if(rename(q, fnam)) {	/* rename failed, try another name */
			U_free(q);			/* well, the bug: the name without extension */
			*p = '\0';			/* is not unlinked. Otherwise the loop may */
			goto retry;			/* might hang. */
		}
		U_free(q);
	}

	return dupstr(fnam);
}
