/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.util.ConnectionDialog;

public class Transfer
extends Applet
implements WindowListener,
ActionListener,
ItemListener {
    Connection cSource;
    Connection cTarget;
    DatabaseMetaData dSourceMeta;
    DatabaseMetaData dTargetMeta;
    Statement sSourceStatement;
    Statement sTargetStatement;
    Frame fMain;
    Image imgEmpty;
    Table tCurrent;
    int iMaxRows;
    Vector tTable;
    List lTable;
    TextField tSourceTable;
    TextField tDestTable;
    TextField tDestDrop;
    TextField tDestCreate;
    TextField tDestDelete;
    TextField tSourceSelect;
    TextField tDestInsert;
    Checkbox cTransfer;
    Checkbox cDrop;
    Checkbox cCreate;
    Checkbox cDelete;
    Checkbox cInsert;
    Button bStart;
    Hashtable hTypes;
    TextField tMessage;
    static boolean bMustExit;
    String sLast;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof MenuItem) {
            string = ((MenuItem)actionEvent.getSource()).getLabel();
        }
        if (string.equals("Start Transfer")) {
            this.transfer();
        } else if (string.equals("Insert 10 rows only")) {
            this.iMaxRows = 10;
        } else if (string.equals("Insert 1000 rows only")) {
            this.iMaxRows = 1000;
        } else if (string.equals("Insert all rows")) {
            this.iMaxRows = 0;
        }
    }

    void addMenuItems(Menu menu, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            MenuItem menuItem = new MenuItem(stringArray[n]);
            menuItem.addActionListener(this);
            menu.add(menuItem);
            ++n;
        }
    }

    Panel createBorderPanel(Component component) {
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new BorderLayout());
        panel.add("Center", component);
        panel.add("South", this.createLabel(""));
        panel.add("East", this.createLabel(""));
        panel.add("West", this.createLabel(""));
        panel.setBackground(SystemColor.control);
        return panel;
    }

    Label createLabel(String string) {
        Label label = new Label(string);
        label.setBackground(SystemColor.control);
        return label;
    }

    void displayTable(Table table) {
        this.tCurrent = table;
        if (table == null) {
            return;
        }
        this.tSourceTable.setText(table.sSourceTable);
        this.tDestTable.setText(table.sDestTable);
        this.tDestDrop.setText(table.sDestDrop);
        this.tDestCreate.setText(table.sDestCreate);
        this.tDestDelete.setText(table.sDestDelete);
        this.tSourceSelect.setText(table.sSourceSelect);
        this.tDestInsert.setText(table.sDestInsert);
        this.cTransfer.setState(table.bTransfer);
        this.cDrop.setState(table.bDrop);
        this.cCreate.setState(table.bCreate);
        this.cDelete.setState(table.bDelete);
        this.cInsert.setState(table.bInsert);
    }

    public void init() {
        Transfer transfer = new Transfer();
        transfer.main();
    }

    void initGUI() {
        Font font = new Font("Dialog", 0, 12);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setBackground(SystemColor.control);
        panel.setLayout(new GridLayout(16, 1));
        this.tSourceTable = new TextField();
        this.tSourceTable.setEnabled(false);
        this.tDestTable = new TextField();
        this.tDestDrop = new TextField();
        this.tDestCreate = new TextField();
        this.tDestDelete = new TextField();
        this.tSourceSelect = new TextField();
        this.tDestInsert = new TextField();
        this.cTransfer = new Checkbox("Transfer to destination table", true);
        this.cTransfer.addItemListener(this);
        this.cDrop = new Checkbox("Drop destination table (ignore error)", true);
        this.cDrop.addItemListener(this);
        this.cCreate = new Checkbox("Create destination table", true);
        this.cCreate.addItemListener(this);
        this.cDelete = new Checkbox("Delete rows in destination table", true);
        this.cDelete.addItemListener(this);
        this.cInsert = new Checkbox("Insert into destination", true);
        this.cInsert.addItemListener(this);
        panel.add(this.createLabel("Source table"));
        panel.add(this.tSourceTable);
        panel.add(this.cTransfer);
        panel.add(this.tDestTable);
        panel.add(this.cDrop);
        panel.add(this.tDestDrop);
        panel.add(this.cCreate);
        panel.add(this.tDestCreate);
        panel.add(this.cDelete);
        panel.add(this.tDestDelete);
        panel.add(this.createLabel("Select source records"));
        panel.add(this.tSourceSelect);
        panel.add(this.cInsert);
        panel.add(this.tDestInsert);
        panel.add(this.createLabel(""));
        this.bStart = new Button("Start Transfer");
        this.bStart.addActionListener(this);
        panel.add(this.bStart);
        this.fMain.add("Center", this.createBorderPanel(panel));
        this.lTable = new List(10);
        this.lTable.addItemListener(this);
        this.fMain.add("West", this.createBorderPanel(this.lTable));
        this.tMessage = new TextField();
        Panel panel2 = this.createBorderPanel(this.tMessage);
        this.fMain.add("South", panel2);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.lTable) {
            String string = this.lTable.getSelectedItem();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table = (Table)this.tTable.elementAt(n);
                if (table != null && table.sSourceTable.equals(string)) {
                    this.saveTable();
                    this.displayTable(table);
                    this.updateEnabled(true);
                }
                ++n;
            }
        } else {
            this.updateEnabled(true);
        }
    }

    void main() {
        this.fMain = new Frame("Hypersonic Transfer Tool");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        ((Component)this.fMain).setSize(640, 480);
        this.fMain.add("Center", this);
        MenuBar menuBar = new MenuBar();
        String[] stringArray = new String[]{"Insert 10 rows only", "Insert 1000 rows only", "Insert all rows"};
        Menu menu = new Menu("Options");
        this.addMenuItems(menu, stringArray);
        menuBar.add(menu);
        this.fMain.setMenuBar(menuBar);
        this.initGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        ((Component)this.fMain).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)this.fMain).setVisible(true);
        this.cSource = ConnectionDialog.createConnection(this.fMain, "Source Database");
        if (this.cSource == null) {
            return;
        }
        try {
            this.dSourceMeta = this.cSource.getMetaData();
            this.sSourceStatement = this.cSource.createStatement();
        }
        catch (Exception exception) {
            this.trace(exception.toString());
            exception.printStackTrace();
        }
        this.cTarget = ConnectionDialog.createConnection(this.fMain, "Target Database");
        if (this.cTarget == null) {
            return;
        }
        try {
            this.dTargetMeta = this.cTarget.getMetaData();
            this.sTargetStatement = this.cTarget.createStatement();
        }
        catch (Exception exception) {
            this.trace(exception.toString());
            exception.printStackTrace();
        }
        String[] stringArray2 = new String[]{"TABLE"};
        this.lTable.removeAll();
        this.tTable = new Vector();
        try {
            Object object;
            this.hTypes = new Hashtable();
            this.trace("Building target type info");
            ResultSet resultSet = this.dTargetMeta.getTypeInfo();
            while (resultSet.next()) {
                this.hTypes.put(new Integer(resultSet.getShort(2)), resultSet.getString(1));
            }
            resultSet.close();
            this.trace("Reading source tables");
            resultSet = this.dSourceMeta.getTables(null, null, null, stringArray2);
            int n = 0;
            while (resultSet.next()) {
                Table table = new Table();
                table.iTableIndex = n++;
                object = resultSet.getString(3);
                table.bTransfer = true;
                table.sSourceTable = object;
                table.sDestTable = object;
                table.sDestDrop = "DROP TABLE " + (String)object;
                table.sSourceSelect = "SELECT * FROM " + (String)object;
                table.sDestDelete = "DELETE FROM " + (String)object;
                table.bCreate = true;
                table.bDelete = true;
                table.bDrop = true;
                table.bInsert = true;
                this.tTable.addElement(table);
                this.lTable.add((String)object);
            }
            resultSet.close();
            int n2 = 0;
            while (n2 < this.tTable.size()) {
                object = (Table)this.tTable.elementAt(n2);
                this.trace("Reading source columns for table " + ((Table)object).sSourceTable);
                ResultSet resultSet2 = this.dSourceMeta.getColumns(null, null, ((Table)object).sSourceTable, null);
                String string = "CREATE TABLE " + ((Table)object).sSourceTable + "(";
                String string2 = "INSERT INTO " + ((Table)object).sSourceTable + " VALUES(";
                Vector<Integer> vector = new Vector<Integer>();
                while (resultSet2.next()) {
                    String string3 = resultSet2.getString(4);
                    int n3 = resultSet2.getShort(5);
                    String string4 = resultSet2.getString(6);
                    if (n3 == 11 && string4.toUpperCase().equals("DATETIME")) {
                        this.trace("Converted DATETIME (type 11) to TIMESTAMP");
                        n3 = 93;
                    } else if (n3 == -9 && string4.toUpperCase().equals("NVARCHAR")) {
                        this.trace("Converted NVARCHAR (type -9) to VARCHAR");
                        n3 = 12;
                    } else if (n3 == -8 && string4.toUpperCase().equals("NCHAR")) {
                        this.trace("Converted NCHAR (type -8) to VARCHAR");
                        n3 = 12;
                    } else if (n3 == -10 && string4.toUpperCase().equals("NTEXT")) {
                        this.trace("Converted NTEXT (type -10) to VARCHAR");
                        n3 = 12;
                    } else if (n3 == -1 && string4.toUpperCase().equals("LONGTEXT")) {
                        this.trace("Converted LONGTEXT (type -1) to LONGVARCHAR");
                        n3 = -1;
                    }
                    Integer n4 = new Integer(n3);
                    String string5 = (String)this.hTypes.get(n4);
                    if (string5 == null) {
                        string5 = string4;
                        this.trace("No mapping for type: " + n4 + " source type is " + string5);
                    }
                    vector.addElement(n4);
                    string = String.valueOf(string) + string3 + " " + string5 + ",";
                    string2 = String.valueOf(string2) + "?,";
                }
                resultSet2.close();
                string = String.valueOf(string.substring(0, string.length() - 1)) + ")";
                string2 = String.valueOf(string2.substring(0, string2.length() - 1)) + ")";
                ((Table)object).sDestCreate = string;
                ((Table)object).sDestInsert = string2;
                ((Table)object).iColumnType = new int[vector.size()];
                int n5 = 0;
                while (n5 < vector.size()) {
                    ((Table)object).iColumnType[n5] = (Integer)vector.elementAt(n5);
                    ++n5;
                }
                ++n2;
            }
            this.trace("Edit definitions and press [Start Transfer]");
        }
        catch (SQLException sQLException) {
            this.trace("SQL Exception reading Metadata: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        this.fMain.show();
    }

    public static void main(String[] stringArray) {
        bMustExit = true;
        Transfer.work();
    }

    void saveTable() {
        if (this.tCurrent == null) {
            return;
        }
        Table table = this.tCurrent;
        table.sSourceTable = this.tSourceTable.getText();
        table.sDestTable = this.tDestTable.getText();
        table.sDestDrop = this.tDestDrop.getText();
        table.sDestCreate = this.tDestCreate.getText();
        table.sDestDelete = this.tDestDelete.getText();
        table.sSourceSelect = this.tSourceSelect.getText();
        table.sDestInsert = this.tDestInsert.getText();
        table.bTransfer = this.cTransfer.getState();
        table.bDrop = this.cDrop.getState();
        table.bCreate = this.cCreate.getState();
        table.bDelete = this.cDelete.getState();
        table.bInsert = this.cInsert.getState();
    }

    void trace(String string) {
        this.tMessage.setText(string);
        System.out.println(string);
    }

    void transfer() {
        this.saveTable();
        this.updateEnabled(false);
        this.trace("Start Transfer");
        try {
            int n = 0;
            while (n < this.tTable.size()) {
                this.transfer((Table)this.tTable.elementAt(n));
                ++n;
            }
            this.trace("Transfer finished successfully");
        }
        catch (SQLException sQLException) {
            String string = this.tMessage.getText();
            this.trace("Transfer stopped - " + string + " / " + this.sLast + " / Error: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            String string = this.tMessage.getText();
            this.trace("Transfer stopped - " + string + " / " + this.sLast + " / Error: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.updateEnabled(true);
    }

    void transfer(Table table) throws SQLException {
        this.lTable.select(table.iTableIndex);
        this.displayTable(table);
        if (!table.bTransfer) {
            this.trace("Table " + table.sSourceSelect + " not transfered");
            return;
        }
        this.trace("Table " + table.sSourceSelect + ": start transfer");
        if (table.bDelete) {
            try {
                this.trace("Executing " + table.sDestDrop);
                this.sTargetStatement.execute(table.sDestDrop);
            }
            catch (SQLException sQLException) {
                this.trace("Ignoring error " + sQLException.getMessage());
            }
        }
        if (table.bCreate) {
            this.trace("Executing " + table.sDestCreate);
            this.sTargetStatement.execute(table.sDestCreate);
        }
        if (table.bDelete) {
            this.trace("Executing " + table.sDestDelete);
            this.sTargetStatement.execute(table.sDestDelete);
        }
        if (table.bInsert) {
            this.trace("Executing " + table.sDestInsert);
            PreparedStatement preparedStatement = this.cTarget.prepareStatement(table.sDestInsert);
            this.trace("Executing " + table.sSourceSelect);
            ResultSet resultSet = this.sSourceStatement.executeQuery(table.sSourceSelect);
            int n = 0;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int[] nArray = new int[resultSetMetaData.getColumnCount()];
            int n2 = 0;
            while (n2 < resultSetMetaData.getColumnCount()) {
                nArray[n2] = resultSetMetaData.getColumnType(n2 + 1);
                ++n2;
            }
            this.trace("Start transfering data...");
            while (resultSet.next()) {
                this.transferRow(nArray, resultSet, preparedStatement);
                if (this.iMaxRows != 0 && n == this.iMaxRows) break;
                if (this.iMaxRows == 0 && ++n % 100 != 0) continue;
                this.trace("Transfered " + n + " rows");
            }
            this.trace("Finished");
        }
    }

    void transferRow(int[] nArray, ResultSet resultSet, PreparedStatement preparedStatement) throws SQLException {
        this.sLast = null;
        preparedStatement.clearParameters();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.sLast = "column=" + (n2 + 1) + " datatype=" + n3;
            Object object = resultSet.getObject(n2 + 1);
            if (object == null) {
                this.sLast = String.valueOf(this.sLast) + " value=" + object;
                preparedStatement.setNull(n2 + 1, nArray[n2]);
            } else {
                if (n3 == 5 && object instanceof Integer) {
                    this.sLast = String.valueOf(this.sLast) + " SMALLINT: Converted Integer to Short";
                    object = new Short((short)((Integer)object).intValue());
                } else if (n3 == -6 && object instanceof Integer) {
                    this.sLast = String.valueOf(this.sLast) + " TINYINT: Converted Integer to Byte";
                    object = new Byte((byte)((Integer)object).intValue());
                }
                this.sLast = String.valueOf(this.sLast) + " value=" + object;
                preparedStatement.setObject(n2 + 1, object, nArray[n2]);
            }
            ++n2;
        }
        preparedStatement.execute();
        this.sLast = null;
    }

    void updateEnabled(boolean bl) {
        boolean bl2 = this.cTransfer.getState();
        this.tDestTable.setEnabled(bl && bl2);
        this.tDestDrop.setEnabled(bl && bl2 && this.cDrop.getState());
        this.tDestCreate.setEnabled(bl && bl2 && this.cCreate.getState());
        this.tDestDelete.setEnabled(bl && bl2 && this.cDelete.getState());
        this.tSourceSelect.setEnabled(bl && bl2);
        this.tDestInsert.setEnabled(bl && bl2 && this.cInsert.getState());
        this.cDrop.setEnabled(bl && bl2);
        this.cCreate.setEnabled(bl && bl2);
        this.cDelete.setEnabled(bl && bl2);
        this.cInsert.setEnabled(bl && bl2);
        this.bStart.setEnabled(bl);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            if (this.cSource != null) {
                this.cSource.close();
            }
            if (this.cTarget != null) {
                this.cTarget.close();
            }
        }
        catch (Exception exception) {}
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public static void work() {
        Transfer transfer = new Transfer();
        transfer.main();
    }

    class Table {
        int iTableIndex;
        String sSourceTable;
        String sDestTable;
        String sDestDrop;
        String sDestCreate;
        String sDestDelete;
        String sSourceSelect;
        String sDestInsert;
        boolean bTransfer;
        boolean bDrop;
        boolean bCreate;
        boolean bDelete;
        boolean bInsert;
        int[] iColumnType;

        Table() {
        }
    }
}

