/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend.constantpool;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPoolEntry;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.FieldRefCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.InterfaceMethodRefCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.MethodRefCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.NameAndTypeCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.Utf8CPInfo;

public class ConstantPool {
    private Vector entries = new Vector();
    private Hashtable utf8Indexes;

    public ConstantPool() {
        this.entries.addElement(null);
        this.utf8Indexes = new Hashtable();
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = 1;
        while (n2 < n) {
            ConstantPoolEntry constantPoolEntry = ConstantPoolEntry.readEntry(dataInputStream);
            n2 += constantPoolEntry.getNumEntries();
            this.addEntry(constantPoolEntry);
        }
    }

    public int size() {
        return this.entries.size();
    }

    public int addEntry(ConstantPoolEntry constantPoolEntry) {
        int n = this.entries.size();
        this.entries.addElement(constantPoolEntry);
        int n2 = constantPoolEntry.getNumEntries();
        int n3 = 0;
        while (n3 < n2 - 1) {
            this.entries.addElement(null);
            ++n3;
        }
        if (constantPoolEntry instanceof Utf8CPInfo) {
            Utf8CPInfo utf8CPInfo = (Utf8CPInfo)constantPoolEntry;
            this.utf8Indexes.put(utf8CPInfo.getValue(), new Integer(n));
        }
        return n;
    }

    public void resolve() {
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)enumeration.nextElement();
            if (constantPoolEntry == null || constantPoolEntry.isResolved()) continue;
            constantPoolEntry.resolve(this);
        }
    }

    public ConstantPoolEntry getEntry(int n) {
        return (ConstantPoolEntry)this.entries.elementAt(n);
    }

    public int getUTF8Entry(String string) {
        int n = -1;
        Integer n2 = (Integer)this.utf8Indexes.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public int getClassEntry(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.entries.size() && n == -1) {
            ClassCPInfo classCPInfo;
            Object e = this.entries.elementAt(n2);
            if (e instanceof ClassCPInfo && (classCPInfo = (ClassCPInfo)e).getClassName().equals(string)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public int getConstantEntry(Object object) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.entries.size() && n == -1) {
            ConstantCPInfo constantCPInfo;
            Object e = this.entries.elementAt(n2);
            if (e instanceof ConstantCPInfo && (constantCPInfo = (ConstantCPInfo)e).getValue().equals(object)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public int getMethodRefEntry(String string, String string2, String string3) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.entries.size() && n == -1) {
            MethodRefCPInfo methodRefCPInfo;
            Object e = this.entries.elementAt(n2);
            if (e instanceof MethodRefCPInfo && (methodRefCPInfo = (MethodRefCPInfo)e).getMethodClassName().equals(string) && methodRefCPInfo.getMethodName().equals(string2) && methodRefCPInfo.getMethodType().equals(string3)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public int getInterfaceMethodRefEntry(String string, String string2, String string3) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.entries.size() && n == -1) {
            InterfaceMethodRefCPInfo interfaceMethodRefCPInfo;
            Object e = this.entries.elementAt(n2);
            if (e instanceof InterfaceMethodRefCPInfo && (interfaceMethodRefCPInfo = (InterfaceMethodRefCPInfo)e).getInterfaceMethodClassName().equals(string) && interfaceMethodRefCPInfo.getInterfaceMethodName().equals(string2) && interfaceMethodRefCPInfo.getInterfaceMethodType().equals(string3)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public int getFieldRefEntry(String string, String string2, String string3) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.entries.size() && n == -1) {
            FieldRefCPInfo fieldRefCPInfo;
            Object e = this.entries.elementAt(n2);
            if (e instanceof FieldRefCPInfo && (fieldRefCPInfo = (FieldRefCPInfo)e).getFieldClassName().equals(string) && fieldRefCPInfo.getFieldName().equals(string2) && fieldRefCPInfo.getFieldType().equals(string3)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public int getNameAndTypeEntry(String string, String string2) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.entries.size() && n == -1) {
            NameAndTypeCPInfo nameAndTypeCPInfo;
            Object e = this.entries.elementAt(n2);
            if (e instanceof NameAndTypeCPInfo && (nameAndTypeCPInfo = (NameAndTypeCPInfo)e).getName().equals(string) && nameAndTypeCPInfo.getType().equals(string2)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        int n = this.entries.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[" + n2 + "] = " + this.getEntry(n2) + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

