/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;

public class JPEGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_QUALITY = new QualityKey(0);

    public JPEGTranscoder() {
        this.hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, Color.white);
    }

    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 1);
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        float f;
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if (outputStream == null) {
            throw new TranscoderException(Messages.formatMessage("jpeg.badoutput", null));
        }
        if (this.hints.containsKey(KEY_QUALITY)) {
            f = ((Float)this.hints.get(KEY_QUALITY)).floatValue();
        } else {
            this.handler.error(new TranscoderException(Messages.formatMessage("jpeg.unspecifiedQuality", null)));
            f = 1.0f;
        }
        try {
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }

    private static class QualityKey
    extends TranscodingHints.Key {
        public QualityKey(int n) {
            super(n);
        }

        public boolean isCompatibleValue(Object object) {
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                return f > 0.0f && f <= 1.0f;
            }
            return false;
        }
    }
}

