/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.AffineTransform;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGTransformDescriptor;
import org.apache.batik.svggen.TransformStackElement;

public class SVGTransform
extends AbstractSVGConverter {
    private static double radiansToDegrees = 57.29577951308232;

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return new SVGTransformDescriptor(SVGTransform.toSVGTransform(graphicContext));
    }

    public static String toSVGTransform(GraphicContext graphicContext) {
        return SVGTransform.toSVGTransform(graphicContext.getTransformStack());
    }

    public static String toSVGTransform(TransformStackElement[] transformStackElementArray) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        int n = transformStackElementArray.length;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            object = (TransformStackElement)transformStackElementArray[n2].clone();
            bl = true;
            n3 = n2 + 1;
            while (n3 < n) {
                bl = ((TransformStackElement)object).concatenate(transformStackElementArray[n3]);
                if (!bl) break;
                ++n3;
            }
            n2 = n3;
            stringBuffer.append(SVGTransform.convertTransform((TransformStackElement)object));
            stringBuffer.append(" ");
        }
        object = stringBuffer.toString().trim();
        return object;
    }

    static String convertTransform(TransformStackElement transformStackElement) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = transformStackElement.getTransformParameters();
        switch (transformStackElement.getType().toInt()) {
            case 0: {
                if (dArray[0] == 0.0 && dArray[1] == 0.0) break;
                stringBuffer.append("translate");
                stringBuffer.append("(");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[1]));
                stringBuffer.append(")");
                break;
            }
            case 1: {
                if (dArray[0] == 0.0) break;
                stringBuffer.append("rotate");
                stringBuffer.append("(");
                stringBuffer.append(AbstractSVGConverter.doubleString(radiansToDegrees * dArray[0]));
                stringBuffer.append(")");
                break;
            }
            case 2: {
                if (dArray[0] == 1.0 && dArray[1] == 1.0) break;
                stringBuffer.append("scale");
                stringBuffer.append("(");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[1]));
                stringBuffer.append(")");
                break;
            }
            case 3: {
                stringBuffer.append("matrix");
                stringBuffer.append("(");
                stringBuffer.append(1);
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[1]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(1);
                stringBuffer.append(",");
                stringBuffer.append(0);
                stringBuffer.append(",");
                stringBuffer.append(0);
                stringBuffer.append(")");
                break;
            }
            case 4: {
                if (SVGTransform.isIdentity(dArray)) break;
                stringBuffer.append("matrix");
                stringBuffer.append("(");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[1]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[2]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[3]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[4]));
                stringBuffer.append(",");
                stringBuffer.append(AbstractSVGConverter.doubleString(dArray[5]));
                stringBuffer.append(")");
                break;
            }
            default: {
                throw new Error();
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isIdentity(double[] dArray) {
        if (dArray.length != 6) {
            throw new Error();
        }
        return dArray[0] == 1.0 && dArray[2] == 0.0 && dArray[4] == 0.0 && dArray[1] == 0.0 && dArray[3] == 1.0 && dArray[5] == 0.0;
    }

    public static void main(String[] stringArray) {
        GraphicContext graphicContext = new GraphicContext();
        graphicContext.translate(20, 20);
        graphicContext.rotate(0.7853981633974483);
        graphicContext.shear(0.5, 0.5);
        graphicContext.scale(20.0, 20.0);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(60.0, 60.0);
        graphicContext.transform(affineTransform);
        String string = SVGTransform.toSVGTransform(graphicContext);
        System.out.println("SVG Transform: " + string);
        graphicContext.setTransform(new AffineTransform());
        graphicContext.translate(45, 45);
        string = SVGTransform.toSVGTransform(graphicContext);
        System.out.println("SVG Transform: " + string);
        graphicContext.setTransform(new AffineTransform());
        graphicContext.translate(10, 10);
        graphicContext.translate(30, 30);
        graphicContext.scale(2.0, 3.0);
        graphicContext.scale(3.0, 2.0);
        graphicContext.rotate(1.5707963267948966);
        graphicContext.rotate(1.5707963267948966);
        graphicContext.translate(100, 100);
        graphicContext.translate(-100, -100);
        graphicContext.scale(2.0, 2.0);
        graphicContext.scale(0.5, 0.5);
        graphicContext.rotate(1.5707963267948966);
        graphicContext.rotate(-1.5707963267948966);
        string = SVGTransform.toSVGTransform(graphicContext);
        System.out.println("SVG Transform: " + string);
    }
}

