/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.svggen.SVGEllipse;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.SVGLine;
import org.apache.batik.svggen.SVGPath;
import org.apache.batik.svggen.SVGPolygon;
import org.apache.batik.svggen.SVGRectangle;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGShape
extends SVGGraphicObjectConverter {
    SVGPolygon svgPolygon;
    SVGRectangle svgRectangle;
    SVGEllipse svgEllipse;
    SVGLine svgLine;
    SVGPath svgPath;

    public SVGShape(Document document) {
        super(document);
        this.svgPolygon = new SVGPolygon(document);
        this.svgRectangle = new SVGRectangle(document);
        this.svgEllipse = new SVGEllipse(document);
        this.svgLine = new SVGLine(document);
        this.svgPath = new SVGPath(document);
    }

    public Element toSVG(Shape shape) {
        if (shape instanceof Polygon) {
            return this.svgPolygon.toSVG((Polygon)shape);
        }
        if (shape instanceof Rectangle2D) {
            return this.svgRectangle.toSVG((Rectangle2D)shape);
        }
        if (shape instanceof RoundRectangle2D) {
            return this.svgRectangle.toSVG((RoundRectangle2D)shape);
        }
        if (shape instanceof Ellipse2D) {
            return this.svgEllipse.toSVG((Ellipse2D)shape);
        }
        if (shape instanceof Line2D) {
            return this.svgLine.toSVG((Line2D)shape);
        }
        return this.svgPath.toSVG(shape);
    }

    public static void main(String[] stringArray) throws Exception {
        Polygon polygon = new Polygon();
        polygon.addPoint(1, 1);
        polygon.addPoint(2, 1);
        polygon.addPoint(3, 2);
        polygon.addPoint(3, 3);
        polygon.addPoint(2, 4);
        polygon.addPoint(1, 3);
        polygon.addPoint(1, 2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(1.0f, 0.0f);
        generalPath.lineTo(1.0f, 1.0f);
        generalPath.lineTo(0.0f, 1.0f);
        generalPath.closePath();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        Area area = new Area(generalPath);
        area.subtract(new Area(double_));
        Shape[] shapeArray = new Shape[]{polygon, new Rectangle(10, 20, 30, 40), new Rectangle2D.Double(100.0, 200.0, 300.0, 400.0), new Rectangle2D.Float(1000.0f, 2000.0f, 3000.0f, 4000.0f), new RoundRectangle2D.Double(15.0, 16.0, 17.0, 18.0, 30.0, 20.0), new RoundRectangle2D.Float(35.0f, 45.0f, 55.0f, 65.0f, 25.0f, 45.0f), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 100.0f), new Ellipse2D.Double(40.0, 40.0, 240.0, 240.0), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 200.0f), new Ellipse2D.Float(40.0f, 100.0f, 240.0f, 200.0f), new Line2D.Double(1.0, 2.0, 3.0, 4.0), new Line2D.Double(10.0, 20.0, 30.0, 40.0), new QuadCurve2D.Float(20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f), new CubicCurve2D.Float(15.0f, 25.0f, 35.0f, 45.0f, 55.0f, 65.0f, 75.0f, 85.0f), new Arc2D.Double(0.0, 0.0, 100.0, 100.0, 0.0, 90.0, 0), generalPath, area};
        Document document = TestUtil.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        SVGShape sVGShape = new SVGShape(document);
        int n = 0;
        while (n < shapeArray.length) {
            element.appendChild(sVGShape.toSVG(shapeArray[n]));
            ++n;
        }
        TestUtil.trace(element, System.out);
    }
}

