/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGCSSStyler;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGFontDescriptor;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGFont
extends AbstractSVGConverter {
    public static final float EXTRA_LIGHT = TextAttribute.WEIGHT_EXTRA_LIGHT.floatValue();
    public static final float LIGHT = TextAttribute.WEIGHT_LIGHT.floatValue();
    public static final float DEMILIGHT = TextAttribute.WEIGHT_DEMILIGHT.floatValue();
    public static final float REGULAR = TextAttribute.WEIGHT_REGULAR.floatValue();
    public static final float SEMIBOLD = TextAttribute.WEIGHT_SEMIBOLD.floatValue();
    public static final float MEDIUM = TextAttribute.WEIGHT_MEDIUM.floatValue();
    public static final float DEMIBOLD = TextAttribute.WEIGHT_DEMIBOLD.floatValue();
    public static final float BOLD = TextAttribute.WEIGHT_BOLD.floatValue();
    public static final float HEAVY = TextAttribute.WEIGHT_HEAVY.floatValue();
    public static final float EXTRABOLD = TextAttribute.WEIGHT_EXTRABOLD.floatValue();
    public static final float ULTRABOLD = TextAttribute.WEIGHT_ULTRABOLD.floatValue();
    public static final float POSTURE_REGULAR = TextAttribute.POSTURE_REGULAR.floatValue();
    public static final float POSTURE_OBLIQUE = TextAttribute.POSTURE_OBLIQUE.floatValue();
    static final float[] fontStyles = new float[]{POSTURE_REGULAR + (POSTURE_OBLIQUE - POSTURE_REGULAR) / 2.0f};
    static final String[] svgStyles = new String[]{"normal", "italic"};
    static final float[] fontWeights = new float[]{EXTRA_LIGHT + (LIGHT - EXTRA_LIGHT) / 2.0f, LIGHT + (DEMILIGHT - LIGHT) / 2.0f, DEMILIGHT + (REGULAR - DEMILIGHT) / 2.0f, REGULAR + (SEMIBOLD - REGULAR) / 2.0f, SEMIBOLD + (MEDIUM - SEMIBOLD) / 2.0f, MEDIUM + (DEMIBOLD - MEDIUM) / 2.0f, DEMIBOLD + (BOLD - DEMIBOLD) / 2.0f, BOLD + (HEAVY - BOLD) / 2.0f, HEAVY + (EXTRABOLD - HEAVY) / 2.0f, EXTRABOLD + (ULTRABOLD - EXTRABOLD)};
    static final String[] svgWeights = new String[]{"100", "200", "300", "normal", "500", "500", "600", "bold", "800", "800", "900"};
    static Hashtable logicalFontMap = new Hashtable();

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return SVGFont.toSVG(graphicContext.getFont());
    }

    public static SVGFontDescriptor toSVG(Font font) {
        String string = "" + font.getSize();
        String string2 = SVGFont.weightToSVG(font);
        String string3 = SVGFont.styleToSVG(font);
        String string4 = font.getFamily();
        StringBuffer stringBuffer = new StringBuffer("'");
        stringBuffer.append(string4);
        stringBuffer.append("'");
        string4 = stringBuffer.toString();
        String string5 = (String)logicalFontMap.get(font.getName().toLowerCase());
        if (string5 != null) {
            string4 = string5;
        }
        return new SVGFontDescriptor(string, string2, string3, string4);
    }

    private static String styleToSVG(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        Float f = (Float)map.get(TextAttribute.POSTURE);
        if (f == null) {
            f = font.isItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR;
        }
        float f2 = f.floatValue();
        int n = 0;
        n = 0;
        while (n < fontStyles.length) {
            if (f2 <= fontStyles[n]) break;
            ++n;
        }
        return svgStyles[n];
    }

    private static String weightToSVG(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        Float f = (Float)map.get(TextAttribute.WEIGHT);
        if (f == null) {
            f = font.isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
        }
        float f2 = f.floatValue();
        int n = 0;
        n = 0;
        while (n < fontWeights.length) {
            if (f2 <= fontWeights[n]) break;
            ++n;
        }
        return svgWeights[n];
    }

    public static void main(String[] stringArray) throws Exception {
        Font[] fontArray;
        Font[] fontArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Object[][] objectArrayArray = new Object[][]{{TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_HEAVY}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRABOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_ULTRABOLD}, {TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR}, {TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE}};
        Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
        hashtable.put(TextAttribute.SIZE, new Float(45.0f));
        hashtable.put(TextAttribute.FAMILY, "Serif");
        hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        Font[] fontArray3 = new Font[objectArrayArray.length];
        int n = 0;
        while (n < fontArray3.length) {
            fontArray = new Hashtable(hashtable);
            fontArray.put(objectArrayArray[n][0], objectArrayArray[n][1]);
            fontArray3[n] = new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)fontArray);
            ++n;
        }
        fontArray = new Font[]{new Font("dialog", 0, 12), new Font("dialoginput", 0, 12), new Font("monospaced", 0, 12), new Font("serif", 0, 12), new Font("sansserif", 0, 12), new Font("symbol", 0, 12)};
        SVGFont.traceFonts(fontArray);
    }

    public static void traceFonts(Font[] fontArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        SVGFont sVGFont = new SVGFont();
        int n = 0;
        while (n < fontArray.length) {
            Font font = fontArray[n];
            Map map = SVGFont.toSVG(font).getAttributeMap(null);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "text");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                element2.setAttributeNS(null, string, string2);
            }
            element2.setAttributeNS(null, "font-size", "30");
            element2.setAttributeNS(null, "x", "30");
            element2.setAttributeNS(null, "y", "" + 40 * (n + 1));
            element2.appendChild(document.createTextNode(font.getFamily()));
            element.appendChild(element2);
            ++n;
        }
        SVGCSSStyler.style(element);
        TestUtil.trace(element, System.out);
    }

    static {
        logicalFontMap.put("dialog", "sans-serif");
        logicalFontMap.put("dialoginput", "monospace");
        logicalFontMap.put("monospaced", "monospace");
        logicalFontMap.put("serif", "serif");
        logicalFontMap.put("sansserif", "sans-serif");
        logicalFontMap.put("symbol", "'WingDings'");
    }
}

