/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Paint;
import java.util.Hashtable;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGColor
extends AbstractSVGConverter {
    public static final Color aqua = new Color(0, 255, 255);
    public static final Color black = Color.black;
    public static final Color blue = Color.blue;
    public static final Color fuchsia = new Color(255, 0, 255);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color green = new Color(0, 128, 0);
    public static final Color lime = new Color(0, 255, 0);
    public static final Color maroon = new Color(128, 0, 0);
    public static final Color navy = new Color(0, 0, 128);
    public static final Color olive = new Color(128, 128, 0);
    public static final Color purple = new Color(128, 0, 128);
    public static final Color red = new Color(255, 0, 0);
    public static final Color silver = new Color(192, 192, 192);
    public static final Color teal = new Color(0, 128, 128);
    public static final Color white = Color.white;
    public static final Color yellow = Color.yellow;
    private static Hashtable colorMap = new Hashtable();

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Paint paint = graphicContext.getPaint();
        return SVGColor.toSVG((Color)paint);
    }

    public static SVGPaintDescriptor toSVG(Color color) {
        String string = (String)colorMap.get(color);
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer("rgb(");
            stringBuffer.append(color.getRed());
            stringBuffer.append(",");
            stringBuffer.append(color.getGreen());
            stringBuffer.append(",");
            stringBuffer.append(color.getBlue());
            stringBuffer.append(")");
            string = stringBuffer.toString();
        }
        int n = color.getAlpha();
        float f = (float)color.getAlpha() / 255.0f;
        String string2 = AbstractSVGConverter.doubleString(f);
        return new SVGPaintDescriptor(string, string2);
    }

    public static void main(String[] stringArray) throws Exception {
        Color[] colorArray = new Color[]{new Color(0, 255, 255), new Color(0, 0, 0), new Color(0, 0, 255), new Color(255, 0, 255), new Color(128, 128, 128), new Color(0, 128, 0), new Color(0, 255, 0), new Color(128, 0, 0), new Color(0, 0, 128), new Color(128, 128, 0), new Color(128, 0, 128), new Color(255, 0, 0), new Color(192, 192, 192), new Color(0, 128, 128), new Color(255, 255, 255), new Color(255, 255, 0), new Color(30, 40, 50), new Color(255, 30, 200), new Color(0, 0, 0, 128), new Color(255, 255, 255, 64)};
        Document document = TestUtil.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < colorArray.length) {
            SVGPaintDescriptor sVGPaintDescriptor = SVGColor.toSVG(colorArray[n]);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element2.setAttributeNS(null, "fill", sVGPaintDescriptor.getPaintValue());
            element2.setAttributeNS(null, "fill-opacity", sVGPaintDescriptor.getOpacityValue());
            element.appendChild(element2);
            ++n;
        }
        TestUtil.trace(element, System.out);
    }

    static {
        colorMap.put(black, "black");
        colorMap.put(silver, "silver");
        colorMap.put(gray, "gray");
        colorMap.put(white, "white");
        colorMap.put(maroon, "maroon");
        colorMap.put(red, "red");
        colorMap.put(purple, "purple");
        colorMap.put(fuchsia, "fuchsia");
        colorMap.put(green, "green");
        colorMap.put(lime, "lime");
        colorMap.put(olive, "olive");
        colorMap.put(yellow, "yellow");
        colorMap.put(navy, "navy");
        colorMap.put(blue, "blue");
        colorMap.put(teal, "teal");
        colorMap.put(aqua, "aqua");
    }
}

