/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.TestUtil;
import org.apache.batik.util.Base64Encoder;
import org.w3c.dom.Element;

public class ImageHandlerBase64Encoder
extends DefaultImageHandler {
    private static final String DATA_PROTOCOL_PNG_PREFIX = "data:image/png;base64,";
    public static final String USAGE = "java org.apache.batik.svggen.ImageHandlerBase64Encoder [<imageFile>]";

    protected void handleHREF(Image image, Element element) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == 0 || n2 == 0) {
            this.handleEmptyImage(element);
        } else if (image instanceof RenderedImage) {
            this.handleHREF((RenderedImage)((Object)image), element);
        } else {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            this.handleHREF(bufferedImage, element);
        }
    }

    protected void handleHREF(RenderableImage renderableImage, Element element) {
        if (renderableImage == null) {
            throw new IllegalArgumentException();
        }
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        if (renderedImage == null) {
            this.handleEmptyImage(element);
        } else {
            this.handleHREF(renderedImage, element);
        }
    }

    protected void handleEmptyImage(Element element) {
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", DATA_PROTOCOL_PNG_PREFIX);
        element.setAttributeNS(null, "width", "0");
        element.setAttributeNS(null, "height", "0");
    }

    protected void handleHREF(RenderedImage renderedImage, Element element) {
        byte[] byArray = this.encodeImage(renderedImage);
        Base64Encoder base64Encoder = new Base64Encoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            base64Encoder.encodeBuffer(new ByteArrayInputStream(byArray), (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new Error();
        }
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", DATA_PROTOCOL_PNG_PREFIX + byteArrayOutputStream.toString());
    }

    public byte[] encodeImage(RenderedImage renderedImage) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder((OutputStream)byteArrayOutputStream, null);
            pNGImageEncoder.encode(renderedImage);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        BufferedImage bufferedImage = null;
        if (stringArray.length == 0) {
            bufferedImage = new BufferedImage(100, 100, 2);
            object3 = bufferedImage.createGraphics();
            ((Graphics2D)object3).setPaint(Color.red);
            ((Graphics)object3).fillRect(0, 0, 50, 50);
            ((Graphics)object3).fillRect(50, 50, 50, 50);
            ((Graphics)object3).dispose();
        } else {
            object3 = new Component(){};
            object2 = new MediaTracker((Component)object3);
            object = Toolkit.getDefaultToolkit().createImage(stringArray[0]);
            ((MediaTracker)object2).addImage((Image)object, 0);
            try {
                ((MediaTracker)object2).waitForAll();
            }
            catch (InterruptedException interruptedException) {
                object = null;
            }
            if (object == null) {
                System.err.println("Could not load : " + stringArray[0]);
            }
            bufferedImage = new BufferedImage(((Image)object).getWidth(null), ((Image)object).getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)object, 0, 0, null);
            graphics2D.dispose();
        }
        object3 = new ImageHandlerBase64Encoder();
        object2 = TestUtil.getDocumentPrototype();
        object = object2.createElementNS("http://www.w3.org/2000/svg", "image");
        object3.handleImage(bufferedImage, (Element)object);
        System.out.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        System.out.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20000802//EN\"");
        System.out.println("\"http://www.w3.org/TR/2000/CR-SVG-20000802/DTD/svg-20000802.dtd\">");
        System.out.println();
        System.out.println("<svg width=\"450\" height=\"500\">");
        System.out.println("    <rect width=\"100%\" height=\"100%\" fill=\"yellow\" />");
        System.out.println("    <image width=\"" + bufferedImage.getWidth() + "\" height=\"" + bufferedImage.getHeight() + "\" xlink:href=\"" + XLinkSupport.getXLinkHref((Element)object) + "\" />");
        System.out.println("</svg>");
        System.exit(0);
    }
}

