/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.Reader;
import org.apache.batik.parser.DefaultPointsHandler;
import org.apache.batik.parser.NumberParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsHandler;

public class PointsParser
extends NumberParser {
    protected PointsHandler pointsHandler = DefaultPointsHandler.INSTANCE;
    protected boolean eRead;

    public void setPointsHandler(PointsHandler pointsHandler) {
        this.pointsHandler = pointsHandler;
    }

    public PointsHandler getPointsHandler() {
        return this.pointsHandler;
    }

    public void parse(Reader reader) throws ParseException {
        this.initialize(reader);
        this.pointsHandler.startPoints();
        this.read();
        this.skipSpaces();
        while (this.current != -1) {
            try {
                float f = this.parseFloat();
                this.skipCommaSpaces();
                float f2 = this.parseFloat();
                this.pointsHandler.point(f, f2);
            }
            catch (NumberFormatException numberFormatException) {
                this.reportError("float.format", new Object[]{this.getBufferContent()});
            }
            this.skipCommaSpaces();
        }
        this.pointsHandler.endPoints();
    }

    protected void readNumber() throws ParseException {
        this.bufferSize = 0;
        this.bufferize();
        this.eRead = false;
        block5: while (true) {
            this.read();
            switch (this.current) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: {
                    this.eRead = false;
                    return;
                }
                case 69: 
                case 101: {
                    this.eRead = true;
                    this.bufferize();
                    continue block5;
                }
                case 43: 
                case 45: {
                    if (!this.eRead) {
                        return;
                    }
                    this.eRead = false;
                    this.bufferize();
                    continue block5;
                }
            }
            if (this.current == -1) {
                return;
            }
            this.eRead = false;
            this.bufferize();
        }
    }
}

