/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import org.apache.batik.parser.AbstractParser;
import org.apache.batik.parser.ParseException;

public abstract class NumberParser
extends AbstractParser {
    protected char[] buffer = new char[16];
    protected int bufferSize;

    protected abstract void readNumber() throws ParseException;

    protected float parseFloat() throws NumberFormatException, ParseException {
        this.readNumber();
        return Float.parseFloat(this.getBufferContent());
    }

    protected String getBufferContent() {
        return new String(this.buffer, 0, this.bufferSize);
    }

    protected void bufferize() {
        if (this.bufferSize >= this.buffer.length) {
            char[] cArray = new char[this.buffer.length * 2];
            int n = 0;
            while (n < this.bufferSize) {
                cArray[n] = this.buffer[n];
                ++n;
            }
            this.buffer = cArray;
        }
        this.buffer[this.bufferSize++] = (char)this.current;
    }
}

