/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.Reader;
import org.apache.batik.parser.DefaultLengthHandler;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.NumberParser;
import org.apache.batik.parser.ParseException;

public class LengthParser
extends NumberParser {
    protected LengthHandler lengthHandler = DefaultLengthHandler.INSTANCE;
    protected boolean eRead;

    public void setLengthHandler(LengthHandler lengthHandler) {
        this.lengthHandler = lengthHandler;
    }

    public LengthHandler getLengthHandler() {
        return this.lengthHandler;
    }

    public void parse(Reader reader) throws ParseException {
        this.initialize(reader);
        this.lengthHandler.startLength();
        this.read();
        this.skipSpaces();
        try {
            this.parseLength();
            this.skipSpaces();
            if (this.current != -1) {
                this.reportError("end.of.stream.expected", new Object[]{new Integer(this.current)});
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("float.format", new Object[]{this.getBufferContent()});
        }
        this.lengthHandler.endLength();
    }

    protected void parseLength() throws ParseException, NumberFormatException {
        float f = this.parseFloat();
        this.lengthHandler.lengthValue(f);
        if (this.eRead || this.current != -1) {
            block0 : switch (this.current) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    if (this.eRead) {
                        switch (this.current) {
                            case 109: {
                                this.lengthHandler.em();
                                this.read();
                                break block0;
                            }
                            case 120: {
                                this.lengthHandler.ex();
                                this.read();
                                break block0;
                            }
                        }
                        this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
                        break;
                    }
                    switch (this.current) {
                        case 112: {
                            this.read();
                            switch (this.current) {
                                case 99: {
                                    this.lengthHandler.pc();
                                    this.read();
                                    break block0;
                                }
                                case 116: {
                                    this.lengthHandler.pt();
                                    this.read();
                                    break block0;
                                }
                                case 120: {
                                    this.lengthHandler.px();
                                    this.read();
                                    break block0;
                                }
                            }
                            this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
                            break block0;
                        }
                        case 105: {
                            this.read();
                            if (this.current != 110) {
                                this.reportError("character.expected", new Object[]{new Character('n'), new Integer(this.current)});
                                break block0;
                            }
                            this.lengthHandler.in();
                            this.read();
                            break block0;
                        }
                        case 99: {
                            this.read();
                            if (this.current != 109) {
                                this.reportError("character.expected", new Object[]{new Character('m'), new Integer(this.current)});
                                break block0;
                            }
                            this.lengthHandler.cm();
                            this.read();
                            break block0;
                        }
                        case 109: {
                            this.read();
                            if (this.current != 109) {
                                this.reportError("character.expected", new Object[]{new Character('m'), new Integer(this.current)});
                                break block0;
                            }
                            this.lengthHandler.mm();
                            this.read();
                            break block0;
                        }
                        case 37: {
                            this.lengthHandler.percentage();
                            this.read();
                            break block0;
                        }
                    }
                    this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
                }
            }
        }
    }

    protected void readNumber() throws ParseException {
        this.bufferSize = 0;
        this.bufferize();
        this.eRead = false;
        block7: while (true) {
            this.read();
            switch (this.current) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 37: 
                case 99: 
                case 105: 
                case 112: {
                    return;
                }
                case 69: 
                case 101: {
                    this.eRead = true;
                    this.bufferize();
                    continue block7;
                }
                case 109: {
                    if (!this.eRead) {
                        return;
                    }
                }
                case 120: {
                    --this.bufferSize;
                    return;
                }
                case 43: 
                case 45: {
                    if (!this.eRead) {
                        return;
                    }
                    this.eRead = false;
                    this.bufferize();
                    continue block7;
                }
            }
            if (this.current == -1) {
                return;
            }
            this.eRead = false;
            this.bufferize();
        }
    }
}

