/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.Reader;
import org.apache.batik.parser.AngleHandler;
import org.apache.batik.parser.DefaultAngleHandler;
import org.apache.batik.parser.NumberParser;
import org.apache.batik.parser.ParseException;

public class AngleParser
extends NumberParser {
    protected AngleHandler angleHandler = DefaultAngleHandler.INSTANCE;

    public void setAngleHandler(AngleHandler angleHandler) {
        this.angleHandler = angleHandler;
    }

    public AngleHandler getAngleHandler() {
        return this.angleHandler;
    }

    public void parse(Reader reader) throws ParseException {
        this.initialize(reader);
        this.angleHandler.startAngle();
        this.read();
        this.skipSpaces();
        try {
            float f = this.parseFloat();
            this.angleHandler.angleValue(f);
            if (this.current != -1) {
                block1 : switch (this.current) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    default: {
                        switch (this.current) {
                            case 100: {
                                this.read();
                                if (this.current != 101) {
                                    this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
                                    break block1;
                                }
                                this.read();
                                if (this.current != 103) {
                                    this.reportError("character.expected", new Object[]{new Character('g'), new Integer(this.current)});
                                    break block1;
                                }
                                this.angleHandler.deg();
                                this.read();
                                break block1;
                            }
                            case 103: {
                                this.read();
                                if (this.current != 114) {
                                    this.reportError("character.expected", new Object[]{new Character('r'), new Integer(this.current)});
                                    break block1;
                                }
                                this.read();
                                if (this.current != 97) {
                                    this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
                                    break block1;
                                }
                                this.read();
                                if (this.current != 100) {
                                    this.reportError("character.expected", new Object[]{new Character('d'), new Integer(this.current)});
                                    break block1;
                                }
                                this.angleHandler.grad();
                                this.read();
                                break block1;
                            }
                            case 114: {
                                this.read();
                                if (this.current != 97) {
                                    this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
                                    break block1;
                                }
                                this.read();
                                if (this.current != 100) {
                                    this.reportError("character.expected", new Object[]{new Character('d'), new Integer(this.current)});
                                    break block1;
                                }
                                this.angleHandler.rad();
                                this.read();
                                break block1;
                            }
                        }
                        this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
                    }
                }
            }
            this.skipSpaces();
            if (this.current != -1) {
                this.reportError("end.of.stream.expected", new Object[]{new Integer(this.current)});
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.reportError("float.format", new Object[]{this.getBufferContent()});
        }
        this.angleHandler.endAngle();
    }

    protected void readNumber() throws ParseException {
        this.bufferSize = 0;
        this.bufferize();
        while (true) {
            this.read();
            switch (this.current) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 100: 
                case 103: 
                case 114: {
                    return;
                }
            }
            if (this.current == -1) {
                return;
            }
            this.bufferize();
        }
    }
}

