/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.Mark;

public class TextNode
extends AbstractGraphicsNode
implements Selectable {
    protected Point2D location = new Point2D.Float(0.0f, 0.0f);
    protected AttributedCharacterIterator aci;
    private Rectangle2D geometryBounds;
    private Rectangle2D primitiveBounds;
    Mark beginMark = null;
    Mark endMark = null;

    public void setLocation(Point2D point2D) {
        this.invalidateGeometryCache();
        this.location = point2D;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setAttributedCharacterIterator(AttributedCharacterIterator attributedCharacterIterator) {
        this.invalidateGeometryCache();
        this.aci = attributedCharacterIterator;
    }

    public AttributedCharacterIterator getAttributedCharacterIterator() {
        return this.aci;
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.primitiveBounds = null;
        this.geometryBounds = null;
    }

    public Rectangle2D getPrimitiveBounds(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        if (this.primitiveBounds == null) {
            if (this.aci != null) {
                this.primitiveBounds = graphicsNodeRenderContext.getTextPainter().getPaintedBounds(this, graphicsNodeRenderContext.getFontRenderContext());
            } else {
                System.out.println("ACI is null for " + this);
                return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        return this.primitiveBounds;
    }

    public Rectangle2D getGeometryBounds(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        if (this.geometryBounds == null) {
            if (this.aci != null) {
                this.geometryBounds = graphicsNodeRenderContext.getTextPainter().getBounds(this, graphicsNodeRenderContext.getFontRenderContext());
            } else {
                return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        return this.geometryBounds;
    }

    public boolean contains(Point2D point2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        return this.getBounds(graphicsNodeRenderContext).contains(point2D.getX(), point2D.getY());
    }

    public Shape getOutline(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        Shape shape = this.aci != null ? graphicsNodeRenderContext.getTextPainter().getDecoratedShape(this, graphicsNodeRenderContext.getFontRenderContext()) : new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        return shape;
    }

    public boolean selectAt(double d, double d2, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this.beginMark = graphicsNodeRenderContext.getTextPainter().selectAt(d, d2, this.aci, this, graphicsNodeRenderContext);
        return true;
    }

    public boolean selectTo(double d, double d2, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        Mark mark = graphicsNodeRenderContext.getTextPainter().selectTo(d, d2, this.beginMark, this.aci, this, graphicsNodeRenderContext);
        boolean bl = false;
        if (mark != this.endMark) {
            this.endMark = mark;
            bl = true;
        }
        return bl;
    }

    public boolean selectAll(double d, double d2, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this.beginMark = this.endMark = graphicsNodeRenderContext.getTextPainter().selectAll(d, d2, this.aci, this, graphicsNodeRenderContext);
        return true;
    }

    public Object getSelection(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        int[] nArray = graphicsNodeRenderContext.getTextPainter().getSelected(this.aci, this.beginMark, this.endMark);
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (this.endMark == this.beginMark) {
            attributedCharacterIterator = this.aci;
        } else if (nArray != null && nArray.length > 1 && nArray[1] > nArray[0]) {
            attributedCharacterIterator = new AttributedCharacterSpanIterator(this.aci, nArray[0], nArray[1]);
        }
        return attributedCharacterIterator;
    }

    public Shape getHighlightShape(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        Shape shape = graphicsNodeRenderContext.getTextPainter().getHighlightShape(this.beginMark, this.endMark);
        AffineTransform affineTransform = this.getGlobalTransform();
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public void paint(Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) throws InterruptedException {
        if (this.isVisible) {
            super.paint(graphics2D, graphicsNodeRenderContext);
        }
    }

    public void primitivePaint(Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        TextPainter textPainter;
        Shape shape = graphics2D.getClip();
        if (shape != null && !(shape instanceof GeneralPath)) {
            graphics2D.setClip(new GeneralPath(shape));
        }
        if ((textPainter = graphicsNodeRenderContext.getTextPainter()) != null) {
            textPainter.paint(this, graphics2D, graphicsNodeRenderContext);
        }
    }

    public static final class Anchor
    implements Serializable {
        public static final int ANCHOR_START = 0;
        public static final int ANCHOR_MIDDLE = 1;
        public static final int ANCHOR_END = 2;
        public static final Anchor START = new Anchor(0);
        public static final Anchor MIDDLE = new Anchor(1);
        public static final Anchor END = new Anchor(2);
        private int type;

        private Anchor(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.type) {
                case 0: {
                    return START;
                }
                case 1: {
                    return MIDDLE;
                }
                case 2: {
                    return END;
                }
            }
            throw new Error("Unknown Anchor type");
        }
    }
}

