/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class FloodRed
extends AbstractRed {
    private WritableRaster raster;

    public FloodRed(Rectangle rectangle) {
        this(rectangle, new Color(0, 0, 0, 0));
    }

    public FloodRed(Rectangle rectangle, Paint paint) {
        int n;
        ColorModel colorModel = GraphicsUtil.sRGB_Unpre;
        int n2 = rectangle.width;
        if (n2 > 256) {
            n2 = 256;
        }
        if ((n = rectangle.height) > 256) {
            n = 256;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n2, n);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, 0, 0, null);
        this.raster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(colorModel, this.raster, colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage);
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.dispose();
    }

    public Raster getTile(int n, int n2) {
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        return this.raster.createTranslatedChild(n3, n4);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        int n = this.getXTile(writableRaster.getMinX());
        int n2 = this.getYTile(writableRaster.getMinY());
        int n3 = this.getXTile(writableRaster.getMinX() + writableRaster.getWidth() - 1);
        int n4 = this.getYTile(writableRaster.getMinY() + writableRaster.getHeight() - 1);
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                Raster raster = this.getTile(n6, n5);
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                } else {
                    GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                }
                ++n6;
            }
            ++n5;
        }
        return writableRaster;
    }
}

