/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class GaussianBlurOp
implements BufferedImageOp,
RasterOp {
    static final float SQRT2PI = (float)Math.sqrt(Math.PI * 2);
    static final float DSQRT2PI = SQRT2PI * 3.0f / 4.0f;
    static final float precision = 0.499f;
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final ColorSpace lRGB = ColorSpace.getInstance(1004);
    private float stdDeviationX;
    private float stdDeviationY;
    private final int dX;
    private final int dY;
    private final int radiusX;
    private final int radiusY;
    private boolean useConvolveOp;
    private RenderingHints hints;
    ConvolveOp[] conv;

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    private float[] computeQualityKernelData(int n, float f) {
        float[] fArray = new float[2 * (n - 1) + 1];
        float f2 = 0.0f;
        int n2 = 2 * (n - 1) + 1;
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3] = (float)(Math.pow(Math.E, (float)(-(n3 - n) * (n3 - n)) / (2.0f * f * f)) / (double)(SQRT2PI * f));
            f2 += fArray[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] / f2;
        }
        return fArray;
    }

    private Kernel makeQualityKernelX() {
        return new Kernel(2 * (this.radiusX - 1) + 1, 1, this.computeQualityKernelData(this.radiusX, this.stdDeviationX));
    }

    private Kernel makeQualityKernelY() {
        return new Kernel(1, 2 * (this.radiusY - 1) + 1, this.computeQualityKernelData(this.radiusY, this.stdDeviationY));
    }

    public GaussianBlurOp(double d, double d2, RenderingHints renderingHints) {
        float f;
        int n;
        this.stdDeviationX = (float)d;
        this.stdDeviationY = (float)d2;
        this.hints = renderingHints;
        this.conv = new ConvolveOp[2];
        float f2 = 0.0f;
        if (d < 2.0 || RenderingHints.VALUE_RENDER_QUALITY.equals(renderingHints.get(RenderingHints.KEY_RENDERING))) {
            f2 = (float)(0.5 / (d * (double)SQRT2PI));
            n = 1;
            while (f2 < 0.499f) {
                f = (float)(Math.pow(Math.E, (double)(-n * n) / (2.0 * d * d)) / (d * (double)SQRT2PI));
                f2 += f;
                ++n;
            }
            this.radiusX = n;
            this.dX = 0;
            this.conv[0] = new ConvolveOp(this.makeQualityKernelX());
        } else {
            this.dX = (int)Math.floor((double)DSQRT2PI * d + 0.5);
            n = this.dX / 2;
            this.radiusX = this.dX % 2 == 0 ? 3 * n - 1 : 3 * n;
        }
        if (d2 < 2.0 || RenderingHints.VALUE_RENDER_QUALITY.equals(renderingHints.get(RenderingHints.KEY_RENDERING))) {
            f2 = (float)(0.5 / (d2 * (double)SQRT2PI));
            n = 1;
            while (f2 < 0.499f) {
                f = (float)(Math.pow(Math.E, (double)(-n * n) / (2.0 * d2 * d2)) / (d2 * (double)SQRT2PI));
                f2 += f;
                ++n;
            }
            this.radiusY = n;
            this.dY = 0;
            this.conv[1] = new ConvolveOp(this.makeQualityKernelY());
        } else {
            this.dY = (int)Math.floor((double)DSQRT2PI * d2 + 0.5);
            n = this.dY / 2;
            this.radiusY = this.dY % 2 == 0 ? 3 * n - 1 : 3 * n;
        }
    }

    public GaussianBlurOp(double d, RenderingHints renderingHints) {
        this(d, d, renderingHints);
    }

    public Rectangle2D getBounds2D(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    private void checkCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (!colorSpace.equals(sRGB) && !colorSpace.equals(lRGB)) {
            throw new IllegalArgumentException("Expected CS_sRGB or CS_LINEAR_RGB color model");
        }
        if (!(colorModel instanceof DirectColorModel)) {
            throw new IllegalArgumentException("colorModel should be an instance of DirectColorModel");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("colorModel's transferType should be DataBuffer.TYPE_INT");
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            throw new IllegalArgumentException("red mask in source should be 0x00ff0000");
        }
        if (directColorModel.getGreenMask() != 65280) {
            throw new IllegalArgumentException("green mask in source should be 0x0000ff00");
        }
        if (directColorModel.getBlueMask() != 255) {
            throw new IllegalArgumentException("blue mask in source should be 0x000000ff");
        }
        if (directColorModel.getAlphaMask() != -16777216) {
            throw new IllegalArgumentException("alpha mask in source should be 0xff000000");
        }
    }

    private boolean isCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace != ColorSpace.getInstance(1000) && colorSpace != ColorSpace.getInstance(1004)) {
            return false;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            return false;
        }
        if (directColorModel.getGreenMask() != 65280) {
            return false;
        }
        if (directColorModel.getBlueMask() != 255) {
            return false;
        }
        return directColorModel.getAlphaMask() == -16777216;
    }

    private void checkCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("GaussianBlurOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int n = sampleModel.getNumBands();
        if (n != 4) {
            throw new IllegalArgumentException("GaussianBlurOp only words with Rasters having 4 bands");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("GaussianBlurOp only works with Rasters using DataBufferInt");
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] % 8 != 0) {
                throw new IllegalArgumentException("GaussianBlurOp only works with Rasters using 8 bits per band : " + n2 + " : " + nArray[n2]);
            }
            ++n2;
        }
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return raster.createCompatibleWritableRaster();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.checkCompatible(colorModel, writableRaster.getSampleModel());
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    private WritableRaster boxFilterH(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4) {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n5 < 2 * n + n3) {
            return writableRaster;
        }
        if (n6 < 2 * n2) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n11 = 0x1000000 / n3;
        int n12 = n2;
        while (n12 < n6 - n2) {
            int n13;
            int n14 = n9 + n12 * n7;
            int n15 = n10 + n12 * n8;
            int n16 = n14 + (n5 - n);
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = (n14 += n) + n3;
            while (n14 < n22) {
                n13 = nArray[n14];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n19 += nArray4[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n20 += nArray5[n17];
                nArray6[n17] = n13 & 0xFF;
                n21 += nArray6[n17];
                ++n17;
                ++n14;
            }
            nArray2[n15 += n + n4] = n18 * n11 & 0xFF000000 | (n19 * n11 & 0xFF000000) >>> 8 | (n20 * n11 & 0xFF000000) >>> 16 | (n21 * n11 & 0xFF000000) >>> 24;
            ++n15;
            n17 = 0;
            while (n14 < n16) {
                n13 = nArray[n14];
                n18 -= nArray3[n17];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                n19 -= nArray4[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n20 -= nArray5[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n21 -= nArray6[n17];
                nArray6[n17] = n13 & 0xFF;
                nArray2[n15] = n18 * n11 & 0xFF000000 | ((n19 += nArray4[n17]) * n11 & 0xFF000000) >>> 8 | ((n20 += nArray5[n17]) * n11 & 0xFF000000) >>> 16 | ((n21 += nArray6[n17]) * n11 & 0xFF000000) >>> 24;
                n17 = (n17 + 1) % n3;
                ++n14;
                ++n15;
            }
            ++n12;
        }
        return writableRaster;
    }

    private WritableRaster boxFilterV(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4) {
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n5 < 2 * n) {
            return writableRaster;
        }
        if (n6 < 2 * n2 + n3) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n11 = 0x1000000 / n3;
        int n12 = n;
        while (n12 < n5 - n) {
            int n13;
            int n14 = n9 + n12;
            int n15 = n10 + n12;
            int n16 = n14 + (n6 - n2) * n7;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = (n14 += n2 * n7) + n3 * n7;
            while (n14 < n22) {
                n13 = nArray[n14];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n19 += nArray4[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n20 += nArray5[n17];
                nArray6[n17] = n13 & 0xFF;
                n21 += nArray6[n17];
                ++n17;
                n14 += n7;
            }
            nArray2[n15 += (n2 + n4) * n8] = n18 * n11 & 0xFF000000 | (n19 * n11 & 0xFF000000) >>> 8 | (n20 * n11 & 0xFF000000) >>> 16 | (n21 * n11 & 0xFF000000) >>> 24;
            n15 += n8;
            n17 = 0;
            while (n14 < n16) {
                n13 = nArray[n14];
                n18 -= nArray3[n17];
                nArray3[n17] = n13 >>> 24;
                n18 += nArray3[n17];
                n19 -= nArray4[n17];
                nArray4[n17] = n13 >> 16 & 0xFF;
                n20 -= nArray5[n17];
                nArray5[n17] = n13 >> 8 & 0xFF;
                n21 -= nArray6[n17];
                nArray6[n17] = n13 & 0xFF;
                nArray2[n15] = n18 * n11 & 0xFF000000 | ((n19 += nArray4[n17]) * n11 & 0xFF000000) >>> 8 | ((n20 += nArray5[n17]) * n11 & 0xFF000000) >>> 16 | ((n21 += nArray6[n17]) * n11 & 0xFF000000) >>> 24;
                n17 = (n17 + 1) % n3;
                n14 += n7;
                n15 += n8;
            }
            ++n12;
        }
        return writableRaster;
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n;
        if (raster == null) {
            throw new IllegalArgumentException("Src should not be null");
        }
        if (writableRaster != null) {
            this.checkCompatible(writableRaster.getSampleModel());
        } else {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        WritableRaster writableRaster2 = null;
        if (this.conv[1] == null) {
            writableRaster2 = writableRaster;
        }
        if (this.conv[0] != null) {
            writableRaster2 = this.conv[0].filter(raster, writableRaster2);
            n = this.radiusX;
        } else {
            if (writableRaster2 == null) {
                writableRaster2 = this.createCompatibleDestRaster(raster);
            }
            if (this.dX % 2 == 0) {
                writableRaster2 = this.boxFilterH(raster, writableRaster2, 0, 0, this.dX, this.dX / 2);
                writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2 - 1);
                writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 1, 0, this.dX + 1, this.dX / 2);
            } else {
                writableRaster2 = this.boxFilterH(raster, writableRaster2, 0, 0, this.dX, this.dX / 2);
                writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2);
                writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 1, 0, this.dX, this.dX / 2);
            }
            n = 3 * (this.dX / 2) - 1;
        }
        if (this.conv[1] != null) {
            writableRaster = this.conv[1].filter(writableRaster2, writableRaster);
        } else if (this.dY % 2 == 0) {
            writableRaster = this.boxFilterV(writableRaster2, writableRaster, n, 0, this.dY, this.dY / 2);
            writableRaster = this.boxFilterV(writableRaster, writableRaster, n, this.dY / 2, this.dY, this.dY / 2 - 1);
            writableRaster = this.boxFilterV(writableRaster, writableRaster, n, this.dY - 1, this.dY + 1, this.dY / 2);
        } else {
            writableRaster = this.boxFilterV(writableRaster2, writableRaster, n, 0, this.dY, this.dY / 2);
            writableRaster = this.boxFilterV(writableRaster, writableRaster, n, this.dY / 2, this.dY, this.dY / 2);
            writableRaster = this.boxFilterV(writableRaster, writableRaster, n, this.dY - 1, this.dY, this.dY / 2);
        }
        return writableRaster;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorModel colorModel;
        ColorModel colorModel2;
        if (bufferedImage == null) {
            throw new NullPointerException("Source image should not be null");
        }
        BufferedImage bufferedImage3 = bufferedImage;
        BufferedImage bufferedImage4 = bufferedImage2;
        if (!this.isCompatible(bufferedImage.getColorModel(), bufferedImage.getSampleModel())) {
            bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        } else if (!bufferedImage.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage = new BufferedImage(colorModel, bufferedImage.getRaster(), true, null);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        }
        if (bufferedImage2 == null) {
            bufferedImage4 = bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!this.isCompatible(bufferedImage2.getColorModel(), bufferedImage2.getSampleModel())) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!bufferedImage2.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage2.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage2 = new BufferedImage(colorModel, bufferedImage4.getRaster(), true, null);
        }
        this.filter(bufferedImage.getRaster(), bufferedImage2.getRaster());
        if (bufferedImage.getRaster() == bufferedImage3.getRaster() && bufferedImage.isAlphaPremultiplied() != bufferedImage3.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage, bufferedImage3);
        }
        if (bufferedImage2.getRaster() != bufferedImage4.getRaster() || bufferedImage2.isAlphaPremultiplied() != bufferedImage4.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage2, bufferedImage4);
        }
        return bufferedImage4;
    }
}

