/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.util.List;
import org.apache.batik.ext.awt.image.renderable.ARGBChannel;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.DisplacementMapOp;
import org.apache.batik.ext.awt.image.renderable.DisplacementMapRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class DisplacementMapRable8Bit
extends AbstractRable
implements DisplacementMapRable {
    private double scale;
    private ARGBChannel xChannelSelector;
    private ARGBChannel yChannelSelector;

    public DisplacementMapRable8Bit(List list, double d, ARGBChannel aRGBChannel, ARGBChannel aRGBChannel2) {
        this.setSources(list);
        this.setScale(d);
        this.setXChannelSelector(aRGBChannel);
        this.setYChannelSelector(aRGBChannel2);
    }

    public Rectangle2D getBounds2D() {
        return ((Filter)this.getSources().elementAt(0)).getBounds2D();
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setSources(List list) {
        if (list.size() != 2) {
            throw new IllegalArgumentException();
        }
        this.init(list, null);
    }

    public void setXChannelSelector(ARGBChannel aRGBChannel) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException();
        }
        this.xChannelSelector = aRGBChannel;
    }

    public ARGBChannel getXChannelSelector() {
        return this.xChannelSelector;
    }

    public void setYChannelSelector(ARGBChannel aRGBChannel) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException();
        }
        this.yChannelSelector = aRGBChannel;
    }

    public ARGBChannel getYChannelSelector() {
        return this.yChannelSelector;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Filter filter;
        Rectangle2D rectangle2D;
        RenderContext renderContext2;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        double d3 = affineTransform.getShearX();
        double d4 = affineTransform.getShearY();
        double d5 = affineTransform.getTranslateX();
        double d6 = affineTransform.getTranslateY();
        double d7 = Math.sqrt(d * d + d4 * d4);
        double d8 = Math.sqrt(d2 * d2 + d3 * d3);
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d7, d8);
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        Filter filter2 = (Filter)this.getSources().elementAt(1);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter2, rectangle2D2, PadMode.ZERO_PAD);
        RenderedImage renderedImage = padRable8Bit.createRendering(renderContext2 = new RenderContext(affineTransform2, rectangle2D2, renderingHints));
        if (renderedImage == null) {
            return null;
        }
        if (!(rectangle2D2 = new Rectangle2D.Double(rectangle2D2.getX() - this.scale / 2.0, rectangle2D2.getY() - this.scale / 2.0, rectangle2D2.getWidth() + this.scale, rectangle2D2.getHeight() + this.scale)).intersects(rectangle2D = (filter = (Filter)this.getSources().elementAt(0)).getBounds2D())) {
            return null;
        }
        renderContext2 = new RenderContext(affineTransform2, rectangle2D2 = rectangle2D2.createIntersection(rectangle2D), renderingHints);
        RenderedImage renderedImage2 = filter.createRendering(renderContext2);
        if (renderedImage2 == null) {
            return null;
        }
        Raster raster = renderedImage2.getData();
        Raster raster2 = renderedImage.getData();
        int n = (int)(this.scale * d7);
        int n2 = (int)(this.scale * d8);
        DisplacementMapOp displacementMapOp = new DisplacementMapOp(this.xChannelSelector, this.yChannelSelector, n, n2, raster2);
        WritableRaster writableRaster = displacementMapOp.filter(raster, null);
        writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
        ColorModel colorModel = renderedImage2.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        AffineTransform affineTransform3 = new AffineTransform(d / d7, d4 / d7, d3 / d8, d2 / d8, d5, d6);
        int n3 = renderedImage.getMinX();
        int n4 = renderedImage.getMinY();
        AbstractRed abstractRed = new BufferedImageCachableRed(bufferedImage, n3, n4);
        if (!affineTransform3.isIdentity()) {
            abstractRed = new AffineRed((CachableRed)abstractRed, affineTransform3, renderingHints);
        }
        return abstractRed;
    }

    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        return super.getDependencyRegion(n, rectangle2D);
    }

    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        return super.getDirtyRegion(n, rectangle2D);
    }
}

