/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLoader {
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);

    public static synchronized Image loadImage(String string) {
        File file = new File(string);
        Image image = null;
        try {
            URL uRL = file.toURL();
            image = ImageLoader.loadImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return image;
    }

    public static synchronized Image loadImage(URL uRL) {
        Image image = null;
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image != null) {
            tracker.addImage(image, 0);
            try {
                try {
                    tracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    tracker.removeImage(image);
                    image = null;
                    Object var4_3 = null;
                    if (image != null) {
                        tracker.removeImage(image);
                    }
                    if (tracker.isErrorAny()) {
                        image = null;
                    }
                    if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                        image = null;
                    }
                }
                Object var4_2 = null;
                if (image != null) {
                    tracker.removeImage(image);
                }
                if (tracker.isErrorAny()) {
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    image = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (image != null) {
                    tracker.removeImage(image);
                }
                if (tracker.isErrorAny()) {
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    image = null;
                }
                throw throwable;
            }
        }
        return image;
    }

    public static synchronized BufferedImage loadImage(File file, int n) {
        BufferedImage bufferedImage = null;
        try {
            URL uRL = file.toURL();
            bufferedImage = ImageLoader.loadImage(uRL, n);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bufferedImage;
    }

    public static synchronized BufferedImage loadImage(String string, int n) {
        File file = new File(string);
        BufferedImage bufferedImage = null;
        try {
            URL uRL = file.toURL();
            bufferedImage = ImageLoader.loadImage(uRL, n);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bufferedImage;
    }

    public static synchronized BufferedImage loadImage(URL uRL, int n) {
        BufferedImage bufferedImage = null;
        if (uRL == null || !uRL.toString().toLowerCase().endsWith(".jpg")) {
            Image image = ImageLoader.loadImage(uRL);
            if (image != null) {
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
            }
        } else {
            BufferedImage bufferedImage2 = ImageLoader.loadJPEGImage(uRL);
            if (bufferedImage2 != null) {
                if (bufferedImage2.getType() != n) {
                    bufferedImage = new BufferedImage(bufferedImage2.getWidth(null), bufferedImage2.getHeight(null), n);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
                    graphics2D.dispose();
                } else {
                    bufferedImage = bufferedImage2;
                }
            }
        }
        return bufferedImage;
    }

    /*
     * Loose catch block
     */
    public static synchronized BufferedImage loadJPEGImage(URL uRL) {
        BufferedImage bufferedImage;
        block13: {
            block12: {
                bufferedImage = null;
                if (uRL == null) break block13;
                InputStream inputStream = null;
                inputStream = uRL.openStream();
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                Object var5_5 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block12;
                }
                catch (IOException iOException) {}
                break block12;
                {
                    catch (IOException iOException) {
                        bufferedImage = null;
                        Object var5_6 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block12;
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (bufferedImage != null && (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0)) {
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }
}

