/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaintContext;

final class RadialGradientPaintContext
extends MultipleGradientPaintContext {
    private boolean isSimpleFocus = false;
    private boolean isNonCyclic = false;
    private float radius;
    private float centerX;
    private float centerY;
    private float focusX;
    private float focusY;
    private float radiusSq;
    private float constA;
    private float constB;
    private float trivial;
    private static final float SCALEBACK = 0.97f;
    private int MAX_PRECISION = 256;
    private float sqStepFloat;
    private int[] sqrtLutFixed = new int[this.MAX_PRECISION];

    public RadialGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float f, float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        super(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
        this.calculateGradientFractions();
        this.centerX = f;
        this.centerY = f2;
        this.focusX = f4;
        this.focusY = f5;
        this.radius = f3;
        this.isSimpleFocus = this.focusX == this.centerX && this.focusY == this.centerY;
        this.isNonCyclic = cycleMethodEnum == MultipleGradientPaint.NO_CYCLE;
        this.radiusSq = this.radius * this.radius;
        float f6 = this.focusX - this.centerX;
        float f7 = this.focusY - this.centerY;
        double d = Math.sqrt(f6 * f6 + f7 * f7);
        if (d > (double)this.radius) {
            if (f7 == 0.0f) {
                this.focusY = this.centerY;
                this.focusX = this.centerX + this.radius * 0.97f;
            } else {
                double d2 = Math.atan2(f7, f6);
                this.focusX = (float)Math.floor((double)(0.97f * this.radius) * Math.cos(d2)) + this.centerX;
                this.focusY = (float)Math.floor((double)(0.97f * this.radius) * Math.sin(d2)) + this.centerY;
            }
        }
        f6 = this.focusX - this.centerX;
        this.trivial = (float)Math.sqrt(this.radiusSq - f6 * f6);
        this.constA = this.a02 - this.centerX;
        this.constB = this.a12 - this.centerY;
        this.calculateFixedPointSqrtLookupTable();
    }

    protected void fillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isSimpleFocus && this.isNonCyclic && this.isSimpleLookup) {
            this.fixedPointSimplestCaseNonCyclicFillRaster(nArray, n, n2, n3, n4, n5, n6);
        } else {
            this.cyclicCircularGradientFillRaster(nArray, n, n2, n3, n4, n5, n6);
        }
    }

    private void fixedPointSimplestCaseNonCyclicFillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = (float)this.fastGradientArraySize / this.radius;
        float f2 = this.a00 * (float)n3 + this.a01 * (float)n4 + this.constA;
        float f3 = this.a10 * (float)n3 + this.a11 * (float)n4 + this.constB;
        float f4 = f * this.a00;
        float f5 = f * this.a10;
        int n7 = n;
        int n8 = this.fastGradientArraySize * this.fastGradientArraySize;
        int n9 = 0;
        while (n9 < n6) {
            float f6 = f * (this.a01 * (float)n9 + f2);
            float f7 = f * (this.a11 * (float)n9 + f3);
            float f8 = f4 * f4 + f5 * f5;
            float f9 = f7 * f7 + f6 * f6;
            float f10 = (f5 * f7 + f4 * f6) * 2.0f + f8;
            float f11 = f8 * 2.0f;
            int n10 = 0;
            while (n10 < n5) {
                int n11;
                if (f9 > (float)n8) {
                    n11 = this.fastGradientArraySize;
                } else {
                    float f12 = f9 / this.sqStepFloat;
                    int n12 = (int)f12;
                    n11 = (int)((f12 -= (float)n12) * (float)this.sqrtLutFixed[n12 + 1] + (1.0f - f12) * (float)this.sqrtLutFixed[n12]);
                }
                nArray[n7++] = this.gradient[n11];
                f9 += f10;
                f10 += f11;
                ++n10;
            }
            n7 += n2;
            ++n9;
        }
    }

    private void fixedPointSimplestCaseNonCyclicFillRasterOriginal(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = (float)this.fastGradientArraySize / this.radius;
        float f2 = 16.0f;
        float f3 = this.a00 * (float)n3 + this.a01 * (float)n4 + this.constA;
        float f4 = this.a10 * (float)n3 + this.a11 * (float)n4 + this.constB;
        float f5 = f * this.a00;
        float f6 = f * this.a10;
        int n7 = n;
        int n8 = n5 + n2;
        int n9 = this.fastGradientArraySize * this.fastGradientArraySize << 4;
        int n10 = 0;
        while (n10 < n6) {
            float f7 = f * (this.a01 * (float)n10 + f3);
            float f8 = f * (this.a11 * (float)n10 + f4);
            int n11 = (int)(f5 * f5 + f6 * f6);
            int n12 = (int)((f8 * f8 + f7 * f7) * f2);
            int n13 = (int)(((f6 * f8 + f5 * f7) * 2.0f + (float)n11) * f2);
            int n14 = (int)((float)(n11 * 2) * f2);
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                if (n12 > n9) {
                    n16 = this.fastGradientArraySize;
                } else if (n12 < 0) {
                    n16 = 0;
                } else {
                    float f9 = (float)(n12 >>> 4) / this.sqStepFloat;
                    int n17 = (int)f9;
                    float f10 = f9 - (float)n17;
                    n16 = (int)(f10 * (float)this.sqrtLutFixed[n17 + 1] + (1.0f - f10) * (float)this.sqrtLutFixed[n17]);
                }
                nArray[n7 + n15] = this.gradient[n16];
                n12 += n13;
                n13 += n14;
                ++n15;
            }
            n7 += n8;
            ++n10;
        }
    }

    private void calculateFixedPointSqrtLookupTable() {
        this.sqStepFloat = this.fastGradientArraySize * this.fastGradientArraySize / (this.MAX_PRECISION - 2);
        int n = 0;
        while (n < this.MAX_PRECISION - 1) {
            this.sqrtLutFixed[n] = (int)Math.sqrt((float)n * this.sqStepFloat);
            ++n;
        }
        this.sqrtLutFixed[n] = this.sqrtLutFixed[n - 1];
    }

    private void cyclicCircularGradientFillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        double d = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float f = this.a00 * (float)n3 + this.a01 * (float)n4 + this.a02;
        float f2 = this.a10 * (float)n3 + this.a11 * (float)n4 + this.a12;
        float f3 = 2.0f * this.centerY;
        float f4 = -2.0f * this.centerX;
        int n7 = n;
        int n8 = n5 + n2;
        int n9 = 0;
        while (n9 < n6) {
            float f5 = this.a01 * (float)n9 + f;
            float f6 = this.a11 * (float)n9 + f2;
            int n10 = 0;
            while (n10 < n5) {
                double d2;
                double d3;
                if (f5 == this.focusX) {
                    d3 = this.focusX;
                    d2 = this.centerY;
                    d2 += f6 > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    double d4 = (f6 - this.focusY) / (f5 - this.focusX);
                    double d5 = (double)f6 - d4 * (double)f5;
                    double d6 = d4 * d4 + 1.0;
                    double d7 = (double)f4 + -2.0 * d4 * ((double)this.centerY - d5);
                    double d8 = d + d5 * (d5 - (double)f3);
                    float f7 = (float)Math.sqrt(d7 * d7 - 4.0 * d6 * d8);
                    d3 = -d7;
                    d3 += f5 < this.focusX ? (double)(-f7) : (double)f7;
                    d2 = d4 * (d3 /= 2.0 * d6) + d5;
                }
                float f8 = f5 - this.focusX;
                f8 *= f8;
                float f9 = f6 - this.focusY;
                f9 *= f9;
                float f10 = f8 + f9;
                f8 = (float)d3 - this.focusX;
                f8 *= f8;
                f9 = (float)d2 - this.focusY;
                f9 *= f9;
                float f11 = f8 + f9;
                float f12 = (float)Math.sqrt(f10 / f11);
                nArray[n7 + n10] = this.indexIntoGradientsArrays(f12);
                f5 += this.a00;
                f6 += this.a10;
                ++n10;
            }
            n7 += n8;
            ++n9;
        }
    }
}

