/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXSVGDocumentFactory
extends SAXDocumentFactory
implements SVGDocumentFactory {
    protected static final String DTDS = "org.apache.batik.dom.svg.resources.dtduris";
    protected static String uris;

    public SAXSVGDocumentFactory(String string) {
        super(SVGDOMImplementation.getDOMImplementation(), string);
    }

    public SAXSVGDocumentFactory(String string, boolean bl) {
        super(SVGDOMImplementation.getDOMImplementation(), string, bl);
    }

    public SVGOMDocument createDocument(String string) throws IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Malformed URL: " + string);
        }
        InputStream inputStream = uRL.openStream();
        try {
            inputStream = new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            inputStream.close();
            inputStream = uRL.openStream();
        }
        InputSource inputSource = new InputSource(inputStream);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
        sVGOMDocument.setURLObject(uRL);
        return sVGOMDocument;
    }

    public SVGOMDocument createDocument(String string, InputStream inputStream) throws IOException {
        SVGOMDocument sVGOMDocument;
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        try {
            sVGOMDocument = (SVGOMDocument)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
            if (string != null) {
                sVGOMDocument.setURLObject(new URL(string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return sVGOMDocument;
    }

    public SVGOMDocument createDocument(String string, Reader reader) throws IOException {
        SVGOMDocument sVGOMDocument;
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        try {
            sVGOMDocument = (SVGOMDocument)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
            if (string != null) {
                sVGOMDocument.setURLObject(new URL(string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return sVGOMDocument;
    }

    public Document createDocument(String string, String string2, String string3) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3);
    }

    public Document createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3, inputStream);
    }

    public Document createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3, reader);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            if (uris == null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(DTDS, Locale.getDefault());
                uris = resourceBundle.getString("uris");
            }
            if (uris.indexOf(string2) != -1) {
                return new InputSource(this.getClass().getResource("resources/svg-20001102.dtd").toString());
            }
        }
        catch (MissingResourceException missingResourceException) {
            throw new SAXException(missingResourceException);
        }
        return null;
    }
}

