/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractIdentifierFactory;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ImmutableValueList;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class CursorFactory
extends AbstractIdentifierFactory
implements ValueConstants {
    protected static final PropertyMap values = new PropertyMap();
    protected ValueFactory uriFactory = new AbstractValueFactory.URIFactory(this.getParser());
    protected ValueFactory identFactory = new IdentifierFactory(this.getParser());

    public CursorFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "cursor";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == 24) {
            ImmutableValueList immutableValueList = new ImmutableValueList();
            do {
                immutableValueList.append(new CSSOMValue(this.uriFactory, this.uriFactory.createValue(lexicalUnit)));
            } while ((lexicalUnit = lexicalUnit.getNextLexicalUnit().getNextLexicalUnit()).getLexicalUnitType() == 24);
            immutableValueList.append(new CSSOMValue(this.identFactory, this.identFactory.createValue(lexicalUnit)));
            return immutableValueList;
        }
        return super.createValue(lexicalUnit);
    }

    protected PropertyMap getIdentifiers() {
        return values;
    }

    static {
        values.put("auto", ValueConstants.AUTO_VALUE);
        values.put("crosshair", ValueConstants.CROSSHAIR_VALUE);
        values.put("default", ValueConstants.DEFAULT_VALUE);
        values.put("e-resize", ValueConstants.E_RESIZE_VALUE);
        values.put("help", ValueConstants.HELP_VALUE);
        values.put("move", ValueConstants.MOVE_VALUE);
        values.put("n-resize", ValueConstants.N_RESIZE_VALUE);
        values.put("ne-resize", ValueConstants.NE_RESIZE_VALUE);
        values.put("nw-resize", ValueConstants.NW_RESIZE_VALUE);
        values.put("pointer", ValueConstants.POINTER_VALUE);
        values.put("s-resize", ValueConstants.S_RESIZE_VALUE);
        values.put("se-resize", ValueConstants.SE_RESIZE_VALUE);
        values.put("sw-resize", ValueConstants.SW_RESIZE_VALUE);
        values.put("text", ValueConstants.TEXT_VALUE);
        values.put("w-resize", ValueConstants.W_RESIZE_VALUE);
        values.put("wait", ValueConstants.WAIT_VALUE);
    }

    protected class IdentifierFactory
    extends AbstractValueFactory {
        public IdentifierFactory(Parser parser) {
            super(parser);
        }

        public String getPropertyName() {
            return null;
        }

        public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
            return CursorFactory.super.createValue(lexicalUnit);
        }

        public ImmutableValue createStringValue(short s, String string) throws DOMException {
            return CursorFactory.super.createStringValue(s, string);
        }
    }
}

