/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Composite;
import java.awt.geom.AffineTransform;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.util.SVGConstants;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGElement;

public abstract class SVGShapeElementBridge
implements GraphicsNodeBridge,
SVGConstants {
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        SVGElement sVGElement = (SVGElement)element;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        ShapeNode shapeNode = new ShapeNode();
        String string = element.getAttributeNS(null, "transform");
        if (string.length() > 0) {
            AffineTransform affineTransform = SVGUtilities.convertAffineTransform(string);
            shapeNode.setTransform(affineTransform);
        }
        shapeNode.setVisible(CSSUtilities.convertVisibility(element));
        this.buildShape(bridgeContext, sVGElement, shapeNode, cSSStyleDeclaration, defaultUnitProcessorContext);
        return shapeNode;
    }

    public void buildGraphicsNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element) {
        ShapeNode shapeNode = (ShapeNode)graphicsNode;
        SVGElement sVGElement = (SVGElement)element;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        ShapePainter shapePainter = this.convertPainter(sVGElement, shapeNode, cSSStyleDeclaration, defaultUnitProcessorContext, bridgeContext);
        shapeNode.setShapePainter(shapePainter);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("opacity");
        Composite composite = CSSUtilities.convertOpacityToComposite(cSSPrimitiveValue);
        shapeNode.setComposite(composite);
        Filter filter = CSSUtilities.convertFilter(element, shapeNode, bridgeContext);
        shapeNode.setFilter(filter);
        Mask mask = CSSUtilities.convertMask(element, shapeNode, bridgeContext);
        shapeNode.setMask(mask);
        Clip clip = CSSUtilities.convertClipPath(element, shapeNode, bridgeContext);
        shapeNode.setClip(clip);
        BridgeEventSupport.addDOMListener(bridgeContext, sVGElement);
        bridgeContext.bind(element, shapeNode);
    }

    protected ShapePainter convertPainter(SVGElement sVGElement, ShapeNode shapeNode, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context, BridgeContext bridgeContext) {
        return CSSUtilities.convertStrokeAndFill(shapeNode.getShape(), sVGElement, shapeNode, bridgeContext, cSSStyleDeclaration, context);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    public boolean isContainer() {
        return false;
    }

    protected abstract void buildShape(BridgeContext var1, SVGElement var2, ShapeNode var3, CSSStyleDeclaration var4, UnitProcessor.Context var5);
}

