/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.ARGBChannel;
import org.apache.batik.ext.awt.image.renderable.DisplacementMapRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeDisplacementMapElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string = element.getAttributeNS(null, "scale");
        double d = 0.0;
        if (string.length() != 0) {
            d = SVGUtilities.convertSVGNumber("scale", string);
        }
        String string2 = element.getAttributeNS(null, "xChannelSelector");
        ARGBChannel aRGBChannel = SVGFeDisplacementMapElementBridge.computeChannelSelector(string2);
        String string3 = element.getAttributeNS(null, "yChannelSelector");
        ARGBChannel aRGBChannel2 = SVGFeDisplacementMapElementBridge.computeChannelSelector(string3);
        DisplacementMapRable8Bit displacementMapRable8Bit = null;
        String string4 = element.getAttributeNS(null, "in");
        Filter filter2 = CSSUtilities.getFilterSource(graphicsNode, string4, bridgeContext, element2, filter, map);
        Filter filter3 = null;
        String string5 = element.getAttributeNS(null, "in2");
        if (string5.length() == 0) {
            throw new MissingAttributeException(Messages.formatMessage("feDisplacementMap.in2.required", null));
        }
        filter3 = CSSUtilities.getFilterSource(graphicsNode, string5, bridgeContext, element2, filter, map);
        Filter filter4 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        rectangle2D2.add(filter3.getBounds2D());
        if (filter2 == filter4) {
            rectangle2D2 = rectangle2D;
        }
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter, rectangle2D3, PadMode.ZERO_PAD);
        Vector<Filter> vector = new Vector<Filter>();
        vector.addElement(padRable8Bit);
        vector.addElement(filter3);
        displacementMapRable8Bit = new DisplacementMapRable8Bit(vector, d, aRGBChannel, aRGBChannel2);
        String string6 = element.getAttributeNS(null, "result");
        if (string6 != null && string6.trim().length() > 0) {
            map.put(string6, displacementMapRable8Bit);
        }
        return displacementMapRable8Bit;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    private static ARGBChannel computeChannelSelector(String string) {
        ARGBChannel aRGBChannel;
        if (string.length() == 0) {
            aRGBChannel = ARGBChannel.A;
        } else if ("A".equals(string)) {
            aRGBChannel = ARGBChannel.A;
        } else if ("R".equals(string)) {
            aRGBChannel = ARGBChannel.R;
        } else if ("G".equals(string)) {
            aRGBChannel = ARGBChannel.G;
        } else if ("B".equals(string)) {
            aRGBChannel = ARGBChannel.B;
        } else {
            throw new IllegalAttributeValueException(Messages.formatMessage("feDisplacementMap.channelSelector.invalid", new Object[]{string}));
        }
        return aRGBChannel;
    }
}

