/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeUpdateManager;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGCircleElementBridge;
import org.apache.batik.bridge.SVGClipPathElementBridge;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.SVGEllipseElementBridge;
import org.apache.batik.bridge.SVGFeBlendElementBridge;
import org.apache.batik.bridge.SVGFeColorMatrixElementBridge;
import org.apache.batik.bridge.SVGFeComponentTransferElementBridge;
import org.apache.batik.bridge.SVGFeCompositeElementBridge;
import org.apache.batik.bridge.SVGFeConvolveMatrixElementBridge;
import org.apache.batik.bridge.SVGFeDiffuseLightingElementBridge;
import org.apache.batik.bridge.SVGFeDisplacementMapElementBridge;
import org.apache.batik.bridge.SVGFeFloodElementBridge;
import org.apache.batik.bridge.SVGFeGaussianBlurElementBridge;
import org.apache.batik.bridge.SVGFeImageElementBridge;
import org.apache.batik.bridge.SVGFeMergeElementBridge;
import org.apache.batik.bridge.SVGFeMorphologyElementBridge;
import org.apache.batik.bridge.SVGFeOffsetElementBridge;
import org.apache.batik.bridge.SVGFeSpecularLightingElementBridge;
import org.apache.batik.bridge.SVGFeTileElementBridge;
import org.apache.batik.bridge.SVGFeTurbulenceElementBridge;
import org.apache.batik.bridge.SVGFilterElementBridge;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.bridge.SVGLineElementBridge;
import org.apache.batik.bridge.SVGLinearGradientBridge;
import org.apache.batik.bridge.SVGMarkerElementBridge;
import org.apache.batik.bridge.SVGMaskElementBridge;
import org.apache.batik.bridge.SVGPathElementBridge;
import org.apache.batik.bridge.SVGPatternElementBridge;
import org.apache.batik.bridge.SVGPolygonElementBridge;
import org.apache.batik.bridge.SVGPolylineElementBridge;
import org.apache.batik.bridge.SVGRadialGradientBridge;
import org.apache.batik.bridge.SVGRectElementBridge;
import org.apache.batik.bridge.SVGSVGElementBridge;
import org.apache.batik.bridge.SVGSwitchElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUseElementBridge;
import org.apache.batik.bridge.StyleReference;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentViewport;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.filter.ConcreteGraphicsNodeRableFactory;
import org.apache.batik.gvt.filter.GraphicsNodeRableFactory;
import org.apache.batik.script.InterpreterPool;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public class BridgeContext
implements SVGConstants {
    protected GVTBuilder gvtBuilder;
    protected Viewport viewport;
    protected UserAgent userAgent;
    protected HashMap elementNodeMap;
    protected HashMap nodeElementMap;
    protected HashMap elementStyleAttMap;
    protected HashMap nodeStyleMap;
    protected HashMap namespaceURIMap;
    protected GraphicsNodeRenderContext rc;
    protected InterpreterPool interpreterPool;
    protected DocumentLoader documentLoader;
    private static InterpreterPool sharedPool = new InterpreterPool();
    protected static HashMap globalBridges;
    private BridgeUpdateManager updateManager = new BridgeUpdateManager(this);
    private GraphicsNodeRableFactory graphicsNodeRableFactory = new ConcreteGraphicsNodeRableFactory();

    protected BridgeContext() {
    }

    public BridgeContext(UserAgent userAgent, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this(userAgent, graphicsNodeRenderContext, sharedPool, new DocumentLoader(userAgent.getXMLParserClassName()));
    }

    public BridgeContext(UserAgent userAgent, GraphicsNodeRenderContext graphicsNodeRenderContext, DocumentLoader documentLoader) {
        this(userAgent, graphicsNodeRenderContext, sharedPool, documentLoader);
    }

    public BridgeContext(UserAgent userAgent, GraphicsNodeRenderContext graphicsNodeRenderContext, InterpreterPool interpreterPool, DocumentLoader documentLoader) {
        this.userAgent = userAgent;
        this.viewport = new UserAgentViewport(userAgent);
        this.rc = graphicsNodeRenderContext;
        this.interpreterPool = interpreterPool;
        this.documentLoader = documentLoader;
        BridgeContext.registerSVGBridges(this);
    }

    void initialize(GVTBuilder gVTBuilder) {
        this.gvtBuilder = gVTBuilder;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public GVTBuilder getGVTBuilder() {
        return this.gvtBuilder;
    }

    public InterpreterPool getInterpreterPool() {
        return this.interpreterPool;
    }

    public void setInterpreterPool(InterpreterPool interpreterPool) {
        this.interpreterPool = interpreterPool;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }

    public GraphicsNodeRenderContext getGraphicsNodeRenderContext() {
        return this.rc;
    }

    public void setGraphicsNodeRenderContext(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this.rc = graphicsNodeRenderContext;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public void bind(Element element, GraphicsNode graphicsNode) {
        if (this.elementNodeMap == null) {
            this.elementNodeMap = new HashMap();
            this.nodeElementMap = new HashMap();
        }
        this.elementNodeMap.put(element, graphicsNode);
        this.nodeElementMap.put(graphicsNode, element);
    }

    public void unbind(Element element) {
        if (this.elementNodeMap == null) {
            return;
        }
        GraphicsNode graphicsNode = (GraphicsNode)this.elementNodeMap.get(element);
        this.elementNodeMap.remove(element);
        this.nodeElementMap.remove(graphicsNode);
        this.removeStyleReferences(graphicsNode);
    }

    public GraphicsNode getGraphicsNode(Element element) {
        if (this.elementNodeMap != null) {
            return (GraphicsNode)this.elementNodeMap.get(element);
        }
        return null;
    }

    public Element getElement(GraphicsNode graphicsNode) {
        if (this.nodeElementMap != null) {
            return (Element)this.nodeElementMap.get(graphicsNode);
        }
        return null;
    }

    public void bind(Element element, StyleReference styleReference) {
        GraphicsNode graphicsNode;
        LinkedList<StyleReference> linkedList;
        if (this.elementStyleAttMap == null) {
            this.elementStyleAttMap = new HashMap();
        }
        if ((linkedList = (LinkedList<StyleReference>)this.elementStyleAttMap.get(element)) == null) {
            linkedList = new LinkedList<StyleReference>();
            this.elementStyleAttMap.put(element, linkedList);
        }
        linkedList.add(styleReference);
        if (this.nodeStyleMap == null) {
            this.nodeStyleMap = new HashMap();
        }
        if ((linkedList = (LinkedList<StyleReference>)this.nodeStyleMap.get(graphicsNode = styleReference.getGraphicsNode())) == null) {
            linkedList = new LinkedList<StyleReference>();
            this.nodeStyleMap.put(graphicsNode, linkedList);
        }
        linkedList.add((StyleReference)((Object)element));
    }

    public List getStyleReferenceList(Element element) {
        if (this.elementStyleAttMap == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList linkedList = (LinkedList)this.elementStyleAttMap.get(element);
        if (linkedList != null) {
            return linkedList;
        }
        return Collections.EMPTY_LIST;
    }

    private void removeStyleReferences(GraphicsNode graphicsNode) {
        if (this.nodeStyleMap == null) {
            return;
        }
        List list = (List)this.nodeStyleMap.get(graphicsNode);
        if (list != null) {
            this.nodeStyleMap.remove(graphicsNode);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.removeStyleReference(graphicsNode, element);
        }
    }

    private void removeStyleReference(GraphicsNode graphicsNode, Element element) {
        Object object;
        if (this.elementStyleAttMap == null) {
            return;
        }
        LinkedList linkedList = (LinkedList)this.elementStyleAttMap.get(element);
        LinkedList<Object> linkedList2 = null;
        if (linkedList == null) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (StyleReference)iterator.next();
            if (((StyleReference)object).getGraphicsNode() != graphicsNode) continue;
            if (linkedList2 == null) {
                linkedList2 = new LinkedList<Object>();
            }
            linkedList2.add(object);
        }
        if (linkedList2 != null) {
            object = linkedList2.iterator();
            while (object.hasNext()) {
                linkedList.remove(object.next());
            }
        }
        if (linkedList.size() == 0) {
            this.elementStyleAttMap.remove(element);
        }
    }

    public Bridge getBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return null;
        }
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string = string == null ? "" : string);
        if (hashMap == null) {
            return null;
        }
        return (Bridge)hashMap.get(string2);
    }

    public Bridge getBridge(String string, String string2) {
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string);
        if (hashMap == null) {
            return null;
        }
        return (Bridge)hashMap.get(string2);
    }

    public void putBridge(String string, String string2, Bridge bridge) {
        HashMap<String, Bridge> hashMap;
        if (this.namespaceURIMap == null) {
            this.namespaceURIMap = new HashMap();
        }
        if ((hashMap = (HashMap<String, Bridge>)this.namespaceURIMap.get(string = string == null ? "" : string)) == null) {
            hashMap = new HashMap<String, Bridge>();
            this.namespaceURIMap.put(string, hashMap);
        }
        hashMap.put(string2, bridge);
    }

    public void removeBridge(String string, String string2) {
        if (this.namespaceURIMap == null) {
            return;
        }
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string = string == null ? "" : string);
        if (hashMap != null) {
            hashMap.remove(string2);
            if (hashMap.isEmpty()) {
                this.namespaceURIMap.remove(string);
                if (this.namespaceURIMap.isEmpty()) {
                    this.namespaceURIMap = null;
                }
            }
        }
    }

    public static void registerSVGBridges(BridgeContext bridgeContext) {
        if (globalBridges != null) {
            Iterator iterator = globalBridges.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map = (Map)globalBridges.get(string);
                if (map == null) continue;
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    bridgeContext.putBridge(string, string2, (Bridge)map.get(string2));
                }
            }
        }
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "a", new SVGAElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "circle", new SVGCircleElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "clipPath", new SVGClipPathElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "color-profile", new SVGColorProfileElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "ellipse", new SVGEllipseElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feBlend", new SVGFeBlendElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feColorMatrix", new SVGFeColorMatrixElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feComponentTransfer", new SVGFeComponentTransferElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feComposite", new SVGFeCompositeElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feConvolveMatrix", new SVGFeConvolveMatrixElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feDiffuseLighting", new SVGFeDiffuseLightingElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feDisplacementMap", new SVGFeDisplacementMapElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feFlood", new SVGFeFloodElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feGaussianBlur", new SVGFeGaussianBlurElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feImage", new SVGFeImageElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feMerge", new SVGFeMergeElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feMorphology", new SVGFeMorphologyElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feOffset", new SVGFeOffsetElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feSpecularLighting", new SVGFeSpecularLightingElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feTile", new SVGFeTileElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "feTurbulence", new SVGFeTurbulenceElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "filter", new SVGFilterElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "g", new SVGGElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "image", new SVGImageElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "line", new SVGLineElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "linearGradient", new SVGLinearGradientBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "marker", new SVGMarkerElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "mask", new SVGMaskElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "path", new SVGPathElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "pattern", new SVGPatternElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "polyline", new SVGPolylineElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "polygon", new SVGPolygonElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "radialGradient", new SVGRadialGradientBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "rect", new SVGRectElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "svg", new SVGSVGElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "switch", new SVGSwitchElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "text", new SVGTextElementBridge());
        bridgeContext.putBridge("http://www.w3.org/2000/svg", "use", new SVGUseElementBridge());
    }

    public static void registerGlobalBridge(String string, String string2, Bridge bridge) {
        HashMap<String, Bridge> hashMap;
        if (globalBridges == null) {
            globalBridges = new HashMap(11);
        }
        if ((hashMap = (HashMap<String, Bridge>)globalBridges.get(string)) == null) {
            hashMap = new HashMap<String, Bridge>(11);
            globalBridges.put(string, hashMap);
        }
        hashMap.put(string2, bridge);
    }

    public BridgeUpdateManager getBridgeUpdateManager() {
        return this.updateManager;
    }

    public GraphicsNodeRableFactory getGraphicsNodeRableFactory() {
        return this.graphicsNodeRableFactory;
    }

    public void setGraphicsNodeRableFactory(GraphicsNodeRableFactory graphicsNodeRableFactory) {
        this.graphicsNodeRableFactory = graphicsNodeRableFactory;
    }
}

