/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.test.BaseTestCase;

public class MultiLoaderTestCase
extends BaseTestCase {
    private static final String TMPL_FILE_EXT = "vm";
    private static final String CMP_FILE_EXT = "cmp";
    private static final String RESULT_FILE_EXT = "res";
    private static final String RESULTS_DIR = "../test/multiloader/results";
    private static final String FILE_RESOURCE_LOADER_PATH = "../test/multiloader";
    private static final String COMPARE_DIR = "../test/multiloader/compare";

    public MultiLoaderTestCase() {
        super("MultiLoaderTestCase");
        try {
            BaseTestCase.assureResultsDirectoryExists(RESULTS_DIR);
            Velocity.setProperty("resource.loader", "file");
            Velocity.setProperty("file.resource.loader.path", FILE_RESOURCE_LOADER_PATH);
            Velocity.addProperty("resource.loader", "classpath");
            Velocity.setProperty("classpath.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.setProperty("classpath.resource.loader.cache", "false");
            Velocity.setProperty("classpath.resource.loader.modificationCheckInterval", "2");
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup MultiLoaderTestCase!");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Test suite() {
        return new MultiLoaderTestCase();
    }

    public void runTest() {
        try {
            BaseTestCase.assureResultsDirectoryExists(RESULTS_DIR);
            Template template1 = Runtime.getTemplate(BaseTestCase.getFileName(null, "path1", TMPL_FILE_EXT));
            Template template2 = Runtime.getTemplate(BaseTestCase.getFileName(null, "template/test1", TMPL_FILE_EXT));
            FileOutputStream fos1 = new FileOutputStream(BaseTestCase.getFileName(RESULTS_DIR, "path1", RESULT_FILE_EXT));
            FileOutputStream fos2 = new FileOutputStream(BaseTestCase.getFileName(RESULTS_DIR, "test2", RESULT_FILE_EXT));
            BufferedWriter writer1 = new BufferedWriter(new OutputStreamWriter(fos1));
            BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(fos2));
            VelocityContext context = new VelocityContext();
            template1.merge(context, writer1);
            ((Writer)writer1).flush();
            ((Writer)writer1).close();
            template2.merge(context, writer2);
            ((Writer)writer2).flush();
            ((Writer)writer2).close();
            if (!this.isMatch(RESULTS_DIR, COMPARE_DIR, "path1", RESULT_FILE_EXT, CMP_FILE_EXT) || !this.isMatch(RESULTS_DIR, COMPARE_DIR, "test1", RESULT_FILE_EXT, CMP_FILE_EXT)) {
                Assert.fail((String)"Output is incorrect!");
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

