/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.utils.Hash2intTable;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.CMAny;
import org.apache.xerces.validators.common.CMBinOp;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMLeaf;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMUniOp;
import org.apache.xerces.validators.common.DFAContentModel;
import org.apache.xerces.validators.common.MixedContentModel;
import org.apache.xerces.validators.common.SimpleContentModel;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.w3c.dom.Document;

public class Grammar
implements XMLContentSpec.Provider {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final int LIST_FLAG = 32768;
    private static final int LIST_MASK = -32769;
    private int fTargetNamespace;
    private Document fGrammarDocument;
    private int fElementDeclCount = 0;
    private QName[][] fElementDeclName = new QName[4][];
    private int[][] fElementDeclType = new int[4][];
    private DatatypeValidator[][] fElementDeclDatatypeValidator = new DatatypeValidator[4][];
    private int[][] fElementDeclContentSpecIndex = new int[4][];
    private XMLContentModel[][] fElementDeclContentModelValidator = new XMLContentModel[4][];
    private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
    private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
    private Vector[][] fElementDeclUnique = new Vector[4][];
    private Vector[][] fElementDeclKey = new Vector[4][];
    private Vector[][] fElementDeclKeyRef = new Vector[4][];
    private int fContentSpecCount = 0;
    private int[][] fContentSpecType = new int[4][];
    private int[][] fContentSpecValue = new int[4][];
    private int[][] fContentSpecOtherValue = new int[4][];
    private int fAttributeDeclCount = 0;
    private QName[][] fAttributeDeclName = new QName[4][];
    private int[][] fAttributeDeclType = new int[4][];
    private int[][] fAttributeDeclEnumeration = new int[4][];
    private int[][] fAttributeDeclDefaultType = new int[4][];
    private DatatypeValidator[][] fAttributeDeclDatatypeValidator = new DatatypeValidator[4][];
    private String[][] fAttributeDeclDefaultValue = new String[4][];
    private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
    private Hash2intTable fElementNameAndScopeToElementDeclIndexMapping = new Hash2intTable();
    private QName fQName1 = new QName();
    private QName fQName2 = new QName();
    private int fLeafCount = 0;
    private int fEpsilonIndex = -1;

    private final CMNode buildSyntaxTree(int n, XMLContentSpec xMLContentSpec) throws CMException {
        CMNode cMNode = null;
        this.getContentSpec(n, xMLContentSpec);
        if ((xMLContentSpec.type & 0xF) == 6) {
            cMNode = new CMAny(xMLContentSpec.type, xMLContentSpec.otherValue, this.fLeafCount++);
        } else if ((xMLContentSpec.type & 0xF) == 7) {
            cMNode = new CMAny(xMLContentSpec.type, xMLContentSpec.otherValue, this.fLeafCount++);
        } else if ((xMLContentSpec.type & 0xF) == 8) {
            cMNode = new CMAny(xMLContentSpec.type, -1, this.fLeafCount++);
        } else if (xMLContentSpec.type == 0) {
            this.fQName1.setValues(-1, xMLContentSpec.value, xMLContentSpec.value, xMLContentSpec.otherValue);
            cMNode = new CMLeaf(this.fQName1, this.fLeafCount++);
        } else {
            int n2 = xMLContentSpec.value;
            int n3 = xMLContentSpec.otherValue;
            if (xMLContentSpec.type == 4 || xMLContentSpec.type == 5) {
                cMNode = new CMBinOp(xMLContentSpec.type, this.buildSyntaxTree(n2, xMLContentSpec), this.buildSyntaxTree(n3, xMLContentSpec));
            } else if (xMLContentSpec.type == 2 || xMLContentSpec.type == 1 || xMLContentSpec.type == 3) {
                cMNode = new CMUniOp(xMLContentSpec.type, this.buildSyntaxTree(n2, xMLContentSpec));
            } else {
                throw new CMException(8);
            }
        }
        return cMNode;
    }

    private void contentSpecTree(int n, XMLContentSpec xMLContentSpec, ChildrenList childrenList) throws CMException {
        this.getContentSpec(n, xMLContentSpec);
        if (xMLContentSpec.type == 0 || (xMLContentSpec.type & 0xF) == 6 || (xMLContentSpec.type & 0xF) == 8 || (xMLContentSpec.type & 0xF) == 7) {
            if (childrenList.length == childrenList.qname.length) {
                QName[] qNameArray = new QName[childrenList.length * 2];
                System.arraycopy(childrenList.qname, 0, qNameArray, 0, childrenList.length);
                childrenList.qname = qNameArray;
                int[] nArray = new int[childrenList.length * 2];
                System.arraycopy(childrenList.type, 0, nArray, 0, childrenList.length);
                childrenList.type = nArray;
            }
            childrenList.qname[childrenList.length] = new QName(-1, xMLContentSpec.value, xMLContentSpec.value, xMLContentSpec.otherValue);
            childrenList.type[childrenList.length] = xMLContentSpec.type;
            ++childrenList.length;
            return;
        }
        int n2 = xMLContentSpec.value;
        int n3 = xMLContentSpec.otherValue;
        if (xMLContentSpec.type == 4 || xMLContentSpec.type == 5) {
            this.contentSpecTree(n2, xMLContentSpec, childrenList);
            this.contentSpecTree(n3, xMLContentSpec, childrenList);
            return;
        }
        if (xMLContentSpec.type == 1 || xMLContentSpec.type == 2 || xMLContentSpec.type == 3) {
            this.contentSpecTree(n2, xMLContentSpec, childrenList);
            return;
        }
        throw new CMException(8);
    }

    private int countLeaves(int n) {
        return this.countLeaves(n, new XMLContentSpec());
    }

    private int countLeaves(int n, XMLContentSpec xMLContentSpec) {
        if (n == -1) {
            return 0;
        }
        this.getContentSpec(n, xMLContentSpec);
        if (xMLContentSpec.type == 0) {
            return 1;
        }
        int n2 = xMLContentSpec.value;
        int n3 = xMLContentSpec.otherValue;
        return this.countLeaves(n2, xMLContentSpec) + this.countLeaves(n3, xMLContentSpec);
    }

    protected int createAttributeDecl() {
        int n = this.fAttributeDeclCount >> 8;
        int n2 = this.fAttributeDeclCount & 0xFF;
        this.ensureAttributeDeclCapacity(n);
        this.fAttributeDeclName[n][n2] = new QName();
        this.fAttributeDeclType[n][n2] = -1;
        this.fAttributeDeclDatatypeValidator[n][n2] = null;
        this.fAttributeDeclEnumeration[n][n2] = -1;
        this.fAttributeDeclDefaultType[n][n2] = 0;
        this.fAttributeDeclDefaultValue[n][n2] = null;
        this.fAttributeDeclNextAttributeDeclIndex[n][n2] = -1;
        return this.fAttributeDeclCount++;
    }

    private final XMLContentModel createChildModel(int n) throws CMException {
        Object object;
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        this.getContentSpec(n, xMLContentSpec);
        if ((xMLContentSpec.type & 0xF) != 6 && (xMLContentSpec.type & 0xF) != 7 && (xMLContentSpec.type & 0xF) != 8) {
            if (xMLContentSpec.type == 0) {
                if (xMLContentSpec.value == -1 && xMLContentSpec.otherValue == -1) {
                    throw new CMException(11);
                }
                this.fQName1.setValues(-1, xMLContentSpec.value, xMLContentSpec.value, xMLContentSpec.otherValue);
                return new SimpleContentModel(this.fQName1, null, xMLContentSpec.type, this.isDTD());
            }
            if (xMLContentSpec.type == 4 || xMLContentSpec.type == 5) {
                object = new XMLContentSpec();
                XMLContentSpec xMLContentSpec2 = new XMLContentSpec();
                this.getContentSpec(xMLContentSpec.value, (XMLContentSpec)object);
                this.getContentSpec(xMLContentSpec.otherValue, xMLContentSpec2);
                if (((XMLContentSpec)object).type == 0 && xMLContentSpec2.type == 0) {
                    this.fQName1.setValues(-1, ((XMLContentSpec)object).value, ((XMLContentSpec)object).value, ((XMLContentSpec)object).otherValue);
                    this.fQName2.setValues(-1, xMLContentSpec2.value, xMLContentSpec2.value, xMLContentSpec2.otherValue);
                    return new SimpleContentModel(this.fQName1, this.fQName2, xMLContentSpec.type, this.isDTD());
                }
            } else if (xMLContentSpec.type == 1 || xMLContentSpec.type == 2 || xMLContentSpec.type == 3) {
                object = new XMLContentSpec();
                this.getContentSpec(xMLContentSpec.value, (XMLContentSpec)object);
                if (((XMLContentSpec)object).type == 0) {
                    this.fQName1.setValues(-1, ((XMLContentSpec)object).value, ((XMLContentSpec)object).value, ((XMLContentSpec)object).otherValue);
                    return new SimpleContentModel(this.fQName1, null, xMLContentSpec.type, this.isDTD());
                }
            } else {
                throw new CMException(8);
            }
        }
        this.fLeafCount = 0;
        object = this.buildSyntaxTree(n, xMLContentSpec);
        return new DFAContentModel((CMNode)object, this.fLeafCount, this.isDTD());
    }

    protected int createContentSpec() {
        int n = this.fContentSpecCount >> 8;
        int n2 = this.fContentSpecCount & 0xFF;
        this.ensureContentSpecCapacity(n);
        this.fContentSpecType[n][n2] = -1;
        this.fContentSpecValue[n][n2] = -1;
        this.fContentSpecOtherValue[n][n2] = -1;
        return this.fContentSpecCount++;
    }

    protected int createElementDecl() {
        int n = this.fElementDeclCount >> 8;
        int n2 = this.fElementDeclCount & 0xFF;
        this.ensureElementDeclCapacity(n);
        this.fElementDeclName[n][n2] = new QName();
        this.fElementDeclType[n][n2] = -1;
        this.fElementDeclDatatypeValidator[n][n2] = null;
        this.fElementDeclContentSpecIndex[n][n2] = -1;
        this.fElementDeclContentModelValidator[n][n2] = null;
        this.fElementDeclFirstAttributeDeclIndex[n][n2] = -1;
        this.fElementDeclLastAttributeDeclIndex[n][n2] = -1;
        return this.fElementDeclCount++;
    }

    private boolean ensureAttributeDeclCapacity(int n) {
        try {
            return this.fAttributeDeclName[n][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fAttributeDeclName = this.resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
            this.fAttributeDeclType = this.resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
            this.fAttributeDeclEnumeration = this.resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
            this.fAttributeDeclDefaultType = this.resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
            this.fAttributeDeclDatatypeValidator = this.resize(this.fAttributeDeclDatatypeValidator, this.fAttributeDeclDatatypeValidator.length * 2);
            this.fAttributeDeclDefaultValue = this.resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
            this.fAttributeDeclNextAttributeDeclIndex = this.resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
        }
        catch (NullPointerException nullPointerException) {}
        this.fAttributeDeclName[n] = new QName[256];
        this.fAttributeDeclType[n] = new int[256];
        this.fAttributeDeclEnumeration[n] = new int[256];
        this.fAttributeDeclDefaultType[n] = new int[256];
        this.fAttributeDeclDatatypeValidator[n] = new DatatypeValidator[256];
        this.fAttributeDeclDefaultValue[n] = new String[256];
        this.fAttributeDeclNextAttributeDeclIndex[n] = new int[256];
        return true;
    }

    private boolean ensureContentSpecCapacity(int n) {
        try {
            return this.fContentSpecType[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fContentSpecType = this.resize(this.fContentSpecType, this.fContentSpecType.length * 2);
            this.fContentSpecValue = this.resize(this.fContentSpecValue, this.fContentSpecValue.length * 2);
            this.fContentSpecOtherValue = this.resize(this.fContentSpecOtherValue, this.fContentSpecOtherValue.length * 2);
        }
        catch (NullPointerException nullPointerException) {}
        this.fContentSpecType[n] = new int[256];
        this.fContentSpecValue[n] = new int[256];
        this.fContentSpecOtherValue[n] = new int[256];
        return true;
    }

    private boolean ensureElementDeclCapacity(int n) {
        try {
            return this.fElementDeclName[n][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fElementDeclName = this.resize(this.fElementDeclName, this.fElementDeclName.length * 2);
            this.fElementDeclType = this.resize(this.fElementDeclType, this.fElementDeclType.length * 2);
            this.fElementDeclDatatypeValidator = this.resize(this.fElementDeclDatatypeValidator, this.fElementDeclDatatypeValidator.length * 2);
            this.fElementDeclContentSpecIndex = this.resize(this.fElementDeclContentSpecIndex, this.fElementDeclContentSpecIndex.length * 2);
            this.fElementDeclContentModelValidator = this.resize(this.fElementDeclContentModelValidator, this.fElementDeclContentModelValidator.length * 2);
            this.fElementDeclFirstAttributeDeclIndex = this.resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
            this.fElementDeclLastAttributeDeclIndex = this.resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
            this.fElementDeclUnique = this.resize(this.fElementDeclUnique, this.fElementDeclUnique.length * 2);
            this.fElementDeclKey = this.resize(this.fElementDeclKey, this.fElementDeclKey.length * 2);
            this.fElementDeclKeyRef = this.resize(this.fElementDeclKeyRef, this.fElementDeclKeyRef.length * 2);
        }
        catch (NullPointerException nullPointerException) {}
        this.fElementDeclName[n] = new QName[256];
        this.fElementDeclType[n] = new int[256];
        this.fElementDeclDatatypeValidator[n] = new DatatypeValidator[256];
        this.fElementDeclContentSpecIndex[n] = new int[256];
        this.fElementDeclContentModelValidator[n] = new XMLContentModel[256];
        this.fElementDeclFirstAttributeDeclIndex[n] = new int[256];
        this.fElementDeclLastAttributeDeclIndex[n] = new int[256];
        this.fElementDeclUnique[n] = new Vector[256];
        this.fElementDeclKey[n] = new Vector[256];
        this.fElementDeclKeyRef[n] = new Vector[256];
        return true;
    }

    public boolean getAttributeDecl(int n, XMLAttributeDecl xMLAttributeDecl) {
        if (n < 0 || n >= this.fAttributeDeclCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLAttributeDecl.name.setValues(this.fAttributeDeclName[n2][n3]);
        if (this.fAttributeDeclType[n2][n3] == -1) {
            xMLAttributeDecl.type = -1;
            xMLAttributeDecl.list = false;
        } else {
            xMLAttributeDecl.type = this.fAttributeDeclType[n2][n3] & 0xFFFF7FFF;
            xMLAttributeDecl.list = (this.fAttributeDeclType[n2][n3] & 0x8000) != 0;
        }
        xMLAttributeDecl.datatypeValidator = this.fAttributeDeclDatatypeValidator[n2][n3];
        xMLAttributeDecl.enumeration = this.fAttributeDeclEnumeration[n2][n3];
        xMLAttributeDecl.defaultType = this.fAttributeDeclDefaultType[n2][n3];
        xMLAttributeDecl.defaultValue = this.fAttributeDeclDefaultValue[n2][n3];
        return true;
    }

    public boolean getContentSpec(int n, XMLContentSpec xMLContentSpec) {
        if (n < 0 || n >= this.fContentSpecCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLContentSpec.type = this.fContentSpecType[n2][n3];
        xMLContentSpec.value = this.fContentSpecValue[n2][n3];
        xMLContentSpec.otherValue = this.fContentSpecOtherValue[n2][n3];
        return true;
    }

    public XMLContentModel getElementContentModel(int n) throws CMException {
        if (n < 0 || n >= this.fElementDeclCount) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        XMLContentModel xMLContentModel = this.fElementDeclContentModelValidator[n2][n3];
        if (xMLContentModel != null) {
            return xMLContentModel;
        }
        int n4 = this.fElementDeclType[n2][n3];
        if (n4 == 4) {
            return null;
        }
        int n5 = this.fElementDeclContentSpecIndex[n2][n3];
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        this.getContentSpec(n5, xMLContentSpec);
        if (n4 == 2) {
            Vector vector = new Vector();
            try {
                ChildrenList childrenList = new ChildrenList();
                this.contentSpecTree(n5, xMLContentSpec, childrenList);
                xMLContentModel = new MixedContentModel(childrenList.qname, childrenList.type, 0, childrenList.length, false, this.isDTD());
            }
            catch (CMException cMException) {
                cMException.printStackTrace();
            }
        } else if (n4 == 3) {
            try {
                xMLContentModel = this.createChildModel(n5);
            }
            catch (CMException cMException) {
                cMException.printStackTrace();
            }
        } else {
            throw new CMException(8);
        }
        this.fElementDeclContentModelValidator[n2][n3] = xMLContentModel;
        return xMLContentModel;
    }

    public boolean getElementDecl(int n, XMLElementDecl xMLElementDecl) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return false;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        xMLElementDecl.name.setValues(this.fElementDeclName[n2][n3]);
        if (this.fElementDeclType[n2][n3] == -1) {
            xMLElementDecl.type = -1;
            xMLElementDecl.list = false;
        } else {
            xMLElementDecl.type = this.fElementDeclType[n2][n3] & 0xFFFF7FFF;
            xMLElementDecl.list = (this.fElementDeclType[n2][n3] & 0x8000) != 0;
        }
        xMLElementDecl.datatypeValidator = this.fElementDeclDatatypeValidator[n2][n3];
        xMLElementDecl.contentSpecIndex = this.fElementDeclContentSpecIndex[n2][n3];
        xMLElementDecl.unique.removeAllElements();
        int n4 = this.fElementDeclUnique[n2][n3] != null ? this.fElementDeclUnique[n2][n3].size() : 0;
        int n5 = 0;
        while (n5 < n4) {
            xMLElementDecl.unique.addElement(this.fElementDeclUnique[n2][n3].elementAt(n5));
            ++n5;
        }
        xMLElementDecl.key.removeAllElements();
        int n6 = this.fElementDeclKey[n2][n3] != null ? this.fElementDeclKey[n2][n3].size() : 0;
        int n7 = 0;
        while (n7 < n6) {
            xMLElementDecl.key.addElement(this.fElementDeclKey[n2][n3].elementAt(n7));
            ++n7;
        }
        xMLElementDecl.keyRef.removeAllElements();
        int n8 = this.fElementDeclKeyRef[n2][n3] != null ? this.fElementDeclKeyRef[n2][n3].size() : 0;
        int n9 = 0;
        while (n9 < n8) {
            xMLElementDecl.keyRef.addElement(this.fElementDeclKeyRef[n2][n3].elementAt(n9));
            ++n9;
        }
        return true;
    }

    public int getElementDeclIndex(int n, int n2) {
        if (n > -1 && n2 > -2) {
            return this.fElementNameAndScopeToElementDeclIndexMapping.get(-1, n, n2);
        }
        return -1;
    }

    public int getElementDeclIndex(int n, int n2, int n3) {
        if (n2 > -1 && n3 > -2) {
            return this.fElementNameAndScopeToElementDeclIndexMapping.get(n, n2, n3);
        }
        return -1;
    }

    public int getElementDeclIndex(QName qName, int n) {
        if (qName.localpart > -1 && n > -2) {
            return this.fElementNameAndScopeToElementDeclIndexMapping.get(qName.uri, qName.localpart, n);
        }
        return -1;
    }

    public int getFirstAttributeDeclIndex(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclFirstAttributeDeclIndex[n2][n3];
    }

    public Document getGrammarDocument() {
        return this.fGrammarDocument;
    }

    public int getNextAttributeDeclIndex(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fAttributeDeclNextAttributeDeclIndex[n2][n3];
    }

    protected boolean isDTD() {
        return false;
    }

    private void printAttribute(int n) {
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        if (this.getAttributeDecl(n, xMLAttributeDecl)) {
            System.out.print(" { ");
            System.out.print(xMLAttributeDecl.name.localpart);
            System.out.print(" }");
        }
    }

    public void printAttributes(int n) {
        int n2 = this.getFirstAttributeDeclIndex(n);
        System.out.print(n);
        System.out.print(" [");
        while (n2 != -1) {
            System.out.print(' ');
            System.out.print(n2);
            this.printAttribute(n2);
            n2 = this.getNextAttributeDeclIndex(n2);
            if (n2 == -1) continue;
            System.out.print(",");
        }
        System.out.println(" ]");
    }

    public void printElements(StringPool stringPool) {
        int n = 0;
        XMLElementDecl xMLElementDecl = new XMLElementDecl();
        while (this.getElementDecl(n++, xMLElementDecl)) {
            System.out.println("element decl: " + xMLElementDecl.name + ", " + stringPool.toString(xMLElementDecl.name.rawname) + ", " + XMLContentSpec.toString(this, stringPool, xMLElementDecl.contentSpecIndex));
        }
    }

    private void printSyntaxTree(CMNode cMNode) {
        System.out.println("CMNode : " + cMNode.type());
        if (cMNode.type() == 0) {
            System.out.println("     Leaf: " + ((CMLeaf)cMNode).getElement());
            return;
        }
        if (cMNode instanceof CMBinOp) {
            this.printSyntaxTree(((CMBinOp)cMNode).getLeft());
            this.printSyntaxTree(((CMBinOp)cMNode).getRight());
        }
        if (cMNode instanceof CMUniOp) {
            this.printSyntaxTree(((CMUniOp)cMNode).getChild());
        }
    }

    protected void putElementNameMapping(QName qName, int n, int n2) {
        this.fElementNameAndScopeToElementDeclIndexMapping.put(qName.uri, qName.localpart, n, n2);
    }

    private int[][] resize(int[][] nArray, int n) {
        int[][] nArray2 = new int[n][];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private String[][] resize(String[][] stringArray, int n) {
        String[][] stringArray2 = new String[n][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private Vector[][] resize(Vector[][] vectorArray, int n) {
        Vector[][] vectorArray2 = new Vector[n][];
        System.arraycopy(vectorArray, 0, vectorArray2, 0, vectorArray.length);
        return vectorArray2;
    }

    private QName[][] resize(QName[][] qNameArray, int n) {
        QName[][] qNameArray2 = new QName[n][];
        System.arraycopy(qNameArray, 0, qNameArray2, 0, qNameArray.length);
        return qNameArray2;
    }

    private XMLContentModel[][] resize(XMLContentModel[][] xMLContentModelArray, int n) {
        XMLContentModel[][] xMLContentModelArray2 = new XMLContentModel[n][];
        System.arraycopy(xMLContentModelArray, 0, xMLContentModelArray2, 0, xMLContentModelArray.length);
        return xMLContentModelArray2;
    }

    private DatatypeValidator[][] resize(DatatypeValidator[][] datatypeValidatorArray, int n) {
        DatatypeValidator[][] datatypeValidatorArray2 = new DatatypeValidator[n][];
        System.arraycopy(datatypeValidatorArray, 0, datatypeValidatorArray2, 0, datatypeValidatorArray.length);
        return datatypeValidatorArray2;
    }

    protected void setAttributeDecl(int n, int n2, XMLAttributeDecl xMLAttributeDecl) {
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        this.fAttributeDeclName[n3][n4].setValues(xMLAttributeDecl.name);
        this.fAttributeDeclType[n3][n4] = xMLAttributeDecl.type;
        if (xMLAttributeDecl.list) {
            int[] nArray = this.fAttributeDeclType[n3];
            int n5 = n4;
            nArray[n5] = nArray[n5] | 0x8000;
        }
        this.fAttributeDeclEnumeration[n3][n4] = xMLAttributeDecl.enumeration;
        this.fAttributeDeclDefaultType[n3][n4] = xMLAttributeDecl.defaultType;
        this.fAttributeDeclDatatypeValidator[n3][n4] = xMLAttributeDecl.datatypeValidator;
        this.fAttributeDeclDefaultValue[n3][n4] = xMLAttributeDecl.defaultValue;
        int n6 = n >> 8;
        int n7 = n & 0xFF;
        int n8 = this.fElementDeclFirstAttributeDeclIndex[n6][n7];
        while (n8 != -1) {
            if (n8 == n2) break;
            n3 = n8 >> 8;
            n4 = n8 & 0xFF;
            n8 = this.fAttributeDeclNextAttributeDeclIndex[n3][n4];
        }
        if (n8 == -1) {
            if (this.fElementDeclFirstAttributeDeclIndex[n6][n7] == -1) {
                this.fElementDeclFirstAttributeDeclIndex[n6][n7] = n2;
            } else {
                n8 = this.fElementDeclLastAttributeDeclIndex[n6][n7];
                n3 = n8 >> 8;
                n4 = n8 & 0xFF;
                this.fAttributeDeclNextAttributeDeclIndex[n3][n4] = n2;
            }
            this.fElementDeclLastAttributeDeclIndex[n6][n7] = n2;
        }
    }

    protected void setContentSpec(int n, XMLContentSpec xMLContentSpec) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.fContentSpecType[n2][n3] = xMLContentSpec.type;
        this.fContentSpecValue[n2][n3] = xMLContentSpec.value;
        this.fContentSpecOtherValue[n2][n3] = xMLContentSpec.otherValue;
    }

    protected void setElementDecl(int n, XMLElementDecl xMLElementDecl) {
        int n2;
        int n3;
        if (n < 0 || n >= this.fElementDeclCount) {
            return;
        }
        int n4 = n >> 8;
        int n5 = n & 0xFF;
        this.fElementDeclName[n4][n5].setValues(xMLElementDecl.name);
        this.fElementDeclType[n4][n5] = xMLElementDecl.type;
        if (xMLElementDecl.list) {
            int[] nArray = this.fElementDeclType[n4];
            int n6 = n5;
            nArray[n6] = nArray[n6] | 0x8000;
        }
        this.fElementDeclDatatypeValidator[n4][n5] = xMLElementDecl.datatypeValidator;
        this.fElementDeclContentSpecIndex[n4][n5] = xMLElementDecl.contentSpecIndex;
        int n7 = xMLElementDecl.unique.size();
        if (n7 > 0) {
            if (this.fElementDeclUnique[n4][n5] == null) {
                this.fElementDeclUnique[n4][n5] = (Vector)xMLElementDecl.unique.clone();
            } else {
                this.fElementDeclUnique[n4][n5].removeAllElements();
                n3 = 0;
                while (n3 < n7) {
                    this.fElementDeclUnique[n4][n5].addElement(xMLElementDecl.unique.elementAt(n3));
                    ++n3;
                }
            }
        }
        if ((n3 = xMLElementDecl.key.size()) > 0) {
            if (this.fElementDeclKey[n4][n5] == null) {
                this.fElementDeclKey[n4][n5] = (Vector)xMLElementDecl.key.clone();
            } else {
                this.fElementDeclKey[n4][n5].removeAllElements();
                n2 = 0;
                while (n2 < n3) {
                    this.fElementDeclKey[n4][n5].addElement(xMLElementDecl.key.elementAt(n2));
                    ++n2;
                }
            }
        }
        if ((n2 = xMLElementDecl.keyRef.size()) > 0) {
            if (this.fElementDeclKeyRef[n4][n5] == null) {
                this.fElementDeclKeyRef[n4][n5] = (Vector)xMLElementDecl.keyRef.clone();
            } else {
                this.fElementDeclKeyRef[n4][n5].removeAllElements();
                int n8 = 0;
                while (n8 < n2) {
                    this.fElementDeclKeyRef[n4][n5].addElement(xMLElementDecl.keyRef.elementAt(n8));
                    ++n8;
                }
            }
        }
        this.putElementNameMapping(xMLElementDecl.name, xMLElementDecl.enclosingScope, n);
    }

    protected void setFirstAttributeDeclIndex(int n, int n2) {
        if (n < 0 || n >= this.fElementDeclCount) {
            return;
        }
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.fElementDeclFirstAttributeDeclIndex[n3][n4] = n2;
    }

    protected void setGrammarDocument(Document document) {
        this.fGrammarDocument = document;
    }

    static class ChildrenList {
        public int length = 0;
        public QName[] qname = new QName[2];
        public int[] type = new int[2];

        ChildrenList() {
        }
    }
}

