/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.apache.avalon.util.StringUtil;
import org.apache.excalibur.io.IOUtil;

public final class FileUtil {
    public static File toFile(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        return new File(string);
    }

    public static String removeExtention(String string) {
        int n = string.lastIndexOf(46);
        if (-1 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String removePath(String string) {
        int n = string.lastIndexOf(File.separator);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static void copyFileToDirectory(String string, String string2) throws IOException {
        FileUtil.copyFileToDirectory(new File(string), new File(string2));
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.copyFile(file, new File(file2, file.getName()));
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new IOException("File " + file + " does not exist");
        }
        if (!file2.getParentFile().exists()) {
            file2.mkdirs();
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException("Unable to open file " + file2 + " for writing.");
        }
        IOUtil.copy(new FileInputStream(file), new FileOutputStream(file2));
        if (file.length() != file2.length()) {
            throw new IOException("Failed to copy full contents from " + file + " to " + file2);
        }
    }

    public static void copyURLToFile(URL uRL, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.mkdirs();
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Unable to open file " + file + " for writing.");
        }
        IOUtil.copy(uRL.openStream(), new FileOutputStream(file));
    }

    public static String normalize(String string) {
        string = StringUtil.replaceSubString(string, "/./", "/");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf("/../");
        int n3 = 0;
        while (n2 != -1) {
            n = string.lastIndexOf("/", n2 - 1);
            stringBuffer.append(string.substring(n3, n));
            stringBuffer.append('/');
            n3 = n2 + 4;
            n2 = string.indexOf("/../", n3);
        }
        n2 = string.length();
        stringBuffer.append(string.substring(n3, n2));
        return stringBuffer.toString();
    }

    public static String catPath(String string, String string2) {
        int n = string.lastIndexOf("/");
        string = string.substring(0, n);
        while (string2.startsWith("../")) {
            if (string.length() <= 0) {
                return null;
            }
            n = string.lastIndexOf("/");
            string = string.substring(0, n);
            n = string2.indexOf("../") + 3;
            string2 = string2.substring(n);
        }
        return string + "/" + string2;
    }

    public static File resolveFile(File file, String string) {
        if ('/' != File.separatorChar) {
            string = string.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            string = string.replace('\\', File.separatorChar);
        }
        if (string.startsWith(File.separator)) {
            File file2 = new File(string);
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file2;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if ('\\' == File.separatorChar) {
            stringBuffer.append(string.charAt(0));
            ++n;
        }
        int n2 = n;
        while (n2 < cArray.length) {
            boolean bl;
            boolean bl2 = bl = File.separatorChar == cArray[n2] && File.separatorChar == cArray[n2 - 1];
            if (!bl) {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        string = stringBuffer.toString();
        File file3 = new File(file, string).getAbsoluteFile();
        try {
            file3 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file3;
    }

    public static void forceDelete(String string) throws IOException {
        FileUtil.forceDelete(new File(string));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            throw new IOException("File " + file + " unable to be deleted.");
        }
    }

    public static void deleteDirectory(String string) throws IOException {
        FileUtil.deleteDirectory(new File(string));
    }

    public static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtil.cleanDirectory(file);
        if (!file.delete()) {
            throw new IOException("Directory " + file + " unable to be deleted.");
        }
    }

    public static void cleanDirectory(String string) throws IOException {
        FileUtil.cleanDirectory(new File(string));
    }

    public static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isFile()) {
                file2.delete();
            } else if (file2.isDirectory()) {
                FileUtil.cleanDirectory(file2);
                if (!file2.delete()) {
                    throw new IOException("Directory " + file2 + " unable to be deleted.");
                }
            }
            ++n;
        }
    }

    private FileUtil() {
    }
}

