/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.configuration.Configuration;
import org.apache.avalon.configuration.ConfigurationException;
import org.apache.excalibur.datasource.DataSourceComponent;
import org.apache.excalibur.datasource.JdbcConnectionPool;

public class JdbcDataSource
extends AbstractLoggable
implements DataSourceComponent {
    protected JdbcConnectionPool m_pool;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_pool == null) {
            String string = configuration.getChild("dburl").getValue();
            String string2 = configuration.getChild("user").getValue(null);
            String string3 = configuration.getChild("password").getValue(null);
            Configuration configuration2 = configuration.getChild("pool-controller");
            int n = configuration2.getAttributeAsInt("max", 3);
            boolean bl = configuration.getChild("auto-commit").getValueAsBoolean(true);
            this.m_pool = new JdbcConnectionPool(string, string2, string3, n, bl);
            this.m_pool.setLogger(this.getLogger());
            this.m_pool.init();
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)((Object)this.m_pool.get());
        }
        catch (Exception exception) {
            this.getLogger().error("Could not return Connection", (Throwable)exception);
            throw new SQLException(exception.getMessage());
        }
    }

    public void dispose() {
        this.m_pool.dispose();
        this.m_pool = null;
    }
}

