/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.configuration;

import org.apache.avalon.configuration.Configuration;
import org.apache.avalon.configuration.ConfigurationException;
import org.apache.avalon.configuration.DefaultConfiguration;

public abstract class AbstractConfiguration
implements Configuration {
    public int getValueAsInt() throws ConfigurationException {
        String string = this.getValue();
        try {
            if (string.startsWith("0x")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.startsWith("0o")) {
                return Integer.parseInt(string.substring(2), 8);
            }
            if (string.startsWith("0b")) {
                return Integer.parseInt(string.substring(2), 2);
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as an integer");
        }
    }

    public int getValueAsInt(int n) {
        try {
            return this.getValueAsInt();
        }
        catch (ConfigurationException configurationException) {
            return n;
        }
    }

    public long getValueAsLong() throws ConfigurationException {
        String string = this.getValue();
        try {
            if (string.startsWith("0x")) {
                return Long.parseLong(string.substring(2), 16);
            }
            if (string.startsWith("0o")) {
                return Long.parseLong(string.substring(2), 8);
            }
            if (string.startsWith("0b")) {
                return Long.parseLong(string.substring(2), 2);
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a long");
        }
    }

    public long getValueAsLong(long l) {
        try {
            return this.getValueAsLong();
        }
        catch (ConfigurationException configurationException) {
            return l;
        }
    }

    public float getValueAsFloat() throws ConfigurationException {
        String string = this.getValue();
        try {
            return Float.parseFloat(string);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a float");
        }
    }

    public float getValueAsFloat(float f) {
        try {
            return this.getValueAsFloat();
        }
        catch (ConfigurationException configurationException) {
            return f;
        }
    }

    public boolean getValueAsBoolean() throws ConfigurationException {
        String string = this.getValue();
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a boolean");
    }

    public boolean getValueAsBoolean(boolean bl) {
        try {
            return this.getValueAsBoolean();
        }
        catch (ConfigurationException configurationException) {
            return bl;
        }
    }

    public String getValue(String string) {
        try {
            return this.getValue();
        }
        catch (ConfigurationException configurationException) {
            return string;
        }
    }

    public int getAttributeAsInt(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        try {
            if (string2.startsWith("0x")) {
                return Integer.parseInt(string2.substring(2), 16);
            }
            if (string2.startsWith("0o")) {
                return Integer.parseInt(string2.substring(2), 8);
            }
            if (string2.startsWith("0b")) {
                return Integer.parseInt(string2.substring(2), 2);
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + string + "\" of the configuration element \"" + this.getName() + "\" as an integer");
        }
    }

    public int getAttributeAsInt(String string, int n) {
        try {
            return this.getAttributeAsInt(string);
        }
        catch (ConfigurationException configurationException) {
            return n;
        }
    }

    public long getAttributeAsLong(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        try {
            if (string2.startsWith("0x")) {
                return Long.parseLong(string2.substring(2), 16);
            }
            if (string2.startsWith("0o")) {
                return Long.parseLong(string2.substring(2), 8);
            }
            if (string2.startsWith("0b")) {
                return Long.parseLong(string2.substring(2), 2);
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + string + "\" of the configuration element \"" + this.getName() + "\" as a long");
        }
    }

    public long getAttributeAsLong(String string, long l) {
        try {
            return this.getAttributeAsLong(string);
        }
        catch (ConfigurationException configurationException) {
            return l;
        }
    }

    public float getAttributeAsFloat(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        try {
            return Float.parseFloat(string2);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + string + "\" of the configuration element \"" + this.getName() + "\" as a float");
        }
    }

    public float getAttributeAsFloat(String string, float f) {
        try {
            return this.getAttributeAsFloat(string);
        }
        catch (ConfigurationException configurationException) {
            return f;
        }
    }

    public boolean getAttributeAsBoolean(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value of the attribute \"" + string + "\" of the configuration element \"" + this.getName() + "\" as a boolean");
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        try {
            return this.getAttributeAsBoolean(string);
        }
        catch (ConfigurationException configurationException) {
            return bl;
        }
    }

    public String getAttribute(String string, String string2) {
        try {
            return this.getAttribute(string);
        }
        catch (ConfigurationException configurationException) {
            return string2;
        }
    }

    public Configuration getChild(String string) {
        return this.getChild(string, true);
    }

    public Configuration getChild(String string, boolean bl) {
        Configuration[] configurationArray = this.getChildren(string);
        if (configurationArray.length > 0) {
            return configurationArray[0];
        }
        if (bl) {
            return new DefaultConfiguration(string, "-");
        }
        return null;
    }

    public abstract String getName();

    public abstract String getLocation();

    public abstract Configuration[] getChildren();

    public abstract Configuration[] getChildren(String var1);

    public abstract String[] getAttributeNames();

    public abstract String getAttribute(String var1) throws ConfigurationException;

    public abstract String getValue() throws ConfigurationException;
}

