/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import org.apache.turbine.services.resources.TurbineResources;

public class Log {
    private static String lf = System.getProperty("line.separator", "\n");
    private static boolean isValid = true;
    private static FileWriter logfile = null;
    private static Object[][] logfiles;
    private static final String NOTICE = "NOTICE ";
    private static final String WARNING = "WARNING";
    private static final String ERROR = " ERROR ";

    static {
        Log.init();
    }

    public void destroy() {
        try {
            if (logfile != null) {
                logfile.close();
            }
            if (logfiles.length > 0) {
                int i = 0;
                while (i < logfiles.length) {
                    if (logfiles[i][1] != null) {
                        ((FileWriter)logfiles[i][1]).close();
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    public static boolean error(String description) {
        System.out.print("Error=" + description + "\n");
        return Log.log(ERROR, description);
    }

    public static boolean error(String logname, String description) {
        return Log.log(ERROR, logname, description, null);
    }

    public static boolean error(String logname, String description, Throwable t) {
        return Log.log(ERROR, logname, description, t);
    }

    public static boolean error(String description, Throwable t) {
        return Log.log(ERROR, description, t);
    }

    public static boolean error(Throwable t) {
        return Log.log(ERROR, "", t);
    }

    private static void init() {
        try {
            String logFileString = TurbineResources.getString("logfile", null);
            Vector turbineLogs = TurbineResources.getVector("turbine.logs");
            if (logFileString == null && turbineLogs.isEmpty()) {
                throw new Exception("The logfile= property and the turbine.logs= property in the TurbineResources.properties file are null \nor could not be found.  At least one of these properties must be defined in the TurbineResources.properties file. \nPlease make sure that you have properly defined the path to the TurbineResources.properties file\nand you have called \"TurbineResourceService.setPropertiesFileName(\"/path/to/TurbineResources.properties\");\" in your code.\nIf you are using this class with the Turbine Servlet, this should have been called for you already.\nIf you are getting this error using the Turbine Servlet, the path to the properties file or\nthe path to the logfile or the logcount was not defined correctly. Please refer to the INSTALL \ndocument for instructions on how to do this.\n");
            }
            if (logFileString != null) {
                logfile = new FileWriter(logFileString, true);
            }
            if (!turbineLogs.isEmpty()) {
                logfiles = new Object[turbineLogs.size()][2];
                int i = 0;
                while (i < turbineLogs.size()) {
                    if (TurbineResources.getString("turbine.log." + (String)turbineLogs.elementAt(i), null) == null) {
                        throw new Exception("There is an error in the TurbineResources.properties file. \nThe turbine.log." + (String)turbineLogs.get(i) + "= entry could not be found for the \n" + "corresponding turbine.logs=" + (String)turbineLogs.get(i) + " entry. \n" + "Be sure that each turbine.logs= entry has a corresponding turbine.log.[logname]= \n" + "in the TurbineResources.properties file. \n" + "Please refer to the comments in the TurbineResources.properties file \n" + "or the user documentation for more information on how to properly \n" + "implement logging in a Turbine application. \n");
                    }
                    Log.logfiles[i][0] = (String)turbineLogs.get(i);
                    Log.logfiles[i][1] = new FileWriter(TurbineResources.getString("turbine.log." + (String)turbineLogs.get(i), null), true);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isValid = false;
        }
        catch (Throwable throwable) {
            isValid = false;
        }
    }

    private static boolean log(String level, String description) {
        return Log.log(level, description, null);
    }

    private static boolean log(String level, String logname, String description, Throwable t) {
        boolean foundLog = false;
        int i = 0;
        int activeLogNumber = 0;
        i = 0;
        while (i < logfiles.length) {
            if (logfiles[i][0].equals(logname)) {
                activeLogNumber = i;
                foundLog = true;
                break;
            }
            ++i;
        }
        if (foundLog) {
            Date date = new Date();
            StringBuffer logEntry = new StringBuffer();
            logEntry.append("[");
            logEntry.append(date.toString());
            logEntry.append("] -- ");
            logEntry.append(level);
            logEntry.append(" -- ");
            logEntry.append(description);
            logEntry.append(lf);
            if (t != null) {
                ByteArrayOutputStream ostr = new ByteArrayOutputStream();
                PrintWriter out = new PrintWriter(ostr, true);
                out.write(logEntry.toString());
                out.write("\tException:  ");
                out.write(t.toString());
                out.write(String.valueOf(lf) + "\tStack Trace follows:" + lf + "\t");
                t.printStackTrace(out);
                logEntry = new StringBuffer(ostr.toString());
            }
            FileWriter fileWriter = (FileWriter)logfiles[activeLogNumber][1];
            synchronized (fileWriter) {
                try {
                    ((FileWriter)logfiles[activeLogNumber][1]).write(logEntry.toString(), 0, logEntry.length());
                    ((FileWriter)logfiles[activeLogNumber][1]).flush();
                }
                catch (IOException iOException) {
                    boolean bl = false;
                    Object var11_12 = null;
                    return bl;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean log(String level, String description, Throwable t) {
        if (isValid) {
            Date date = new Date();
            StringBuffer logEntry = new StringBuffer();
            logEntry.append("[");
            logEntry.append(date.toString());
            logEntry.append("] -- ");
            logEntry.append(level);
            logEntry.append(" -- ");
            logEntry.append(description);
            logEntry.append(lf);
            if (t != null) {
                ByteArrayOutputStream ostr = new ByteArrayOutputStream();
                PrintWriter out = new PrintWriter(ostr, true);
                out.write(logEntry.toString());
                out.write("\tException:  ");
                out.write(t.toString());
                out.write(String.valueOf(lf) + "\tStack Trace follows:" + lf + "\t");
                t.printStackTrace(out);
                logEntry = new StringBuffer(ostr.toString());
            }
            FileWriter fileWriter = logfile;
            synchronized (fileWriter) {
                try {
                    logfile.write(logEntry.toString(), 0, logEntry.length());
                    logfile.flush();
                }
                catch (IOException iOException) {
                    boolean bl = false;
                    Object var7_8 = null;
                    return bl;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean note(String description) {
        return Log.log(NOTICE, description);
    }

    public static boolean note(String logname, String description) {
        return Log.log(NOTICE, logname, description, null);
    }

    public static boolean warn(String description) {
        return Log.log(WARNING, description);
    }

    public static boolean warn(String logname, String description) {
        return Log.log(WARNING, logname, description, null);
    }
}

