/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library.fp;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.processor.xsp.library.fp.fpError;
import org.apache.cocoon.processor.xsp.library.fp.fpResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class fpLibrary {
    public static Node[] NodeList2Array(NodeList nodes) {
        int len = nodes.getLength();
        Node[] n = new Node[len];
        if (len > 0) {
            int i = 0;
            while (i < len) {
                n[i] = nodes.item(i);
                ++i;
            }
            return n;
        }
        return null;
    }

    protected static void doMarkup(Node node, StringBuffer buffer) {
        switch (node.getNodeType()) {
            case 4: {
                buffer.append("<![CDATA[\n");
                buffer.append(node.getNodeValue());
                buffer.append("]]>\n");
                break;
            }
            case 9: 
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int childCount = nodeList.getLength();
                int i = 0;
                while (i < childCount) {
                    fpLibrary.doMarkup(nodeList.item(i), buffer);
                    ++i;
                }
                break;
            }
            case 1: {
                Element element = (Element)node;
                buffer.append("<" + element.getTagName());
                NamedNodeMap attributes = element.getAttributes();
                int attributeCount = attributes.getLength();
                int i = 0;
                while (i < attributeCount) {
                    Attr attribute = (Attr)attributes.item(i);
                    buffer.append(" ");
                    buffer.append(attribute.getName());
                    buffer.append("=\"");
                    buffer.append(attribute.getValue());
                    buffer.append("\"");
                    ++i;
                }
                NodeList nodeList = element.getChildNodes();
                int childCount = nodeList.getLength();
                if (childCount == 0) {
                    buffer.append("/>\n");
                    break;
                }
                buffer.append(">");
                int i2 = 0;
                while (i2 < childCount) {
                    fpLibrary.doMarkup(nodeList.item(i2), buffer);
                    ++i2;
                }
                buffer.append("</");
                buffer.append(element.getTagName());
                buffer.append(">");
                break;
            }
            case 8: {
                buffer.append("<!-- ");
                buffer.append(node.getNodeValue());
                buffer.append(" -->\n");
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                buffer.append("<?");
                buffer.append(pi.getTarget());
                buffer.append(" ");
                buffer.append(pi.getData());
                buffer.append("?>\n");
                break;
            }
            case 3: {
                buffer.append(node.getNodeValue());
                break;
            }
        }
    }

    public static String getAsMarkup(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer buffer = new StringBuffer();
        NodeList n = node.getChildNodes();
        int childCount = n.getLength();
        int i = 0;
        while (i < childCount) {
            fpLibrary.doMarkup(n.item(i), buffer);
            ++i;
        }
        return buffer.toString();
    }

    public static void getErrors(Node cNode, Hashtable errors) {
        Enumeration e = errors.elements();
        while (e.hasMoreElements()) {
            cNode.appendChild(((fpError)e.nextElement()).getErrorNode(cNode));
        }
    }

    public static void handleFileResource(Node cNode, HttpServletRequest request, ServletContext context, Hashtable resources, Hashtable errors, String key, String file, String xpath, String mode) {
        File f = null;
        try {
            f = new File(XSPUtil.relativeFilename(file, request, context));
        }
        catch (Exception e) {
            fpLibrary.reportError(cNode, cNode, errors, "Resource Error: Could not locate file: " + f.toString() + " : " + e.getMessage());
        }
        fpResource res = new fpResource(cNode, f, xpath, mode, key);
        resources.put(key, res);
    }

    public static Object handleRead(Node cNode, Hashtable resources, Hashtable errors, String select, String key, String type) {
        Object e = null;
        fpResource res = (fpResource)resources.get(key);
        if (res == null) {
            fpLibrary.reportError(cNode, cNode, errors, "Resource not defined: " + key);
            return e;
        }
        e = type.equalsIgnoreCase("node") ? res.readAsNode(cNode, errors, select) : res.readAsString(cNode, errors, select);
        return e;
    }

    public static Object handleWrite(Node cNode, Hashtable resources, Hashtable errors, String select, String key, Object value, String type, String mode) {
        Object e = null;
        fpResource res = (fpResource)resources.get(key);
        if (res == null) {
            fpLibrary.reportError(cNode, cNode, errors, "Resource not defined: " + key);
            return e;
        }
        e = type.equalsIgnoreCase("node".trim()) ? res.writeAsXMLNode(cNode, errors, select, value, mode) : res.writeAsTextNode(cNode, errors, select, value, mode);
        return e;
    }

    public static void reportError(Node cNode, Node eNode, Hashtable errors, String message) {
        String label = String.valueOf(errors.size() + 1);
        errors.put(label, new fpError(cNode, eNode, message, label));
        ((Element)cNode).setAttribute("fp-error", "fp-" + label);
    }

    public static void saveResources(Node cNode, Hashtable resources, Hashtable errors) {
        Enumeration e = resources.elements();
        while (e.hasMoreElements()) {
            fpResource res = (fpResource)e.nextElement();
            if (!res.hasChanged()) continue;
            res.save(cNode, errors);
        }
    }
}

