/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.framework;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.cocoon.framework.Configurations;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLConfigurations
extends Configurations {
    Hashtable values = new Hashtable();
    Hashtable children = new Hashtable();
    String my_prefix = null;

    public XMLConfigurations() {
    }

    public XMLConfigurations(String file) throws IOException, SAXException {
        FileInputStream input = new FileInputStream(file);
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(input));
        XMLConfigurations.buildConfigurations(this, parser.getDocument().getDocumentElement());
        ((InputStream)input).close();
    }

    protected static void buildConfigurations(XMLConfigurations confs, Node source_node) {
        XMLConfigurations.buildConfigurations(confs, source_node, source_node.getNodeName());
    }

    protected static void buildConfigurations(XMLConfigurations confs, Node source_node, String prefix) {
        confs.my_prefix = prefix;
        NodeList nodes = source_node.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node node = nodes.item(i);
            short type = node.getNodeType();
            switch (type) {
                case 1: {
                    String name = node.getNodeName();
                    NodeList child_nodes = node.getChildNodes();
                    int child_nodes_length = child_nodes.getLength();
                    StringBuffer buffer = new StringBuffer();
                    boolean has_grandchildren = false;
                    int j = 0;
                    while (j < child_nodes_length) {
                        Node child_node = child_nodes.item(j);
                        switch (child_node.getNodeType()) {
                            case 3: {
                                buffer.append(child_node.getNodeValue());
                                break;
                            }
                            case 1: {
                                has_grandchildren = true;
                                break;
                            }
                        }
                        ++j;
                    }
                    confs.values.put(name, XMLConfigurations.stripBoundingWhitespace(buffer.toString()));
                    if (!has_grandchildren) break;
                    XMLConfigurations child_confs = new XMLConfigurations();
                    XMLConfigurations.buildConfigurations(child_confs, node, String.valueOf(confs.my_prefix) + '.' + name);
                    confs.children.put(name, child_confs);
                    break;
                }
            }
            ++i;
        }
    }

    public Object get(String key) {
        int index = key.indexOf(46);
        if (index < 0) {
            return this.values.get(key);
        }
        String prefix = key.substring(0, index);
        XMLConfigurations confs = (XMLConfigurations)this.children.get(prefix);
        if (confs == null) {
            return null;
        }
        return confs.get(key.substring(index + 1));
    }

    public Object get(String key, Object def) {
        Object o = this.get(key);
        return o == null ? def : o;
    }

    public Configurations getConfigurations(String key) {
        int index = key.indexOf(46);
        Configurations confs = null;
        String prefix = null;
        if (index < 0) {
            confs = (Configurations)this.children.get(key);
            if (confs == null) {
                confs = new XMLConfigurations();
                confs.setBasename(String.valueOf(this.my_prefix) + '.' + key);
                this.children.put(key, confs);
            }
            return confs;
        }
        prefix = key.substring(0, index);
        confs = (Configurations)this.children.get(prefix);
        if (confs == null) {
            XMLConfigurations child_confs = new XMLConfigurations();
            confs.setBasename(String.valueOf(this.my_prefix) + '.' + prefix);
            this.children.put(prefix, confs);
        }
        return confs.getConfigurations(key.substring(index + 1));
    }

    public Object getNotNull(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new RuntimeException("Cocoon configuration item '" + key + "' is not set");
        }
        return o;
    }

    public Vector getVector(String key) {
        Object n;
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while ((n = this.get(String.valueOf(key) + "." + i)) != null) {
            v.addElement(n);
            ++i;
        }
        return v;
    }

    public static void main(String[] argv) throws Exception {
        XMLConfigurations confs = new XMLConfigurations(argv[0]);
        System.out.println(confs.toString());
    }

    public void set(String key, Object value) {
        int index = key.indexOf(46);
        if (index < 0) {
            this.values.put(key, value);
        } else {
            String prefix = key.substring(0, index);
            XMLConfigurations confs = (XMLConfigurations)this.children.get(prefix);
            if (confs == null) {
                confs = new XMLConfigurations();
                this.children.put(prefix, confs);
            }
            confs.set(key.substring(index + 1), value);
        }
    }

    public void setBasename(String my_prefix) {
        this.my_prefix = my_prefix;
    }

    protected static String stripBoundingWhitespace(String input) {
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(input);
        char c = iter.first();
        while (c != '\uffff' && Character.isWhitespace(c)) {
            c = iter.next();
        }
        int start_offset = iter.getIndex();
        c = iter.last();
        while (c != '\uffff' && Character.isWhitespace(c)) {
            c = iter.previous();
        }
        int end_offset = iter.getIndex();
        if (end_offset <= start_offset) {
            return "";
        }
        return input.substring(start_offset, end_offset + 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration<Object> enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            sb.append(String.valueOf(this.my_prefix) + '.' + name + " = " + this.values.get(name) + '\n');
        }
        enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            XMLConfigurations confs = (XMLConfigurations)enumeration.nextElement();
            sb.append(confs.toString());
        }
        return sb.toString();
    }
}

