/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.framework;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Configurations {
    protected String baseName;
    protected Properties properties;

    public Configurations() {
        this.properties = new Properties();
    }

    public Configurations(InputStream stream) throws Exception {
        this(stream, null);
    }

    public Configurations(InputStream stream, Configurations defaults) throws Exception {
        this.properties = defaults != null ? new Properties(defaults.properties) : new Properties();
        this.properties.load(stream);
    }

    public Configurations(String file) throws Exception {
        this(file, null);
    }

    public Configurations(String file, Configurations defaults) throws Exception {
        this.properties = defaults != null ? new Properties(defaults.properties) : new Properties();
        FileInputStream input = new FileInputStream(file);
        this.properties.load(input);
        ((InputStream)input).close();
    }

    public Configurations(Configurations c) {
        this.properties = new Properties(c.properties);
    }

    public Object get(String key) {
        return ((Hashtable)this.properties).get(key);
    }

    public Object get(String key, Object def) {
        Object o = ((Hashtable)this.properties).get(key);
        return o == null ? def : o;
    }

    public Configurations getConfigurations(String base) {
        Configurations c = new Configurations();
        c.setBasename(this.baseName == null ? base : String.valueOf(this.baseName) + "." + base);
        String prefix = String.valueOf(base) + ".";
        Enumeration<?> keys = this.properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.startsWith(prefix)) {
                c.set(key.substring(prefix.length()), this.get(key));
                continue;
            }
            if (!key.equals(base)) continue;
            c.set("", this.get(key));
        }
        return c;
    }

    public Object getNotNull(String key) {
        Object o = ((Hashtable)this.properties).get(key);
        if (o == null) {
            throw new RuntimeException("Cocoon configuration item '" + (this.baseName == null ? "" : String.valueOf(this.baseName) + "." + key) + "' is not set");
        }
        return o;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Vector getVector(String key) {
        Object n;
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while ((n = this.get(String.valueOf(key) + "." + i)) != null) {
            v.addElement(n);
            ++i;
        }
        return v;
    }

    public Enumeration keys() {
        return ((Hashtable)this.properties).keys();
    }

    public void put(String key, Object value) {
        ((Hashtable)this.properties).put(key, value);
    }

    public void set(String key, Object value) {
        ((Hashtable)this.properties).put(key, value);
    }

    public void setBasename(String baseName) {
        this.baseName = baseName;
    }
}

