/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Tokenizer
implements Enumeration {
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    private String str = null;
    private String delim = null;
    private boolean returnTokens = false;
    private int previous = -1;
    private int current = 0;
    private int max = 0;

    public Tokenizer(String str) {
        this(str, DEFAULT_DELIMITERS, false);
    }

    public Tokenizer(String str, char delim) {
        this(str, String.valueOf(delim), false);
    }

    public Tokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public Tokenizer(String str, String delim, boolean returnTokens) {
        this.str = str;
        this.delim = delim;
        this.returnTokens = returnTokens;
        this.max = str.length();
    }

    public int countTokens() {
        int curr = this.current;
        int count = 0;
        int i = curr;
        while (i < this.max) {
            if (this.delim.indexOf(this.str.charAt(i)) >= 0) {
                ++count;
            }
            ++curr;
            ++i;
        }
        return count + (this.returnTokens ? count : 0) + 1;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.current < this.max ? true : this.current == this.max && (this.max == 0 || this.returnTokens && this.delim.indexOf(this.str.charAt(this.previous)) >= 0);
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() throws NoSuchElementException {
        if (this.current == this.max && (this.max == 0 || this.returnTokens && this.delim.indexOf(this.str.charAt(this.previous)) >= 0)) {
            ++this.current;
            return new String();
        }
        if (this.current >= this.max) {
            throw new NoSuchElementException();
        }
        int start = this.current;
        String result = null;
        if (this.delim.indexOf(this.str.charAt(start)) >= 0) {
            if (this.previous == -1 || this.returnTokens && this.previous != this.current && this.delim.indexOf(this.str.charAt(this.previous)) >= 0) {
                result = new String();
            } else if (this.returnTokens) {
                result = this.str.substring(start, ++this.current);
            }
            if (!this.returnTokens) {
                ++this.current;
            }
        }
        this.previous = start;
        start = this.current;
        if (result == null) {
            while (this.current < this.max && this.delim.indexOf(this.str.charAt(this.current)) < 0) {
                ++this.current;
            }
        }
        return result == null ? this.str.substring(start, this.current) : result;
    }

    public String nextToken(String delim) throws NoSuchElementException {
        this.delim = delim;
        return this.nextToken();
    }

    public void reset() {
        this.previous = -1;
        this.current = 0;
    }

    public static String[] tokenize(String str, String delim, boolean returnTokens) {
        Tokenizer tokenizer = new Tokenizer(str, delim, returnTokens);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }
}

