/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.framework.Actor;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.logger.Logger;
import org.apache.tools.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Profiler
implements Actor {
    public static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    protected Logger logger;
    protected Hashtable requests = new Hashtable();
    protected Vector requestOrder = new Vector();
    protected Vector eventNames = new Vector();

    public void clear() {
        this.requests.clear();
        this.requestOrder.removeAllElements();
        this.eventNames.removeAllElements();
    }

    public void finishEvent(RequestMarker request, Class event) {
        this.finishEvent(request, this.mangleName(event.getName()));
    }

    public void finishEvent(RequestMarker request, String event) {
        long finTime = System.currentTimeMillis();
        Hashtable rm = this.getRequestMap(request);
        ProfProcess pp = (ProfProcess)rm.get(event);
        if (pp == null) {
            this.logger.log(this, "Event '" + event + "' not started yet!", 3);
        } else {
            pp.finishedAt(finTime);
        }
    }

    public Element getProfileTable(Document dest) {
        DOMWriter domWriter = new DOMWriter(dest, "profile-table");
        domWriter.push("headings");
        domWriter.addQuick("heading", "URI");
        domWriter.addQuick("heading", "Date and Time");
        Enumeration enumeration = this.eventNames.elements();
        while (enumeration.hasMoreElements()) {
            domWriter.addQuick("heading", (String)enumeration.nextElement());
        }
        domWriter.pop("headings");
        Enumeration rq = this.requestOrder.elements();
        while (rq.hasMoreElements()) {
            domWriter.push("row");
            RequestMarker request = (RequestMarker)rq.nextElement();
            Hashtable map = (Hashtable)this.requests.get(request);
            domWriter.addQuick("uri", request.uri);
            domWriter.addQuick("date-time", DATE_FORMAT.format(request.startTime));
            Enumeration proc = this.eventNames.elements();
            while (proc.hasMoreElements()) {
                String event = (String)proc.nextElement();
                ProfProcess pp = (ProfProcess)map.get(event);
                if (pp != null && pp.finished) {
                    domWriter.addQuick(event, String.valueOf(pp.getDuration()));
                    continue;
                }
                domWriter.addQuick(event, "-");
            }
            domWriter.pop("row");
        }
        return (Element)domWriter.getCurrent();
    }

    protected Hashtable getRequestMap(RequestMarker request) {
        Hashtable map = (Hashtable)this.requests.get(request);
        if (map == null) {
            map = new Hashtable();
            this.requests.put(request, map);
            this.requestOrder.addElement(request);
        }
        return map;
    }

    public void init(Director director) {
        this.logger = (Logger)director.getActor("logger");
    }

    public String mangleName(String name) {
        return name.replace('.', '-');
    }

    public void startEvent(RequestMarker request, Class event) {
        this.startEvent(request, this.mangleName(event.getName()));
    }

    public void startEvent(RequestMarker request, String event) {
        if (!this.eventNames.contains(event)) {
            this.eventNames.addElement(event);
        }
        Hashtable rm = this.getRequestMap(request);
        rm.put(event, new ProfProcess(System.currentTimeMillis(), event));
    }

    public static class RequestMarker {
        protected String uri;
        protected Date startTime;

        public RequestMarker(HttpServletRequest req) {
            this.uri = req.getRequestURI();
            this.startTime = new Date(System.currentTimeMillis());
        }
    }

    protected class ProfProcess {
        protected final String event;
        protected boolean finished = false;
        protected long time;

        protected ProfProcess(long startTime, String event) {
            this.event = event;
            this.time = startTime;
        }

        protected void finishedAt(long finishTime) {
            this.time = finishTime - this.time;
            this.finished = true;
        }

        protected long getDuration() {
            if (!this.finished) {
                Profiler.this.logger.log(Profiler.this, "Event '" + this.event + "' not finished yet!", 3);
                return -1L;
            }
            return this.time;
        }
    }
}

