/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Path;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Exec;

public class Javadoc
extends Exec {
    private String maxmemory = null;
    private Path sourcePath = null;
    private String additionalParam = null;
    private File destDir = null;
    private File overviewFile = null;
    private String sourceFiles = null;
    private String packageNames = null;
    private boolean pub = false;
    private boolean prot = false;
    private boolean pack = false;
    private boolean priv = false;
    private boolean author = true;
    private boolean version = true;
    private DocletInfo doclet = null;
    private boolean old = false;
    private Path classpath = null;
    private Path bootclasspath = null;
    private String extdirs = null;
    private boolean verbose = false;
    private String locale = null;
    private String encoding = null;
    private boolean use = false;
    private boolean splitindex = false;
    private String windowtitle = null;
    private String doctitle = null;
    private String header = null;
    private String footer = null;
    private String bottom = null;
    private String linkoffline = null;
    private String link = null;
    private String group = null;
    private boolean nodeprecated = false;
    private boolean nodeprecatedlist = false;
    private boolean notree = false;
    private boolean noindex = false;
    private boolean nohelp = false;
    private boolean nonavbar = false;
    private boolean serialwarn = false;
    private File stylesheetfile = null;
    private File helpfile = null;
    private String docencoding = null;
    private Vector compileList = new Vector(10);
    private String packageList = null;
    private Vector links = new Vector(2);
    private Vector groups = new Vector(2);
    private String charset = null;
    private String queuedLine = null;

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path();
        }
        return this.bootclasspath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path();
        }
        return this.classpath;
    }

    public DocletInfo createDoclet() {
        this.doclet = new DocletInfo();
        return this.doclet;
    }

    public GroupArgument createGroup() {
        GroupArgument ga = new GroupArgument();
        this.groups.addElement(ga);
        return ga;
    }

    public LinkArgument createLink() {
        LinkArgument la = new LinkArgument();
        this.links.addElement(la);
        return la;
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path();
        }
        return this.sourcePath;
    }

    private void evaluatePackages(Path sourcePath, Vector packages, Vector argList) {
        this.log("Parsing source files for packages", 2);
        this.log("Source path = " + sourcePath.toString(), 3);
        this.log("Packages = " + packages, 3);
        Vector<String> addedPackages = new Vector<String>();
        String[] list = sourcePath.list();
        int j = 0;
        while (j < list.length) {
            File source = this.project.resolveFile(list[j]);
            Hashtable map = this.mapClasses(source);
            Enumeration e = map.keys();
            block1: while (e.hasMoreElements()) {
                String pack = (String)e.nextElement();
                int i = 0;
                while (i < packages.size()) {
                    if (this.matches(pack, (String)packages.elementAt(i))) {
                        if (addedPackages.contains(pack)) continue block1;
                        argList.addElement(pack);
                        addedPackages.addElement(pack);
                        continue block1;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void execute() throws BuildException {
        StringTokenizer tok;
        if (this.sourcePath == null || this.destDir == null) {
            String msg = "sourcePath and destDir attributes must be set!";
            throw new BuildException(msg);
        }
        boolean javadoc1 = Project.getJavaVersion() == "1.1";
        this.log("Generating Javadoc", 2);
        Vector<String> argList = new Vector<String>();
        if (this.classpath == null) {
            this.classpath = Path.systemClasspath;
        }
        if (this.maxmemory != null) {
            if (javadoc1) {
                argList.addElement("-J-mx" + this.maxmemory);
            } else {
                argList.addElement("-J-Xmx" + this.maxmemory);
            }
        }
        if (!javadoc1 || this.sourcePath == null) {
            argList.addElement("-classpath");
            argList.addElement(this.classpath.toString());
            if (this.sourcePath != null) {
                argList.addElement("-sourcepath");
                argList.addElement(this.sourcePath.toString());
            }
        } else {
            argList.addElement("-classpath");
            argList.addElement(String.valueOf(this.sourcePath.toString()) + System.getProperty("path.separator") + this.classpath.toString());
        }
        if (this.destDir != null) {
            argList.addElement("-d");
            argList.addElement(this.destDir.getAbsolutePath());
        }
        if (this.version && this.doclet == null) {
            argList.addElement("-version");
        }
        if (this.nodeprecated) {
            argList.addElement("-nodeprecated");
        }
        if (this.author && this.doclet == null) {
            argList.addElement("-author");
        }
        if (this.noindex) {
            argList.addElement("-noindex");
        }
        if (this.notree) {
            argList.addElement("-notree");
        }
        if (this.pub) {
            argList.addElement("-public");
        }
        if (this.prot) {
            argList.addElement("-protected");
        }
        if (this.pack) {
            argList.addElement("-package");
        }
        if (this.priv) {
            argList.addElement("-private");
        }
        if (this.encoding != null) {
            argList.addElement("-encoding");
            argList.addElement(this.encoding);
        }
        if (this.docencoding != null) {
            argList.addElement("-docencoding");
            argList.addElement(this.docencoding);
        }
        if (!javadoc1) {
            Enumeration e;
            if (this.overviewFile != null) {
                argList.addElement("-overview");
                argList.addElement(this.overviewFile.getAbsolutePath());
            }
            if (this.old) {
                argList.addElement("-1.1");
            }
            if (this.verbose) {
                argList.addElement("-verbose");
            }
            if (this.use) {
                argList.addElement("-use");
            }
            if (this.splitindex) {
                argList.addElement("-splitindex");
            }
            if (this.nodeprecatedlist) {
                argList.addElement("-nodeprecatedlist");
            }
            if (this.nohelp) {
                argList.addElement("-nohelp");
            }
            if (this.nonavbar) {
                argList.addElement("-nonavbar");
            }
            if (this.serialwarn) {
                argList.addElement("-serialwarn");
            }
            if (this.doclet != null) {
                if (this.doclet.getName() == null) {
                    throw new BuildException("The doclet name must be specified.");
                }
                argList.addElement("-doclet");
                argList.addElement(this.doclet.getName());
                if (this.doclet.getPath() != null) {
                    argList.addElement("-docletpath");
                    argList.addElement(this.doclet.getPath().toString());
                }
                e = this.doclet.getParams();
                while (e.hasMoreElements()) {
                    DocletParam param = (DocletParam)e.nextElement();
                    if (param.getName() == null) {
                        throw new BuildException("Doclet parameters must have a name");
                    }
                    argList.addElement(param.getName());
                    if (param.getValue() == null) continue;
                    argList.addElement(param.getValue());
                }
            }
            if (this.bootclasspath != null) {
                argList.addElement("-bootclasspath");
                argList.addElement(this.bootclasspath.toString());
            }
            if (this.extdirs != null) {
                argList.addElement("-extdirs");
                argList.addElement(this.extdirs);
            }
            if (this.locale != null) {
                argList.addElement("-locale");
                argList.addElement(this.locale);
            }
            if (this.encoding != null) {
                argList.addElement("-encoding");
                argList.addElement(this.encoding);
            }
            if (this.windowtitle != null) {
                argList.addElement("-windowtitle");
                argList.addElement(this.windowtitle);
            }
            if (this.doctitle != null) {
                argList.addElement("-doctitle");
                argList.addElement(this.doctitle);
            }
            if (this.header != null) {
                argList.addElement("-header");
                argList.addElement(this.header);
            }
            if (this.footer != null) {
                argList.addElement("-footer");
                argList.addElement(this.footer);
            }
            if (this.bottom != null) {
                argList.addElement("-bottom");
                argList.addElement(this.bottom);
            }
            if (this.link != null) {
                argList.addElement("-link");
                argList.addElement(this.link);
            }
            if (this.links.size() != 0) {
                e = this.links.elements();
                while (e.hasMoreElements()) {
                    LinkArgument la = (LinkArgument)e.nextElement();
                    if (la.getHref() == null) {
                        throw new BuildException("Links must provide the RUL to the external class documentation.");
                    }
                    if (la.isLinkOffline()) {
                        String packageListLocation = la.getPackagelistLoc();
                        if (packageListLocation == null) {
                            throw new BuildException("The package list location for link " + la.getHref() + " must be provided because the link is offline");
                        }
                        argList.addElement("-linkoffline");
                        argList.addElement(la.getHref());
                        argList.addElement(packageListLocation);
                        continue;
                    }
                    argList.addElement("-link");
                    argList.addElement(la.getHref());
                }
            }
            if (this.linkoffline != null) {
                argList.addElement("-linkoffline");
                argList.addElement(this.linkoffline);
            }
            if (this.group != null) {
                tok = new StringTokenizer(this.group, ",", false);
                while (tok.hasMoreTokens()) {
                    String grp = tok.nextToken().trim();
                    int space = grp.indexOf(" ");
                    if (space <= 0) continue;
                    String name = grp.substring(0, space);
                    String pkgList = grp.substring(space + 1);
                    argList.addElement("-group");
                    argList.addElement(name);
                    argList.addElement(pkgList);
                }
            }
            if (this.groups.size() != 0) {
                e = this.groups.elements();
                while (e.hasMoreElements()) {
                    GroupArgument ga = (GroupArgument)e.nextElement();
                    String title = ga.getTitle();
                    String packages = ga.getPackages();
                    if (title == null || packages == null) {
                        throw new BuildException("The title and packages must be specified for group elements.");
                    }
                    argList.addElement("-group");
                    argList.addElement(title);
                    argList.addElement(packages);
                }
            }
            if (this.stylesheetfile != null) {
                argList.addElement("-stylesheetfile");
                argList.addElement(this.stylesheetfile.getAbsolutePath());
            }
            if (this.helpfile != null) {
                argList.addElement("-helpfile");
                argList.addElement(this.helpfile.getAbsolutePath());
            }
            if (this.charset != null) {
                argList.addElement("-charset");
                argList.addElement(this.charset);
            }
            if (this.additionalParam != null) {
                argList.addElement(this.additionalParam);
            }
        }
        if (this.packageNames != null && this.packageNames.length() > 0) {
            Vector<String> packages = new Vector<String>();
            StringTokenizer tok2 = new StringTokenizer(this.packageNames, ",", false);
            while (tok2.hasMoreTokens()) {
                String name = tok2.nextToken().trim();
                if (name.endsWith(".*")) {
                    packages.addElement(name);
                    continue;
                }
                argList.addElement(name);
            }
            if (packages.size() > 0) {
                this.evaluatePackages(this.sourcePath, packages, argList);
            }
        }
        if (this.sourceFiles != null && this.sourceFiles.length() > 0) {
            tok = new StringTokenizer(this.sourceFiles, ",", false);
            while (tok.hasMoreTokens()) {
                argList.addElement(tok.nextToken().trim());
            }
        }
        if (this.packageList != null) {
            argList.addElement("@" + this.packageList);
        }
        this.log("Javadoc args: " + argList.toString(), 3);
        this.log("Javadoc execution", 2);
        StringBuffer b = new StringBuffer();
        b.append("javadoc ");
        Enumeration e = argList.elements();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            if (!arg.startsWith("-")) {
                b.append("\"");
                b.append(arg);
                b.append("\"");
            } else {
                b.append(arg);
            }
            if (!e.hasMoreElements()) continue;
            b.append(" ");
        }
        this.run(b.toString());
    }

    private void getFiles(File path, Vector list) {
        if (!path.exists()) {
            throw new BuildException("Path " + path + " does not exist.");
        }
        String[] files = path.list();
        String cwd = String.valueOf(path.getPath()) + System.getProperty("file.separator");
        if (files != null) {
            int count = 0;
            int i = 0;
            while (i < files.length) {
                File file = new File(String.valueOf(cwd) + files[i]);
                if (file.isDirectory()) {
                    this.getFiles(file, list);
                } else if (files[i].endsWith(".java")) {
                    ++count;
                    list.addElement(file);
                }
                ++i;
            }
            if (count > 0) {
                this.log("found " + count + " source files in " + path, 3);
            }
        } else {
            throw new BuildException("Error occurred during " + path + " evaluation.");
        }
    }

    private String getPackageName(File file) {
        String name = null;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new JavaReader(new BufferedReader(new FileReader(file))));
            do {
                if ((line = reader.readLine()) != null) continue;
                this.log("Could not evaluate package for " + file, 1);
                return null;
            } while (!line.trim().startsWith("package ") && !line.trim().startsWith("package\t"));
            name = line.substring(8, line.indexOf(";")).trim();
            reader.close();
        }
        catch (Exception e) {
            this.log("Exception " + e + " parsing " + file, 1);
            return null;
        }
        this.log(String.valueOf(String.valueOf(file)) + " --> " + name, 3);
        return name;
    }

    protected void logFlush() {
        if (this.queuedLine != null) {
            super.outputLog(this.queuedLine, 3);
            this.queuedLine = null;
        }
        super.logFlush();
    }

    private Hashtable mapClasses(File path) {
        Hashtable<String, File> map = new Hashtable<String, File>();
        Vector files = new Vector();
        this.getFiles(path, files);
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            File file = (File)e.nextElement();
            String packageName = this.getPackageName(file);
            if (packageName == null) continue;
            map.put(packageName, file);
        }
        return map;
    }

    private boolean matches(String string, String pattern) {
        return string.startsWith(pattern.substring(0, pattern.length() - 2));
    }

    protected void outputLog(String line, int messageLevel) {
        if (messageLevel == 2 && line.startsWith("Generating ")) {
            if (this.queuedLine != null) {
                super.outputLog(this.queuedLine, 3);
            }
            this.queuedLine = line;
        } else {
            if (this.queuedLine != null) {
                if (line.startsWith("Building ")) {
                    super.outputLog(this.queuedLine, 3);
                } else {
                    super.outputLog(this.queuedLine, 2);
                }
                this.queuedLine = null;
            }
            super.outputLog(line, messageLevel);
        }
    }

    public void setAuthor(String src) {
        this.author = Project.toBoolean(src);
    }

    public void setBootclasspath(Path src) {
        if (this.bootclasspath == null) {
            this.bootclasspath = src;
        } else {
            this.bootclasspath.append(src);
        }
    }

    public void setBottom(String src) {
        this.bottom = src;
    }

    public void setCharset(String src) {
        this.charset = src;
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public void setDestdir(String src) {
        this.destDir = this.project.resolveFile(src);
    }

    public void setDocencoding(String src) {
        this.docencoding = src;
    }

    public void setDoclet(String src) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setName(src);
    }

    public void setDocletPath(Path src) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setPath(src);
    }

    public void setDoctitle(String src) {
        this.doctitle = src;
    }

    public void setEncoding(String src) {
        this.encoding = src;
    }

    public void setExtdirs(String src) {
        this.extdirs = src;
    }

    public void setFooter(String src) {
        this.footer = src;
    }

    public void setGroup(String src) {
        this.group = src;
    }

    public void setHeader(String src) {
        this.header = src;
    }

    public void setLink(String src) {
        this.link = src;
    }

    public void setLinkoffline(String src) {
        this.linkoffline = src;
    }

    public void setLocale(String src) {
        this.locale = src;
    }

    public void setMaxmemory(String src) {
        this.maxmemory = src;
    }

    public void setNodeprecated(String src) {
        this.nodeprecated = Project.toBoolean(src);
    }

    public void setNodeprecatedlist(String src) {
        this.nodeprecatedlist = Project.toBoolean(src);
    }

    public void setNohelp(String src) {
        this.nohelp = Project.toBoolean(src);
    }

    public void setNoindex(String src) {
        this.noindex = Project.toBoolean(src);
    }

    public void setNonavbar(String src) {
        this.nonavbar = Project.toBoolean(src);
    }

    public void setNotree(String src) {
        this.notree = Project.toBoolean(src);
    }

    public void setOld(String src) {
        this.old = Project.toBoolean(src);
    }

    public void setOverview(String src) {
        this.overviewFile = this.project.resolveFile(src);
    }

    public void setPackage(String src) {
        this.pack = Project.toBoolean(src);
    }

    public void setPackageList(String src) {
        this.packageList = src;
    }

    public void setPackagenames(String src) {
        this.packageNames = src;
    }

    public void setPrivate(String src) {
        this.priv = Project.toBoolean(src);
    }

    public void setProtected(String src) {
        this.prot = Project.toBoolean(src);
    }

    public void setPublic(String src) {
        this.pub = Project.toBoolean(src);
    }

    public void setSerialwarn(String src) {
        this.serialwarn = Project.toBoolean(src);
    }

    public void setSourcefiles(String src) {
        this.sourceFiles = src;
    }

    public void setSourcepath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public void setSplitindex(String src) {
        this.splitindex = Project.toBoolean(src);
    }

    public void setStylesheetfile(String src) {
        this.stylesheetfile = this.project.resolveFile(src);
    }

    public void setUse(String src) {
        this.use = Project.toBoolean(src);
    }

    public void setVerbose(String src) {
        this.verbose = Project.toBoolean(src);
    }

    public void setVersion(String src) {
        this.version = Project.toBoolean(src);
    }

    public void setWindowtitle(String src) {
        this.windowtitle = src;
    }

    public void setadditionalParam(String src) {
        this.additionalParam = src;
    }

    public class DocletParam {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class DocletInfo {
        private String name;
        private Path path;
        private Vector params = new Vector();

        public DocletParam createParam() {
            DocletParam param = new DocletParam();
            this.params.addElement(param);
            return param;
        }

        public Path createPath() {
            if (this.path == null) {
                this.path = new Path();
            }
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public Enumeration getParams() {
            return this.params.elements();
        }

        public Path getPath() {
            return this.path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }
    }

    public class LinkArgument {
        private String href;
        private boolean offline = false;
        private String packagelistLoc;

        public String getHref() {
            return this.href;
        }

        public String getPackagelistLoc() {
            return this.packagelistLoc;
        }

        public boolean isLinkOffline() {
            return this.offline;
        }

        public void setHref(String hr) {
            this.href = hr;
        }

        public void setOffline(String offline) {
            this.offline = Project.toBoolean(offline);
        }

        public void setPackagelistLoc(String src) {
            this.packagelistLoc = src;
        }
    }

    public class GroupArgument {
        private String title;
        private String packages;

        public String getPackages() {
            return this.packages;
        }

        public String getTitle() {
            return this.title;
        }

        public void setPackages(String src) {
            this.packages = src;
        }

        public void setTitle(String src) {
            this.title = src;
        }
    }

    class JavaReader
    extends FilterReader {
        public JavaReader(Reader in) {
            super(in);
        }

        public int read() throws IOException {
            int c = this.in.read();
            if (c == 47) {
                c = this.in.read();
                if (c == 47) {
                    while (c != 10 && c != -1) {
                        c = this.in.read();
                    }
                } else if (c == 42) {
                    while (c != -1) {
                        c = this.in.read();
                        if (c != 42) continue;
                        c = this.in.read();
                        while (c == 42 && c != -1) {
                            c = this.in.read();
                        }
                        if (c != 47) continue;
                        c = this.read();
                        break;
                    }
                }
            }
            if (c == 34) {
                while (c != -1) {
                    c = this.in.read();
                    if (c == 92) {
                        c = this.in.read();
                        continue;
                    }
                    if (c != 34) continue;
                    c = this.read();
                    break;
                }
            }
            if (c == 39) {
                c = this.in.read();
                if (c == 92) {
                    c = this.in.read();
                }
                c = this.in.read();
                c = this.read();
            }
            return c;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                int c = this.read();
                if (c == -1) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                cbuf[off + i] = (char)c;
                ++i;
            }
            return len;
        }

        public long skip(long n) throws IOException {
            long i = 0L;
            while (i < n) {
                if (this.in.read() == -1) {
                    return i;
                }
                ++i;
            }
            return n;
        }
    }
}

