// 
// File:          objarg_EmployeeArray_Impl.cc
// Symbol:        objarg.EmployeeArray-v0.5
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for objarg.EmployeeArray
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "objarg_EmployeeArray_Impl.hh"

// 
// Includes for all method dependencies.
// 
#ifndef included_objarg_Employee_hh
#include "objarg_Employee.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif
#line 26 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._includes)
#include <float.h>
using namespace ucxx::objarg;
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._includes)
#line 31 "objarg_EmployeeArray_Impl.cc"

// user defined constructor
void objarg::EmployeeArray_impl::_ctor() {
#line 33 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._ctor)
#line 39 "objarg_EmployeeArray_Impl.cc"
}

// user defined destructor
void objarg::EmployeeArray_impl::_dtor() {
#line 40 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._dtor)
#line 48 "objarg_EmployeeArray_Impl.cc"
}

// static class initializer
void objarg::EmployeeArray_impl::_load() {
#line 47 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray._load)
#line 57 "objarg_EmployeeArray_Impl.cc"
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * Return the number of employees in the employee array.
 */
int32_t
objarg::EmployeeArray_impl::getLength_impl () 
throw () 

{
#line 63 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.getLength)
  return d_array.size();
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.getLength)
#line 75 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Return the employee in position <code>index</code> where
 * <code>index</code> ranges from 1 to the length of the array.
 * If <code>index</code> is outside the range of the array (i.e.
 * less than or equal to zero or greater than the current number
 * of elements in the array), this method returns a NULL
 * employee object.
 */
::ucxx::objarg::Employee
objarg::EmployeeArray_impl::at_impl (
  /* in */int32_t index ) 
throw () 
{
#line 81 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.at)
  if ( index >= 1 && index <= (int32_t) d_array.size() ) {
    return d_array[index-1];
  } else { 
    return Employee();
  }
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.at)
#line 99 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Add an employee onto the end of the array.  It is perfectly
 * legal to add the same employee multiple times.
 * <code>true</code> is returned when the append was successful;
 * otherwise, <code>false</code> is returned to indicate
 * failure.  This method will not add a NULL employee.
 */
bool
objarg::EmployeeArray_impl::appendEmployee_impl (
  /* in */::ucxx::objarg::Employee e ) 
throw () 
{
#line 102 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.appendEmployee)
  if (e._not_nil()) {
    d_array.push_back( e );
    return true;
  }
  return false;
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.appendEmployee)
#line 122 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Find the first employee in the array that has a name matching
 * <code>name</code>.  If a match exists, the index is returned,
 * and the employee is returned in parameter <code>e</code>.
 * 
 * If no match exists, 0 is returned, and <code>e</code> is NULL.
 */
int32_t
objarg::EmployeeArray_impl::findByName_impl (
  /* in */const ::std::string& name,
  /* out */::ucxx::objarg::Employee& e ) 
throw () 
{
#line 124 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.findByName)
  int i=1;
  for( d_array_t::iterator cur = d_array.begin(), end = d_array.end();
       cur != end; ++cur,++i ) { 
    if ( cur->getName() == name ) { 
      e = *cur;
      return i;
    }
  }
  e = Employee();
  return 0;
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.findByName)
#line 151 "objarg_EmployeeArray_Impl.cc"
}

/**
 * Determine the maximum salary in the array. If the maximum
 * salary in the array is greater than the current salary of
 * <code>e</code>, the salary of <code>e</code> will be 
 * increased to the maximum salary in the array.  If the
 * array is empty, no change will be made to <code>e</code>.
 * 
 * This method returns <code>true</code> iff the salary of
 * <code>e</code> is modified.
 */
bool
objarg::EmployeeArray_impl::promoteToMaxSalary_impl (
  /* inout */::ucxx::objarg::Employee& e ) 
throw () 
{
#line 153 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
  // DO-NOT-DELETE splicer.begin(objarg.EmployeeArray.promoteToMaxSalary)
  if (d_array.size() && e._not_nil()) {
    float max_salary = -FLT_MAX;
    for( d_array_t::iterator cur = d_array.begin(), end = d_array.end();
	 cur != end; ++cur ) { 
      max_salary = std::max( cur->getSalary(), max_salary );
    }
    if ( e.getSalary() < max_salary ) { 
      e.setSalary( max_salary );
      return true;
    }
  }
  return false;
  // DO-NOT-DELETE splicer.end(objarg.EmployeeArray.promoteToMaxSalary)
#line 184 "objarg_EmployeeArray_Impl.cc"
}


#line 170 "../../../../babel/regression/objarg/libUCxx/objarg_EmployeeArray_Impl.cc"
// DO-NOT-DELETE splicer.begin(objarg.EmployeeArray._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(objarg.EmployeeArray._misc)
#line 192 "objarg_EmployeeArray_Impl.cc"

