/*
 * File:          sidl_rmi_InstanceHandle_jniStub.c
 * Symbol:        sidl.rmi.InstanceHandle-v0.9.1
 * Symbol Type:   interface
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.rmi.InstanceHandle
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_rmi_InstanceHandle_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_rmi_InstanceHandle__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_rmi_InstanceHandle__object*) ptr;
}

/*
 * <p>
 * Add one to the intrinsic reference count in the underlying object.
 * Object in <code>sidl</code> have an intrinsic reference count.
 * Objects continue to exist as long as the reference count is
 * positive. Clients should call this method whenever they
 * create another ongoing reference to an object or interface.
 * </p>
 * <p>
 * This does not have a return value because there is no language
 * independent type that can refer to an interface or a
 * class.
 * </p>
 */

static void
jni_addRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Decrease by one the intrinsic reference count in the underlying
 * object, and delete the object if the reference is non-positive.
 * Objects in <code>sidl</code> have an intrinsic reference count.
 * Clients should call this method whenever they remove a
 * reference to an object or interface.
 */

static void
jni_deleteRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_deleteRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */

static jboolean
jni_isSame(
  JNIEnv* env,
  jobject obj,
  jobject _arg_iobj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  struct sidl_BaseInterface__object* _tmp_iobj = (struct 
    sidl_BaseInterface__object*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_iobj = (struct sidl_BaseInterface__object*) sidl_Java_J2I_ifc(env,
    _arg_iobj, "sidl.BaseInterface");

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isSame))(
    _ior->d_object,
    _tmp_iobj);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */

static jobject
jni_queryInt(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  struct sidl_BaseInterface__object* _ior_res = (struct 
    sidl_BaseInterface__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_queryInt))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.BaseInterface");

  return _res;
}

/*
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */

static jboolean
jni_isType(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isType))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Return the meta-data about the class implementing this interface.
 */

static jobject
jni_getClassInfo(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  struct sidl_ClassInfo__object* _ior_res = (struct sidl_ClassInfo__object*) 
    NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getClassInfo))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.ClassInfo");

  return _res;
}

/*
 * initialize a connection (intended for use by the ProtocolFactory) 
 */

static jboolean
jni_initCreate(
  JNIEnv* env,
  jobject obj,
  jstring _arg_protocol,
  jstring _arg_server,
  jint _arg_port,
  jstring _arg_typeName)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _tmp_protocol = (char*) NULL;
  char* _tmp_server = (char*) NULL;
  int32_t _tmp_port = 0;
  char* _tmp_typeName = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_protocol = sidl_Java_J2I_string(env, _arg_protocol);
  _tmp_server = sidl_Java_J2I_string(env, _arg_server);
  _tmp_port = (int32_t) _arg_port;
  _tmp_typeName = sidl_Java_J2I_string(env, _arg_typeName);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_initCreate))(
    _ior->d_object,
    _tmp_protocol,
    _tmp_server,
    _tmp_port,
    _tmp_typeName,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_protocol);
  sidl_String_free(_tmp_server);
  sidl_String_free(_tmp_typeName);
  _res = (jboolean) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * initialize a connection (intended for use by the ProtocolFactory) 
 */

static jboolean
jni_initConnect(
  JNIEnv* env,
  jobject obj,
  jstring _arg_protocol,
  jstring _arg_server,
  jint _arg_port,
  jstring _arg_typeName,
  jstring _arg_objectID)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _tmp_protocol = (char*) NULL;
  char* _tmp_server = (char*) NULL;
  int32_t _tmp_port = 0;
  char* _tmp_typeName = (char*) NULL;
  char* _tmp_objectID = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_protocol = sidl_Java_J2I_string(env, _arg_protocol);
  _tmp_server = sidl_Java_J2I_string(env, _arg_server);
  _tmp_port = (int32_t) _arg_port;
  _tmp_typeName = sidl_Java_J2I_string(env, _arg_typeName);
  _tmp_objectID = sidl_Java_J2I_string(env, _arg_objectID);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_initConnect))(
    _ior->d_object,
    _tmp_protocol,
    _tmp_server,
    _tmp_port,
    _tmp_typeName,
    _tmp_objectID,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_protocol);
  sidl_String_free(_tmp_server);
  sidl_String_free(_tmp_typeName);
  sidl_String_free(_tmp_objectID);
  _res = (jboolean) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * return the name of the protocol 
 */

static jstring
jni_getProtocol(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getProtocol))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * return the name of the server 
 */

static jstring
jni_getServerName(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getServerName))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * return the port number on the server 
 */

static jint
jni_getPort(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  int32_t _ior_res = 0;
  jint _res = 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getPort))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jint) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * return the session ID 
 */

static jstring
jni_getObjectID(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getObjectID))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * create a handle to invoke a named method 
 */

static jobject
jni_createInvocation(
  JNIEnv* env,
  jobject obj,
  jstring _arg_methodName)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  char* _tmp_methodName = (char*) NULL;
  struct sidl_rmi_Invocation__object* _ior_res = (struct 
    sidl_rmi_Invocation__object*) NULL;
  jobject _res = (jobject) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_methodName = sidl_Java_J2I_string(env, _arg_methodName);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_createInvocation))(
    _ior->d_object,
    _tmp_methodName,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_methodName);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.rmi.Invocation");
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * closes the connection (called be destructor, if not done explicitly) 
 * returns true if successful, false otherwise (including subsequent calls)
 */

static jboolean
jni_close(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_InstanceHandle__object* _ior = NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_close))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_rmi_InstanceHandle__register(JNIEnv* env)
{
  JNINativeMethod methods[14];
  jclass cls;

  methods[0].name      = "addRef";
  methods[0].signature = "()V";
  methods[0].fnPtr     = (void *)jni_addRef;
  methods[1].name      = "deleteRef";
  methods[1].signature = "()V";
  methods[1].fnPtr     = (void *)jni_deleteRef;
  methods[2].name      = "isSame";
  methods[2].signature = "(Lsidl/BaseInterface;)Z";
  methods[2].fnPtr     = (void *)jni_isSame;
  methods[3].name      = "queryInt";
  methods[3].signature = "(Ljava/lang/String;)Lsidl/BaseInterface;";
  methods[3].fnPtr     = (void *)jni_queryInt;
  methods[4].name      = "isType";
  methods[4].signature = "(Ljava/lang/String;)Z";
  methods[4].fnPtr     = (void *)jni_isType;
  methods[5].name      = "getClassInfo";
  methods[5].signature = "()Lsidl/ClassInfo;";
  methods[5].fnPtr     = (void *)jni_getClassInfo;
  methods[6].name      = "init";
  methods[6].signature = "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)Z";
  methods[6].fnPtr     = (void *)jni_initCreate;
  methods[7].name      = "init";
  methods[7].signature = "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)Z";
  methods[7].fnPtr     = (void *)jni_initConnect;
  methods[8].name      = "getProtocol";
  methods[8].signature = "()Ljava/lang/String;";
  methods[8].fnPtr     = (void *)jni_getProtocol;
  methods[9].name      = "getServerName";
  methods[9].signature = "()Ljava/lang/String;";
  methods[9].fnPtr     = (void *)jni_getServerName;
  methods[10].name      = "getPort";
  methods[10].signature = "()I";
  methods[10].fnPtr     = (void *)jni_getPort;
  methods[11].name      = "getObjectID";
  methods[11].signature = "()Ljava/lang/String;";
  methods[11].fnPtr     = (void *)jni_getObjectID;
  methods[12].name      = "createInvocation";
  methods[12].signature = "(Ljava/lang/String;)Lsidl/rmi/Invocation;";
  methods[12].fnPtr     = (void *)jni_createInvocation;
  methods[13].name      = "close";
  methods[13].signature = "()Z";
  methods[13].fnPtr     = (void *)jni_close;


  cls = (*env)->FindClass(env, "sidl/rmi/InstanceHandle$Wrapper");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 14);
    (*env)->DeleteLocalRef(env, cls);
  }
}
