/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Enumeration
extends Symbol {
    private Set d_assigned_values = new HashSet();
    private List d_enumerators = new ArrayList();
    private Map d_enumerator_comments = new HashMap();
    private int d_next_unused = 0;
    private Map d_user_defined = new HashMap();
    private Map d_values = new HashMap();

    public Enumeration(SymbolID id, Comment comment) {
        super(id, 11, comment);
    }

    public Enumeration(SymbolID id, Comment comment, Metadata metadata) {
        super(id, 11, comment, metadata);
    }

    public void addEnumerator(String name, int value, boolean from_user, Comment comment) {
        Integer ivalue = new Integer(value);
        this.d_assigned_values.add(ivalue);
        if (!this.d_user_defined.containsKey(name)) {
            this.d_enumerators.add(name);
        }
        this.d_enumerator_comments.put(name, comment);
        this.d_user_defined.put(name, new Boolean(from_user));
        this.d_values.put(name, ivalue);
    }

    public void addEnumerator(String name, int value, Comment comment) {
        this.addEnumerator(name, value, true, comment);
    }

    public void addEnumerator(String name, Comment comment) {
        if (!this.d_user_defined.containsKey(name)) {
            this.d_enumerators.add(name);
        } else {
            this.d_values.remove(name);
            this.d_enumerator_comments.remove(name);
        }
        this.d_enumerator_comments.put(name, comment);
        this.d_user_defined.put(name, new Boolean(false));
    }

    public void addEnumerator(String name, int value, boolean from_user) {
        Integer ivalue = new Integer(value);
        this.d_assigned_values.add(ivalue);
        if (!this.d_user_defined.containsKey(name)) {
            this.d_enumerators.add(name);
        }
        this.d_user_defined.put(name, new Boolean(from_user));
        this.d_values.put(name, ivalue);
    }

    public boolean hasEnumerator(String name) {
        return this.d_user_defined.containsKey(name);
    }

    public List getEnumerators() {
        return this.d_enumerators;
    }

    public Iterator getIterator() {
        return this.d_enumerators.iterator();
    }

    public boolean definedByUser(String name) {
        Object obj = this.d_user_defined.get(name);
        return obj == null ? false : (Boolean)obj;
    }

    public int getEnumeratorValue(String name) {
        int value = 0;
        if (this.d_values.containsKey(name)) {
            value = (Integer)this.d_values.get(name);
        } else {
            value = this.searchForFreeValue();
            this.d_values.put(name, new Integer(value));
        }
        return value;
    }

    public Comment getEnumeratorComment(String name) {
        Object obj = this.d_enumerator_comments.get(name);
        return (Comment)obj;
    }

    private int searchForFreeValue() {
        int value = this.d_next_unused;
        while (this.d_assigned_values.contains(new Integer(value))) {
            ++value;
        }
        this.d_next_unused = value + 1;
        return value;
    }

    public Set getSymbolReferences() {
        return null;
    }

    public Set getAllSymbolReferences() {
        HashSet<SymbolID> result = new HashSet<SymbolID>();
        result.add(this.getSymbolID());
        return result;
    }

    public Set getBasicArrayRefs() {
        return null;
    }
}

