/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForPython;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.io.IOException;

public class Python {
    private static FileManager s_fileMan = FileManager.getInstance();

    public static String getIncludeGuard(Symbol symbol, String modifier) {
        String fullname = symbol.getFullName().replace('.', '_');
        StringBuffer buf = new StringBuffer(2 + fullname.length() + modifier.length());
        buf.append(fullname).append('_').append(modifier.toUpperCase());
        return buf.toString();
    }

    public static String headerFilename(Symbol symbol, String modifier) {
        SymbolID id = symbol.getSymbolID();
        String name = id.getFullName().replace('.', '_');
        StringBuffer buf = new StringBuffer(name.length() + modifier.length() + 3);
        buf.append(name).append('_').append(modifier).append(".h");
        return buf.toString();
    }

    public static String sourceFilename(Symbol symbol, String modifier) {
        SymbolID id = symbol.getSymbolID();
        String longname = id.getFullName().replace('.', '_');
        StringBuffer buf = new StringBuffer(longname.length() + modifier.length() + 3);
        buf.append(longname).append('_').append(modifier).append(".c");
        return buf.toString();
    }

    public static String skelFilename(Symbol symbol, String modifier) {
        String name = symbol.getFullName().replace('.', '_');
        StringBuffer buf = new StringBuffer(name.length() + modifier.length() + 3);
        buf.append(name).append('_').append(modifier).append(".c");
        return buf.toString();
    }

    public static String implFilename(Symbol symbol) {
        return symbol.getSymbolID().getShortName() + "_Impl.py";
    }

    public static String getAPIVarName(Symbol symbol) {
        String fullname = symbol.getFullName().replace('.', '_');
        StringBuffer buf = new StringBuffer(fullname.length() + 5);
        buf.append(fullname).append("__API");
        return buf.toString();
    }

    public static String getInternalGuard(Symbol symbol) {
        String fullname = symbol.getFullName().replace('.', '_');
        StringBuffer buf = new StringBuffer(fullname.length() + 9);
        buf.append(fullname).append("_INTERNAL");
        return buf.toString();
    }

    public static String getCHeaderPath(Symbol symbol, String modifier) {
        return Python.headerFilename(symbol, modifier);
    }

    public static LanguageWriterForC createCHeader(Symbol symbol, String modifier, String description) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        String filename = Python.headerFilename(symbol, modifier);
        LanguageWriterForC lw = null;
        lw = new LanguageWriterForC(s_fileMan.createFile(id, type, "PYMOD_HDRS", filename));
        lw.writeBanner(symbol, filename, true, description);
        return lw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageWriterForC createStub(Symbol symbol, String description) throws CodeGenerationException {
        boolean saveState = s_fileMan.getJavaStylePackageGeneration();
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        String filename = Python.sourceFilename(symbol, "Module");
        LanguageWriterForC lw = null;
        try {
            s_fileMan.setJavaStylePackageGeneration(true);
            lw = new LanguageWriterForC(s_fileMan.createFile(id, type, "PYMOD_SRCS", filename));
            lw.writeBanner(symbol, filename, false, description);
        }
        finally {
            s_fileMan.setJavaStylePackageGeneration(saveState);
        }
        return lw;
    }

    public static LanguageWriterForC createSkel(Symbol symbol, String description) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        String filename = Python.skelFilename(symbol, "pSkel");
        LanguageWriterForC lw = null;
        lw = new LanguageWriterForC(s_fileMan.createFile(id, type, "SKELSRCS", filename));
        lw.writeBanner(symbol, filename, false, description);
        return lw;
    }

    public static LanguageWriterForC createLaunch(Symbol symbol, String description) throws CodeGenerationException {
        String filename = Python.skelFilename(symbol, "pLaunch");
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        LanguageWriterForC lw = null;
        lw = new LanguageWriterForC(s_fileMan.createFile(id, type, "LAUNCHSRCS", filename));
        lw.writeBanner(symbol, filename, false, description);
        return lw;
    }

    public static String getSkelMethod(SymbolID id, Method m) {
        return "pSkel_" + id.getShortName() + "_" + m.getLongMethodName();
    }

    public static String getStubMethod(SymbolID id, Method m) {
        return "pStub_" + id.getShortName() + "_" + m.getLongMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeSplicer getPySplicer(Symbol symbol, String filename) throws IOException {
        boolean saveState = s_fileMan.getJavaStylePackageGeneration();
        try {
            s_fileMan.setJavaStylePackageGeneration(true);
            CodeSplicer codeSplicer = s_fileMan.getCodeSplicer(symbol.getSymbolID(), symbol.getSymbolType(), filename);
            return codeSplicer;
        }
        finally {
            s_fileMan.setJavaStylePackageGeneration(saveState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageWriterForPython createPyWriter(Symbol symbol, String file, String description) throws CodeGenerationException {
        String[] lines;
        boolean saveState = s_fileMan.getJavaStylePackageGeneration();
        LanguageWriterForPython out = null;
        try {
            s_fileMan.setJavaStylePackageGeneration(true);
            out = file.charAt(0) != '_' ? new LanguageWriterForPython(s_fileMan.createFile(symbol.getSymbolID(), symbol.getSymbolType(), "PYTHONSRC", file)) : new LanguageWriterForPython(s_fileMan.createFile(symbol.getSymbolID(), symbol.getSymbolType(), "PYTHONADMIN", file));
        }
        finally {
            s_fileMan.setJavaStylePackageGeneration(saveState);
        }
        Comment comment = symbol.getComment();
        out.writeBanner(symbol, file, false, description);
        if (comment != null && (lines = comment.getComment()) != null) {
            out.println();
            out.print("\"\"\"");
            for (int i = 0; i < lines.length; ++i) {
                out.println(LanguageWriterForPython.toPythonString(lines[i]));
            }
            out.println("\"\"\"");
        }
        out.println();
        return out;
    }

    public static String getSetEPVName(SymbolID id) {
        return IOR.getSymbolName(id) + "__impl_set_epv";
    }

    public static String getSetSEPVName(SymbolID id) {
        return IOR.getSymbolName(id) + "__impl_set_sepv";
    }

    public static String getImport(String className) {
        return className.replace('.', '_') + "__import";
    }

    public static String getExtendableImport(Symbol symbol) {
        String symbolName = symbol.getFullName().replace('.', '_');
        StringBuffer buf = new StringBuffer(symbolName.length() + 8);
        buf.append(symbolName).append("__import");
        return buf.toString();
    }

    public static String getExtendableWrapper(Symbol symbol) {
        String symbolName = symbol.getFullName();
        StringBuffer buf = new StringBuffer(symbolName.length() + 7);
        buf.append(symbolName.replace('.', '_')).append("__wrap");
        return buf.toString();
    }

    public static String getExtendableBorrow(Symbol symbol) {
        String symbolName = symbol.getFullName();
        StringBuffer buf = new StringBuffer(symbolName.length() + 9);
        buf.append(symbolName.replace('.', '_')).append("__weakRef");
        return buf.toString();
    }

    public static String getExceptionType(Symbol symbol) {
        String symbolName = symbol.getFullName();
        StringBuffer buf = new StringBuffer(symbolName.length() + 7);
        buf.append(symbolName.replace('.', '_')).append("__type");
        return buf.toString();
    }

    public static String getExtendableConverter(Symbol symbol) {
        String symbolName = symbol.getFullName();
        StringBuffer buf = new StringBuffer(symbolName.length() + 7);
        buf.append(symbolName.replace('.', '_')).append("__convert");
        return buf.toString();
    }

    public static String getExtendableNewRef(Symbol symbol) {
        String symbolName = symbol.getFullName();
        StringBuffer buf = new StringBuffer(symbolName.length() + 7);
        buf.append(symbolName.replace('.', '_')).append("__newRef");
        return buf.toString();
    }

    public static String getExtendableType(Symbol symbol) {
        String symbolName = symbol.getFullName();
        StringBuffer buf = new StringBuffer(symbolName.length() + 7);
        buf.append(symbolName.replace('.', '_')).append("_PyType");
        return buf.toString();
    }

    public static String getExtendableAddRef(Symbol symbol) {
        String symbolName = symbol.getFullName();
        StringBuffer buf = new StringBuffer(symbolName.length() + 7);
        buf.append(symbolName.replace('.', '_')).append("__addRef");
        return buf.toString();
    }

    public static String getExtendableDeref(Symbol symbol) {
        return symbol.getFullName().replace('.', '_') + "_deref";
    }

    public static String getBorrowArrayFromPython(Type arrayType) {
        if (arrayType == null) {
            return "sidl_generic_borrow_python_array";
        }
        if (arrayType.getType() != 15) {
            return "sidl_" + arrayType.getTypeString() + "__borrow_python_array";
        }
        return arrayType.getSymbolID().getFullName().replace('.', '_') + "__convert_python_array";
    }

    public static String getBorrowArrayFromSIDL(Type arrayType) {
        if (arrayType == null) {
            return BabelConfiguration.getBaseInterface().replace('.', '_') + "__convert_generic_array";
        }
        if (arrayType.getType() != 15) {
            return "sidl_python_borrow_array";
        }
        return arrayType.getSymbolID().getFullName().replace('.', '_') + "__convert_sidl_array";
    }

    public static String getCopyArrayFromPython(Type arrayType) {
        Type elemType = arrayType.getArrayType();
        if (elemType == null) {
            return "sidl_generic_borrow_python_array";
        }
        if (elemType.getType() != 15) {
            if (arrayType.getArrayOrder() == 1) {
                return "sidl_" + elemType.getTypeString() + "__clone_python_array_column";
            }
            if (arrayType.getArrayOrder() == 2) {
                return "sidl_" + elemType.getTypeString() + "__clone_python_array_row";
            }
            return "sidl_" + elemType.getTypeString() + "__borrow_python_array";
        }
        return elemType.getSymbolID().getFullName().replace('.', '_') + "__convert_python_array";
    }

    public static String getCopyArrayFromSIDL(Type arrayType) {
        if (arrayType == null) {
            return BabelConfiguration.getBaseInterface().replace('.', '_') + "__convert_generic_array";
        }
        if (arrayType.getType() != 15) {
            return "sidl_python_clone_array";
        }
        return arrayType.getSymbolID().getFullName().replace('.', '_') + "__convert_sidl_array";
    }

    public static String getDestroyArray(Type arrayType) {
        return "sidl_python_deleteRef_array";
    }
}

