/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included  with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.logger.test;

import org.apache.avalon.excalibur.testcase.ExcaliburTestCase;
import org.apache.avalon.excalibur.testcase.CascadingAssertionFailedError;

import junit.swingui.TestRunner;

/**
 * LogKitManagementTest.
 *
 * @author <a href="mailto:giacomo@apache,org">Giacomo Pati</a>
 * @version CVS $Revision: 1.7 $ $Date: 2001/12/11 09:53:39 $
 */
public class LogKitManagementTestCase
    extends ExcaliburTestCase
{

    public static void main( final String [] args ) throws Exception
    {
        final String[] testCaseName = { LogKitManagementTestCase.class.getName() };
        TestRunner.main( testCaseName );
    }

    public LogKitManagementTestCase( final String name )
    {
        super( name );
    }

    /*
    public void setUp()
        throws Exception
    {
        m_logPriority = Priority.DEBUG;
        super.setUp();
    }
    */

    public void testComponent()
        throws CascadingAssertionFailedError
    {
        TestComponent tc = null;

        try
        {
            tc = (TestComponent) manager.lookup( TestComponent.ROLE + "/A" );
            tc.test( getLogEnabledLogger(), "Test log entry A" );
        }
        catch ( Exception e)
        {
            throw new CascadingAssertionFailedError( "There was an error in the LogKitManagement test", e );
        }
        finally
        {
            assertTrue(  "The test component could not be retrieved.", null != tc );
            manager.release( tc );
        }

        try
        {
            tc = (TestComponent) manager.lookup( TestComponent.ROLE + "/B" );
            tc.test( getLogEnabledLogger(), "Test log entry B" );
        }
        catch ( Exception e)
        {
            throw new CascadingAssertionFailedError( "There was an error in the LogKitManagement test", e );
        }
        finally
        {
            assertTrue(  "The test component could not be retrieved.", null != tc );
            manager.release( tc );
        }

        try
        {
            tc = (TestComponent) manager.lookup( TestComponent.ROLE + "/C" );
            tc.test( getLogEnabledLogger(), "Test log entry C" );
        }
        catch ( Exception e)
        {
            throw new CascadingAssertionFailedError( "There was an error in the LogKitManagement test", e );
        }
        finally
        {
            assertTrue(  "The test component could not be retrieved.", null != tc );
            manager.release( tc );
        }
    }
}
